/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Hour;
import com.jrefinery.data.Second;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Millisecond
extends TimePeriod {
    public static final int FIRST_MILLISECOND_IN_SECOND = 0;
    public static final int LAST_MILLISECOND_IN_SECOND = 999;
    protected int millisecond;
    protected Second second;

    public Millisecond() {
        this(new Date());
    }

    public Millisecond(int n, Second second) {
        this.millisecond = n;
        this.second = second;
    }

    public Millisecond(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Millisecond(Date date, TimeZone timeZone) {
        this.second = new Second(date, timeZone);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.millisecond = calendar.get(14);
    }

    public Second getSecond() {
        return this.second;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public TimePeriod previous() {
        Millisecond millisecond = null;
        if (this.millisecond != 0) {
            millisecond = new Millisecond(this.millisecond - 1, this.second);
        } else {
            Second second = (Second)this.second.previous();
            if (second != null) {
                millisecond = new Millisecond(999, second);
            }
        }
        return millisecond;
    }

    public TimePeriod next() {
        Millisecond millisecond = null;
        if (this.millisecond != 999) {
            millisecond = new Millisecond(this.millisecond + 1, this.second);
        } else {
            Second second = (Second)this.second.next();
            if (second != null) {
                millisecond = new Millisecond(0, second);
            }
        }
        return millisecond;
    }

    public boolean equals(Object object) {
        if (object instanceof Millisecond) {
            Millisecond millisecond = (Millisecond)object;
            return (long)this.millisecond == millisecond.getMillisecond() && this.second.equals(millisecond.getSecond());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Millisecond) {
            Millisecond millisecond = (Millisecond)object;
            long l = this.getStart() - millisecond.getStart();
            n = l > 0L ? 1 : (l < 0L ? -1 : 0);
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getStart() {
        return this.second.getStart() + (long)this.millisecond;
    }

    public long getStart(Calendar calendar) {
        return this.second.getStart(calendar) + (long)this.millisecond;
    }

    public long getEnd() {
        return this.second.getStart() + (long)this.millisecond;
    }

    public long getEnd(Calendar calendar) {
        return this.second.getStart(calendar) + (long)this.millisecond;
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = TimeZone.getAvailableIDs();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Tallinn");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(2002, 2, 21, 16, 55, 59);
        gregorianCalendar.set(14, 123);
        System.out.println("4.55:59.123pm on 21-Mar-2002 in GMT: " + gregorianCalendar.getTime().getTime());
        Date date = new Date(1014307200000L);
        gregorianCalendar.setTime(date);
        Hour hour = new Hour(date);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(timeZone));
        System.out.println("End = " + hour.getEnd(timeZone));
        System.out.println("Offset = " + timeZone.getRawOffset());
    }
}

