/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.Hour;
import com.jrefinery.data.Minute;
import com.jrefinery.data.TimePeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Second
extends TimePeriod {
    private static int FIRST_SECOND_IN_MINUTE = 0;
    private static int LAST_SECOND_IN_MINUTE = 59;
    protected Minute minute;
    protected int second;

    public Second() {
        this(new Date());
    }

    public Second(int n, Minute minute) {
        this.minute = minute;
        this.second = n;
    }

    public Second(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Second(Date date, TimeZone timeZone) {
        this.minute = new Minute(date, timeZone);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.second = calendar.get(13);
    }

    public int getSecond() {
        return this.second;
    }

    public Minute getMinute() {
        return this.minute;
    }

    public TimePeriod previous() {
        Second second = null;
        if (this.second != FIRST_SECOND_IN_MINUTE) {
            second = new Second(this.second - 1, this.minute);
        } else {
            Minute minute = (Minute)this.minute.previous();
            if (minute != null) {
                second = new Second(LAST_SECOND_IN_MINUTE, minute);
            }
        }
        return second;
    }

    public TimePeriod next() {
        Second second = null;
        if (this.second != LAST_SECOND_IN_MINUTE) {
            second = new Second(this.second + 1, this.minute);
        } else {
            Minute minute = (Minute)this.minute.next();
            if (minute != null) {
                second = new Second(FIRST_SECOND_IN_MINUTE, minute);
            }
        }
        return second;
    }

    public boolean equals(Object object) {
        if (object instanceof Second) {
            Second second = (Second)object;
            return this.second == second.getSecond() && this.minute.equals(second.getMinute());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Second) {
            Second second = (Second)object;
            n = this.minute.compareTo(second.minute);
            if (n == 0) {
                n = this.second - second.second;
            }
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getStart(Calendar calendar) {
        return this.minute.getStart(calendar) + (long)this.second * 1000L;
    }

    public long getEnd(Calendar calendar) {
        return this.minute.getStart(calendar) + (long)this.second * 1000L + 999L;
    }

    public static Second parseSecond(String string) {
        Second second = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            int n;
            String string3 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            string3 = string3.trim();
            int n2 = string3.length();
            String string4 = string3.substring(0, Math.min(2, n2));
            String string5 = string3.substring(Math.min(3, n2), Math.min(5, n2));
            String string6 = string3.substring(Math.min(6, n2), Math.min(8, n2));
            int n3 = Integer.parseInt(string4);
            if (n3 >= 0 && n3 <= 23 && (n = Integer.parseInt(string5)) >= 0 && n <= 59) {
                Minute minute = new Minute(n, new Hour(n3, day));
                int n4 = Integer.parseInt(string6);
                if (n4 >= 0 && n4 <= 59) {
                    second = new Second(n4, minute);
                }
            }
        }
        return second;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = TimeZone.getAvailableIDs();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        TimeZone timeZone = TimeZone.getTimeZone("America/Chicago");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.set(2002, 2, 21, 16, 55, 59);
        System.out.println("4.55:59pm on 21-Mar-2002 in Chicago: " + gregorianCalendar.getTime().getTime());
        Date date = new Date(1014307200000L);
        gregorianCalendar.setTime(date);
        Hour hour = new Hour(date);
        System.out.println("Hour = " + hour.toString());
        System.out.println("Start = " + hour.getStart(timeZone));
        System.out.println("End = " + hour.getEnd(timeZone));
        System.out.println("Offset = " + timeZone.getRawOffset());
    }
}

