/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.tigris.toolbar.ToolBar;
import org.tigris.toolbar.toolbutton.PopupToolBoxButton;

public class ToolBarFactory {
    private ToolBarFactory() {
    }

    public static JToolBar createToolBar(Object[] items) {
        return ToolBarFactory.createToolBar(false, "", items, true);
    }

    public static JToolBar createToolBar(boolean rollover, Object[] items) {
        return ToolBarFactory.createToolBar(rollover, items, true);
    }

    public static JToolBar createToolBar(boolean rollover, Object[] items, boolean floatable) {
        return ToolBarFactory.createToolBar(rollover, "", items, floatable);
    }

    public static JToolBar createToolBar(String name, Object[] items) {
        return ToolBarFactory.createToolBar(false, name, items, true);
    }

    public static JToolBar createToolBar(String name, Object[] items, boolean floatable) {
        return ToolBarFactory.createToolBar(false, name, items, floatable);
    }

    public static JToolBar createToolBar(boolean rollover, String name, Object[] items, boolean floatable) {
        ToolBar tb = new ToolBar(name);
        if (rollover) {
            tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        } else {
            tb.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        }
        tb.setFloatable(floatable);
        ToolBarFactory.addItemsToToolBar((JToolBar)tb, items, rollover);
        return tb;
    }

    public static JToolBar createToolBar(Collection items) {
        return ToolBarFactory.createToolBar(false, "", items, true);
    }

    public static JToolBar createToolBar(boolean rollover, Collection items) {
        return ToolBarFactory.createToolBar(rollover, items, true);
    }

    public static JToolBar createToolBar(boolean rollover, Collection items, boolean floatable) {
        return ToolBarFactory.createToolBar(rollover, "", items, floatable);
    }

    public static JToolBar createToolBar(String name, Collection items) {
        return ToolBarFactory.createToolBar(false, name, items, true);
    }

    public static JToolBar createToolBar(String name, Collection items, boolean floatable) {
        return ToolBarFactory.createToolBar(false, name, items, floatable);
    }

    public static JToolBar createToolBar(boolean rollover, String name, Collection items, boolean floatable) {
        ToolBar tb = new ToolBar(name);
        if (rollover) {
            tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        } else {
            tb.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        }
        tb.setFloatable(floatable);
        ToolBarFactory.addItemsToToolBar((JToolBar)tb, items, rollover);
        return tb;
    }

    public static JToolBar createToolBar(JMenu menu) {
        return ToolBarFactory.createToolBar(false, "", menu, true);
    }

    public static JToolBar createToolBar(boolean rollover, JMenu menu) {
        return ToolBarFactory.createToolBar(rollover, menu, true);
    }

    public static JToolBar createToolBar(boolean rollover, JMenu menu, boolean floatable) {
        return ToolBarFactory.createToolBar(rollover, "", menu, floatable);
    }

    public static JToolBar createToolBar(String name, JMenu menu) {
        return ToolBarFactory.createToolBar(false, name, menu, true);
    }

    public static JToolBar createToolBar(String name, JMenu menu, boolean floatable) {
        return ToolBarFactory.createToolBar(false, name, menu, floatable);
    }

    public static JToolBar createToolBar(boolean rollover, String name, JMenu menu, boolean floatable) {
        int count = menu.getMenuComponentCount();
        int iconCount = 0;
        int i = 0;
        while (i < count) {
            Component mi = menu.getMenuComponent(i);
            if (mi instanceof JMenuItem && ((JMenuItem)mi).getIcon() != null) {
                ++iconCount;
            }
            ++i;
        }
        Object[] items = new Action[iconCount];
        iconCount = 0;
        int i2 = 0;
        while (i2 < count) {
            Component mi = menu.getMenuComponent(i2);
            if (mi instanceof JMenuItem && ((JMenuItem)mi).getIcon() != null) {
                items[iconCount++] = ((JMenuItem)mi).getAction();
            }
            ++i2;
        }
        ToolBar tb = new ToolBar(name);
        if (rollover) {
            tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        } else {
            tb.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        }
        tb.setFloatable(floatable);
        ToolBarFactory.addItemsToToolBar((JToolBar)tb, items, rollover);
        return tb;
    }

    private static void addItemsToToolBar(JToolBar toolBar, Object[] items, boolean rollover) {
        int i = 0;
        while (i < items.length) {
            ToolBarFactory.addItemToToolBar(toolBar, items[i], rollover);
            ++i;
        }
    }

    private static void addItemsToToolBar(JToolBar toolBar, Collection items, boolean rollover) {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            ToolBarFactory.addItemToToolBar(toolBar, it.next(), rollover);
        }
    }

    private static void addItemToToolBar(JToolBar toolBar, Object item, boolean rollover) {
        if (item == null) {
            toolBar.addSeparator();
        } else if (item instanceof Action) {
            Action a = (Action)item;
            JButton button = toolBar.add(a);
            if (button.getToolTipText() == null || button.getToolTipText().trim().length() == 0) {
                button.setToolTipText((String)a.getValue("Name"));
            }
        } else if (item instanceof Object[]) {
            Object[] subActions = (Object[])item;
            PopupToolBoxButton button = ToolBarFactory.buildPopupToolBoxButton(subActions, rollover);
            button.setBorderPainted(false);
            toolBar.add(button);
        } else if (item instanceof Component) {
            toolBar.add((Component)item);
        }
    }

    private static PopupToolBoxButton buildPopupToolBoxButton(Object[] actions, boolean rollover) {
        PopupToolBoxButton toolBox = null;
        int i = 0;
        while (i < actions.length) {
            if (actions[i] instanceof Action) {
                Action a = (Action)actions[i];
                if (toolBox == null) {
                    toolBox = new PopupToolBoxButton(a, 0, 1, rollover);
                }
                toolBox.add(a);
            } else if (actions[i] instanceof Object[]) {
                Object[] actionRow = (Object[])actions[i];
                int j = 0;
                while (j < actionRow.length) {
                    Action a = (Action)actionRow[j];
                    if (toolBox == null) {
                        int cols = actionRow.length;
                        toolBox = new PopupToolBoxButton(a, 0, cols, rollover);
                    }
                    toolBox.add(a);
                    ++j;
                }
            }
            ++i;
        }
        return toolBox;
    }
}

