/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class DockBorderLayout
extends BorderLayout {
    private ArrayList north = new ArrayList(1);
    private ArrayList south = new ArrayList(1);
    private ArrayList east = new ArrayList(1);
    private ArrayList west = new ArrayList(1);
    private Component center = null;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;

    public void addLayoutComponent(Component c, Object con) {
        Object object = c.getTreeLock();
        synchronized (object) {
            if (con != null) {
                String s = con.toString();
                if (s.equals("North")) {
                    this.north.add(c);
                } else if (s.equals("South")) {
                    this.south.add(c);
                } else if (s.equals("East")) {
                    this.east.add(c);
                } else if (s.equals("West")) {
                    this.west.add(c);
                } else if (s.equals("Center")) {
                    this.center = c;
                }
            }
        }
    }

    public void removeLayoutComponent(Component c) {
        ((AbstractCollection)this.north).remove(c);
        ((AbstractCollection)this.south).remove(c);
        ((AbstractCollection)this.east).remove(c);
        ((AbstractCollection)this.west).remove(c);
        if (c == this.center) {
            this.center = null;
        }
    }

    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            int northHeight = this.getPreferredDimension((ArrayList)this.north).height;
            int southHeight = this.getPreferredDimension((ArrayList)this.south).height;
            int eastWidth = this.getPreferredDimension((ArrayList)this.east).width;
            int westWidth = this.getPreferredDimension((ArrayList)this.west).width;
            this.placeComponents(this.north, left, top, right - left, northHeight, 0);
            this.placeComponents(this.south, left, bottom - southHeight, right - left, southHeight, 0);
            this.placeComponents(this.east, right - eastWidth, top += northHeight + this.getVgap(), eastWidth, (bottom -= southHeight + this.getVgap()) - top, 1);
            right -= eastWidth + this.getHgap();
            this.placeComponents(this.west, left, top, westWidth, bottom - top, 1);
            left += westWidth + this.getHgap();
            if (this.center != null) {
                this.center.setBounds(left, top, right - left, bottom - top);
            }
        }
    }

    private Dimension getPreferredDimension(ArrayList comps) {
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < comps.size()) {
            Component c = (Component)comps.get(i);
            Dimension d = c.getPreferredSize();
            w = Math.max(w, d.width);
            h = Math.max(h, d.height);
            ++i;
        }
        return new Dimension(w, h);
    }

    private void placeComponents(ArrayList comps, int x, int y, int w, int h, int orientation) {
        int offset = 0;
        Component c = null;
        if (orientation == 0) {
            offset = x;
            int i = 0;
            while (i < comps.size()) {
                c = (Component)comps.get(i);
                int cwidth = c.getPreferredSize().width;
                if (i == comps.size() - 1) {
                    cwidth = w - offset;
                }
                c.setBounds(x + offset, y, cwidth, h);
                offset += cwidth;
                ++i;
            }
        } else {
            int i = 0;
            while (i < comps.size()) {
                c = (Component)comps.get(i);
                int cheight = c.getPreferredSize().height;
                if (i == comps.size() - 1) {
                    cheight = h - offset;
                }
                c.setBounds(x, y + offset, w, cheight);
                offset += cheight;
                ++i;
            }
        }
    }
}

