/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ToolBarUI;
import org.tigris.toolbar.layouts.DockBoundary;
import org.tigris.toolbar.layouts.DockLayout;
import org.tigris.toolbar.layouts.DockingConstraints;

class ToolBarHandler {
    private DockingConstraints ourConstraints = new DockingConstraints();
    private JToolBar ourToolBar = null;
    private DockLayout ourDockLayout = null;
    private JDialog ourFloatFrame = null;
    private DraggingWindow ourDraggingWindow = null;
    private ToolBarDragListener ourDragListener = null;
    private UIChangeListener ourUIListener = null;
    private boolean ourToolBarIsDragging = false;
    private boolean ourToolBarShouldFloat = false;
    private static boolean ourVersionIsCompatible = false;
    public static final String TOOL_BAR_HANDLER_KEY = "ToolBarHandler";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ToolBarHandler(JToolBar toolbar, DockLayout layout) {
        this.ourToolBar = toolbar;
        this.ourDockLayout = layout;
        if (!ourVersionIsCompatible) {
            String specVersion = System.getProperty("java.specification.version");
            try {
                float ver = Float.parseFloat(specVersion);
                if (ver > 1.2f) {
                    ourVersionIsCompatible = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ourVersionIsCompatible) {
            this.ourDragListener = new ToolBarDragListener();
            this.ourUIListener = new UIChangeListener();
            this.installListeners();
        }
    }

    public void setConstraints(DockingConstraints constraints) {
        this.ourConstraints = constraints;
    }

    public DockingConstraints getConstraints() {
        return this.ourConstraints;
    }

    public int getDockEdge() {
        return this.ourConstraints.getEdge();
    }

    public void setDockEdge(int edge) {
        this.ourConstraints.setEdge(edge);
    }

    public int getDockIndex() {
        return this.ourConstraints.getIndex();
    }

    public void setDockIndex(int index) {
        this.ourConstraints.setIndex(index);
    }

    public int getRowIndex() {
        return this.ourConstraints.getRow();
    }

    public void setRowIndex(int index) {
        this.ourConstraints.setRow(index);
    }

    public void hideToolBar() {
        Container target = this.ourDockLayout.getTargetContainer();
        target.remove(this.ourToolBar);
        JDialog floatFrame = this.getFloatingFrame();
        if (floatFrame != null) {
            ((Component)floatFrame).setVisible(false);
            floatFrame.getContentPane().remove(this.ourToolBar);
        }
        target.validate();
        target.repaint();
    }

    public void dockToolBar() {
        this.dockToolBar(this.getDockEdge());
    }

    public void dockToolBar(int edge) {
        this.dockToolBar(edge, this.getRowIndex(), this.getDockIndex());
    }

    public void dockToolBar(int edge, int row, int index) {
        Container target = this.ourDockLayout.getTargetContainer();
        if (target == null) {
            return;
        }
        target.remove(this.ourToolBar);
        JDialog floatFrame = this.getFloatingFrame();
        if (floatFrame != null) {
            ((Component)floatFrame).setVisible(false);
            floatFrame.getContentPane().remove(this.ourToolBar);
        }
        this.ourConstraints.setEdge(edge);
        this.ourConstraints.setRow(row);
        this.ourConstraints.setIndex(index);
        target.add((Component)this.ourToolBar, this.ourConstraints);
        this.ourToolBarShouldFloat = false;
        target.validate();
        target.repaint();
    }

    public void floatToolBar() {
        Point p = this.getFloatingLocation();
        this.floatToolBar(p.x, p.y);
    }

    public void floatToolBar(int x, int y) {
        this.floatToolBar(x, y, false);
    }

    public void floatToolBar(int x, int y, boolean center) {
        JDialog floatFrame = this.getFloatingFrame();
        if (floatFrame == null) {
            return;
        }
        Container target = this.ourDockLayout.getTargetContainer();
        if (target != null) {
            target.remove(this.ourToolBar);
        }
        ((Component)floatFrame).setVisible(false);
        floatFrame.getContentPane().remove(this.ourToolBar);
        this.ourToolBar.setOrientation(0);
        floatFrame.getContentPane().add((Component)this.ourToolBar, "Center");
        floatFrame.pack();
        if (center) {
            x -= floatFrame.getWidth() / 2;
            y -= floatFrame.getHeight() / 2;
        }
        ((Component)floatFrame).setLocation(x, y);
        floatFrame.setTitle(this.ourToolBar.getName());
        ((Component)floatFrame).setVisible(true);
        this.ourToolBarShouldFloat = true;
        if (target != null) {
            target.validate();
            target.repaint();
        }
    }

    public Point getFloatingLocation() {
        JDialog floatFrame = this.getFloatingFrame();
        if (floatFrame != null) {
            return floatFrame.getLocation();
        }
        return new Point(0, 0);
    }

    public void setFloatingLocation(int x, int y) {
        JDialog floatFrame = this.getFloatingFrame();
        if (floatFrame != null) {
            ((Component)floatFrame).setLocation(x, y);
        }
    }

    public boolean shouldFloat() {
        return this.ourToolBarShouldFloat;
    }

    public void setShouldFloat(boolean shouldFloat) {
        this.ourToolBarShouldFloat = shouldFloat;
    }

    private DockBoundary getDockableBoundary(Point point) {
        return this.ourDockLayout.getDockableBoundary(point);
    }

    private boolean isDraggable(Point point, JToolBar toolbar) {
        if (toolbar == null) {
            return false;
        }
        DockBoundary boundary = this.ourDockLayout.getBoundary(point);
        if (boundary == null) {
            return true;
        }
        if (boundary.containsToolBar(toolbar)) {
            return boundary.isDraggablePoint(point, toolbar);
        }
        return true;
    }

    private JDialog getFloatingFrame() {
        if (this.ourFloatFrame == null) {
            Window w = SwingUtilities.getWindowAncestor(this.ourDockLayout.getTargetContainer());
            if (w == null) {
                return null;
            }
            Frame fr = null;
            if (w instanceof Frame) {
                fr = (Frame)w;
            }
            this.ourFloatFrame = new JDialog(fr);
            this.ourFloatFrame.setDefaultCloseOperation(0);
            this.ourFloatFrame.addWindowListener(new FloatFrameCloseListener());
            this.ourFloatFrame.getContentPane().setLayout(new BorderLayout());
            this.ourFloatFrame.setTitle(this.ourToolBar.getName());
            this.ourFloatFrame.setResizable(false);
        }
        return this.ourFloatFrame;
    }

    private DraggingWindow getDraggingWindow() {
        Window w;
        if (this.ourDraggingWindow == null && (w = SwingUtilities.getWindowAncestor(this.ourDockLayout.getTargetContainer())) != null) {
            this.ourDraggingWindow = new DraggingWindow(w);
        }
        return this.ourDraggingWindow;
    }

    public void uninstallListeners() {
        this.ourToolBar.removeMouseListener(this.ourDragListener);
        this.ourToolBar.removeMouseMotionListener(this.ourDragListener);
        this.ourToolBar.removePropertyChangeListener(this.ourUIListener);
    }

    private void installListeners() {
        if (!ourVersionIsCompatible) {
            return;
        }
        this.ourToolBar.removePropertyChangeListener("UI", this.ourUIListener);
        ToolBarUI ui = this.ourToolBar.getUI();
        ui.uninstallUI(this.ourToolBar);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List<EventListener> mList = Arrays.asList(this.ourToolBar.getListeners(clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.awt.event.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List<EventListener> mmList = Arrays.asList(this.ourToolBar.getListeners(clazz2));
        ui.installUI(this.ourToolBar);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.awt.event.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MouseListener[] ml = (MouseListener[])this.ourToolBar.getListeners(clazz3);
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.awt.event.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MouseMotionListener[] mml = (MouseMotionListener[])this.ourToolBar.getListeners(clazz4);
        int i = 0;
        while (i < ml.length) {
            if (!mList.contains(ml[i])) {
                this.ourToolBar.removeMouseListener(ml[i]);
            }
            ++i;
        }
        i = 0;
        while (i < mml.length) {
            if (!mmList.contains(mml[i])) {
                this.ourToolBar.removeMouseMotionListener(mml[i]);
            }
            ++i;
        }
        this.ourToolBar.addMouseListener(this.ourDragListener);
        this.ourToolBar.addMouseMotionListener(this.ourDragListener);
        this.ourToolBar.addPropertyChangeListener("UI", this.ourUIListener);
    }

    private class FloatFrameCloseListener
    extends WindowAdapter {
        FloatFrameCloseListener() {
        }

        public void windowClosing(WindowEvent we) {
            ToolBarHandler.this.dockToolBar(ToolBarHandler.this.getDockEdge(), ToolBarHandler.this.getRowIndex(), ToolBarHandler.this.getDockIndex());
        }
    }

    private class UIChangeListener
    implements PropertyChangeListener {
        UIChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            ToolBarHandler.this.installListeners();
        }
    }

    private class ToolBarDragListener
    extends MouseInputAdapter {
        ToolBarDragListener() {
        }

        public void mouseDragged(MouseEvent me) {
            DockBoundary dock;
            ToolBarHandler.this.ourDraggingWindow = ToolBarHandler.this.getDraggingWindow();
            if (ToolBarHandler.this.ourDraggingWindow == null) {
                return;
            }
            if ((me.getModifiers() & 0x10) != 16) {
                this.hideDraggingWindow();
                return;
            }
            Container target = ToolBarHandler.this.ourDockLayout.getTargetContainer();
            if (target == null) {
                return;
            }
            Point p = me.getPoint();
            p = SwingUtilities.convertPoint(ToolBarHandler.this.ourToolBar, p, target);
            if (!ToolBarHandler.this.isDraggable(p, ToolBarHandler.this.ourToolBar)) {
                this.hideDraggingWindow();
                return;
            }
            int orient = 0;
            boolean dockable = false;
            if (!me.isControlDown() && (dock = ToolBarHandler.this.getDockableBoundary(p)) != null) {
                dockable = true;
                orient = dock.getOrientation();
            }
            SwingUtilities.convertPointToScreen(p, target);
            ToolBarHandler.this.ourDraggingWindow.presentWindow(p, dockable, orient);
            ToolBarHandler.this.ourToolBarIsDragging = true;
        }

        public void mouseReleased(MouseEvent me) {
            if (!ToolBarHandler.this.ourToolBarIsDragging) {
                return;
            }
            if ((me.getModifiers() & 0x10) != 16) {
                return;
            }
            this.hideDraggingWindow();
            Container target = ToolBarHandler.this.ourDockLayout.getTargetContainer();
            if (target == null) {
                return;
            }
            Point p = me.getPoint();
            p = SwingUtilities.convertPoint(ToolBarHandler.this.ourToolBar, p, target);
            DockBoundary dock = null;
            if (!me.isControlDown() && (dock = ToolBarHandler.this.getDockableBoundary(p)) != null) {
                ToolBarHandler.this.setDockIndex(dock.getDockIndex(p));
                ToolBarHandler.this.setRowIndex(dock.getRowIndex(p));
                ToolBarHandler.this.setDockEdge(dock.getEdge());
            }
            if (dock != null) {
                ToolBarHandler.this.dockToolBar(ToolBarHandler.this.getDockEdge(), ToolBarHandler.this.getRowIndex(), ToolBarHandler.this.getDockIndex());
            } else {
                SwingUtilities.convertPointToScreen(p, target);
                ToolBarHandler.this.floatToolBar(p.x, p.y, true);
            }
        }

        private void hideDraggingWindow() {
            if (ToolBarHandler.this.ourDraggingWindow != null) {
                ToolBarHandler.this.ourDraggingWindow.hideWindow();
                ToolBarHandler.this.ourToolBarIsDragging = false;
            }
        }
    }

    private class DraggingWindow
    extends JWindow {
        private Border myFloatBorder = null;
        private Border myDockBorder = null;
        private Color myFloatColor = null;
        private Color myDockColor = null;
        private JPanel myContent = null;

        public DraggingWindow(Window ancestor) {
            super(ancestor);
            Color myFloatColor = UIManager.getColor("ToolBar.floatingForeground");
            Color myDockColor = UIManager.getColor("ToolBar.dockingForeground");
            if (myFloatColor == null) {
                myFloatColor = Color.darkGray;
            }
            if (myDockColor == null) {
                myDockColor = Color.yellow;
            }
            this.myFloatBorder = BorderFactory.createLineBorder(myFloatColor, 3);
            this.myDockBorder = BorderFactory.createLineBorder(myDockColor, 3);
            this.myContent = new JPanel();
            this.myContent.setOpaque(true);
            myFloatColor = UIManager.getColor("ToolBar.floatingBackground");
            myDockColor = UIManager.getColor("ToolBar.dockingBackground");
            if (myFloatColor == null) {
                myFloatColor = this.myContent.getBackground();
            }
            if (myDockColor == null) {
                myDockColor = this.myContent.getBackground();
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.myContent, "Center");
        }

        public void presentWindow(Point screenPoint, boolean dockable, int dockOrientation) {
            this.setCentroidLocation(screenPoint);
            int orientation = dockable ? dockOrientation : 0;
            ((Component)this).setSize(this.getPreferredToolBarSize(orientation));
            this.myContent.setBorder(dockable ? this.myDockBorder : this.myFloatBorder);
            this.myContent.setBackground(dockable ? this.myDockColor : this.myFloatColor);
            this.setCentroidLocation(screenPoint);
            this.validate();
            if (!this.isVisible()) {
                ((Component)this).setVisible(true);
            }
        }

        public void hideWindow() {
            ((Component)this).setVisible(false);
        }

        private void setCentroidLocation(Point screenPoint) {
            ((Component)this).setLocation(screenPoint.x - this.getWidth() / 2, screenPoint.y - this.getHeight() / 2);
        }

        private Point getCentroidLocation() {
            Point p = this.getLocation();
            p.x += this.getWidth() / 2;
            p.y += this.getHeight() / 2;
            return p;
        }

        private Dimension getPreferredToolBarSize(int orientation) {
            Component[] comps = ToolBarHandler.this.ourToolBar.getComponents();
            int w = 0;
            int h = 0;
            int i = 0;
            while (i < comps.length) {
                Dimension d = comps[i].getPreferredSize();
                if (orientation == 0) {
                    w += d.width;
                    h = Math.max(h, d.height);
                } else {
                    w = Math.max(w, d.width);
                    h += d.height;
                }
                ++i;
            }
            return new Dimension(w, h);
        }
    }
}

