/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import org.tigris.toolbar.toolbutton.AbstractButtonAction;
import org.tigris.toolbar.toolbutton.DecoratedIcon;
import org.tigris.toolbar.toolbutton.DropDownIcon;
import org.tigris.toolbar.toolbutton.ModalButton;
import org.tigris.toolbar.toolbutton.PopupToolBox;
import org.tigris.toolbar.toolbutton.ToolButton;

public class PopupToolBoxButton
extends ToolButton {
    private PopupToolBox _popupToolBox;
    private DecoratedIcon _standardIcon;
    private String tooltip;
    private PopupToolBoxButton _this = this;
    private boolean _showSplitter;

    public PopupToolBoxButton(Action a, int rows, int cols, boolean rollover) {
        super(a);
        this.setAction(a);
        this._popupToolBox = new PopupToolBox(rows, cols, rollover);
        MyMouseListener myMouseListener = new MyMouseListener();
        this.addMouseMotionListener(myMouseListener);
        this.addMouseListener(myMouseListener);
    }

    public void setAction(Action a) {
        this._button = new JButton(a);
        Icon realIcon = this._button.getIcon();
        if (a instanceof AbstractButtonAction) {
            realIcon = ((AbstractButtonAction)a).getIcon();
        }
        this.tooltip = this._button.getToolTipText();
        if (this.tooltip == null || this.tooltip.trim().length() == 0) {
            this.tooltip = this._button.getText();
        }
        this._button.setText(null);
        this._standardIcon = new DropDownIcon((ImageIcon)realIcon);
        super.setAction(new ToolButton.ToolButtonAction());
        this.setIcon(this._standardIcon);
        this.setText(null);
        this.setToolTipText(this.tooltip);
    }

    private void popup() {
        final JPopupMenu popup = new JPopupMenu();
        MouseAdapter m = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Component c = e.getComponent();
                if (c instanceof ModalButton) {
                    Action a = ((ModalButton)c).getRealAction();
                    PopupToolBoxButton.this.setAction(a);
                    PopupToolBoxButton.this.setSelected(true);
                    ButtonModel bm = PopupToolBoxButton.this.getModel();
                    bm.setRollover(true);
                    PopupToolBoxButton.this.setBorderPainted(true);
                    bm.setArmed(true);
                }
                popup.setVisible(false);
            }
        };
        this._popupToolBox.setButtonMouseListener(m);
        this._popupToolBox.rebuild();
        popup.add(this._popupToolBox);
        popup.show(this, 0, this.getHeight());
    }

    public JButton add(Action a) {
        return this._popupToolBox.add(a);
    }

    private int getSplitterPosn() {
        return this.getIconPosn() + this._button.getIcon().getIconWidth() + 3;
    }

    private int getIconPosn() {
        int x = (this.getWidth() - this._standardIcon.getIconWidth()) / 2;
        return x;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Color[] colors = new Color[]{this.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlText"), UIManager.getColor("controlHighlight")};
        if (this._showSplitter) {
            this.showSplitter(colors[1], g, this.getSplitterPosn(), 1, this.getHeight() - 4);
            this.showSplitter(colors[3], g, this.getSplitterPosn() + 1, 1, this.getHeight() - 4);
        }
    }

    public void showSplitter(Color c, Graphics g, int x, int y, int height) {
        g.setColor(c);
        g.drawLine(x, y + 0, x, y + height);
    }

    public void showSplitter(boolean show) {
        if (show && !this._showSplitter) {
            this._showSplitter = true;
            this.repaint();
            this.setToolTipText("Select Tool");
        } else if (!show && this._showSplitter) {
            this._showSplitter = false;
            this.repaint();
            this.setToolTipText(this.tooltip);
        }
    }

    protected void performAction(ActionEvent actionEvent) {
        if (this._showSplitter) {
            this.popup();
        } else {
            super.performAction(actionEvent);
        }
    }

    private class MyMouseListener
    extends MouseInputAdapter {
        MyMouseListener() {
        }

        public void mouseMoved(MouseEvent me) {
            PopupToolBoxButton.this.showSplitter(me.getX() >= PopupToolBoxButton.this.getSplitterPosn());
        }

        public void mouseEntered(MouseEvent me) {
            PopupToolBoxButton.this.showSplitter(me.getX() >= PopupToolBoxButton.this.getSplitterPosn());
        }

        public void mouseExited(MouseEvent me) {
            PopupToolBoxButton.this.showSplitter(false);
        }
    }
}

