/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ColumnPermutedStarTable
extends WrapperStarTable {
    private int[] columnMap;

    public ColumnPermutedStarTable(StarTable baseTable, int[] columnMap) {
        super(baseTable);
        this.columnMap = columnMap;
    }

    public int[] getColumnMap() {
        return this.columnMap;
    }

    public void setColumnMap(int[] columnMap) {
        this.columnMap = columnMap;
    }

    public int getColumnCount() {
        return this.columnMap.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.baseTable.getColumnInfo(this.columnMap[icol]);
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(this.baseTable.getRowSequence()){

            public Object getCell(int icol) throws IOException {
                return this.baseSeq.getCell(ColumnPermutedStarTable.this.columnMap[icol]);
            }

            public Object[] getRow() throws IOException {
                return ColumnPermutedStarTable.this.permuteRow(this.baseSeq.getRow());
            }
        };
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.baseTable.getCell(irow, this.columnMap[icol]);
    }

    public Object[] getRow(long irow) throws IOException {
        return this.permuteRow(this.baseTable.getRow(irow));
    }

    private Object[] permuteRow(Object[] baseRow) {
        int ncol = this.columnMap.length;
        Object[] row = new Object[ncol];
        int icol = 0;
        while (icol < ncol) {
            row[icol] = baseRow[this.columnMap[icol]];
            ++icol;
        }
        return row;
    }
}

