/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;

public class ConcatStarTable
extends WrapperStarTable {
    private final StarTable[] tables_;
    private static final RowSequence EMPTY_SEQUENCE = new EmptyRowSequence();

    public ConcatStarTable(StarTable[] tables) {
        super(tables[0]);
        this.tables_ = tables;
    }

    public long getRowCount() {
        long nrow = 0L;
        int i = 0;
        while (i < this.tables_.length) {
            long nr = this.tables_[i].getRowCount();
            if (nr < 0L) {
                return -1L;
            }
            nrow += nr;
            ++i;
        }
        return nrow;
    }

    public boolean isRandom() {
        boolean isRandom = true;
        int i = 0;
        while (isRandom && i < this.tables_.length) {
            isRandom = isRandom && this.tables_[i].isRandom();
            ++i;
        }
        return isRandom;
    }

    public Object getCell(long irow, int icol) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        int itab = 0;
        while (itab < this.tables_.length) {
            StarTable t = this.tables_[itab];
            long nr = t.getRowCount();
            if (irow < nr) {
                return t.getCell(irow, icol);
            }
            irow -= nr;
            ++itab;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to access row beyond end of table");
    }

    public Object[] getRow(long irow) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        int itab = 0;
        while (itab < this.tables_.length) {
            StarTable t = this.tables_[itab];
            long nr = t.getRowCount();
            if (irow < nr) {
                return t.getRow(irow);
            }
            irow -= nr;
            ++itab;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to access row beyond end of table");
    }

    public RowSequence getRowSequence() throws IOException {
        return new ConcatRowSequence();
    }

    private class ConcatRowSequence
    implements RowSequence {
        final Iterator tabIt_;
        RowSequence rseq_;

        private ConcatRowSequence() {
            this.tabIt_ = Arrays.asList(ConcatStarTable.this.tables_).iterator();
            this.rseq_ = EMPTY_SEQUENCE;
        }

        public boolean next() throws IOException {
            while (!this.rseq_.next()) {
                if (this.rseq_ != EMPTY_SEQUENCE) {
                    this.rseq_.close();
                }
                if (this.tabIt_.hasNext()) {
                    this.rseq_ = ((StarTable)((Object)this.tabIt_)).getRowSequence();
                    continue;
                }
                return false;
            }
            return true;
        }

        public void close() throws IOException {
            this.rseq_.close();
        }

        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }
    }
}

