/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import uk.ac.starlink.table.ValueInfo;

public class DescribedValue {
    private final ValueInfo vinfo;
    private Object value;

    public DescribedValue(ValueInfo vinfo) {
        this.vinfo = vinfo;
    }

    public DescribedValue(ValueInfo vinfo, Object value) {
        this(vinfo);
        this.setValue(value);
    }

    public ValueInfo getInfo() {
        return this.vinfo;
    }

    public void setValue(Object value) {
        Class cclass = this.vinfo.getContentClass();
        if (cclass == null) {
            throw new IllegalArgumentException("ValueInfo " + this.vinfo + " has no contentClass set");
        }
        if (value != null && !cclass.isInstance(value)) {
            throw new IllegalArgumentException("Value " + value + " is not a " + cclass.getName());
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString(int maxLength) {
        return this.vinfo.formatValue(this.getValue(), maxLength);
    }

    public String toString(int maxLength) {
        StringBuffer buf = new StringBuffer(this.vinfo.toString());
        buf.append("=").append(this.getValueAsString(maxLength - buf.length()));
        if (buf.length() > maxLength) {
            buf.setLength(maxLength - 3);
            buf.append("...");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(70);
    }
}

