/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ExplodedStarTable
extends WrapperStarTable {
    private final StarTable baseTable_;
    private final ColPointer[] pointers_;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public ExplodedStarTable(StarTable baseTable) {
        super(baseTable);
        this.baseTable_ = baseTable;
        ArrayList<ColPointer> colList = new ArrayList<ColPointer>();
        int i = 0;
        while (i < baseTable.getColumnCount()) {
            String[] labels;
            ColumnInfo baseInfo = baseTable.getColumnInfo(i);
            String[] stringArray = labels = baseInfo.isArray() ? Tables.getElementLabels(baseInfo.getShape()) : null;
            if (labels == null) {
                colList.add(new ColPointer(i));
            } else {
                int j = 0;
                while (j < labels.length) {
                    colList.add(new ColPointer(i, j, labels[j]));
                    ++j;
                }
            }
            ++i;
        }
        this.pointers_ = colList.toArray(new ColPointer[0]);
    }

    public int getColumnCount() {
        return this.pointers_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        ColPointer pointer = this.pointers_[icol];
        ColumnInfo baseInfo = this.baseTable_.getColumnInfo(pointer.getBaseIndex());
        if (pointer.getSubIndex() < 0) {
            return baseInfo;
        }
        int subIndex = pointer.getSubIndex();
        int subIndex1 = subIndex + 1;
        ColumnInfo info = new ColumnInfo(baseInfo);
        info.setContentClass(ExplodedStarTable.getComponentType(info.getContentClass()));
        info.setName(info.getName() + pointer.getLabel());
        String desc = info.getDescription();
        desc = desc == null || desc.length() == 0 ? baseInfo.getName() + " element #" + subIndex1 : desc + " (element #" + subIndex1 + ")";
        info.setDescription(desc);
        return info;
    }

    public Object getCell(long irow, int icol) throws IOException {
        ColPointer pointer = this.pointers_[icol];
        Object baseCell = this.baseTable.getCell(irow, pointer.getBaseIndex());
        return this.translateCell(pointer, baseCell);
    }

    public Object[] getRow(long irow) throws IOException {
        return this.translateRow(this.baseTable.getRow(irow));
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(this.baseTable_.getRowSequence()){

            public Object getCell(int icol) throws IOException {
                ColPointer pointer = ExplodedStarTable.this.pointers_[icol];
                Object baseCell = super.getCell(pointer.getBaseIndex());
                return ExplodedStarTable.this.translateCell(pointer, baseCell);
            }

            public Object[] getRow() throws IOException {
                return ExplodedStarTable.this.translateRow(super.getRow());
            }
        };
    }

    private Object translateCell(ColPointer pointer, Object baseCell) {
        if (pointer.getSubIndex() < 0 || baseCell == null || !baseCell.getClass().isArray()) {
            return baseCell;
        }
        return Array.get(baseCell, pointer.getSubIndex());
    }

    private Object[] translateRow(Object[] baseRow) {
        int ncol = this.pointers_.length;
        Object[] row = new Object[ncol];
        int icol = 0;
        while (icol < ncol) {
            ColPointer pointer = this.pointers_[icol];
            Object baseCell = baseRow[pointer.getBaseIndex()];
            row[icol] = this.translateCell(pointer, baseCell);
            ++icol;
        }
        return row;
    }

    private static Class getComponentType(Class aclazz) {
        Class<?> clazz = aclazz.getComponentType();
        if (clazz == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExplodedStarTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ExplodedStarTable.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ExplodedStarTable.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (clazz == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ExplodedStarTable.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ExplodedStarTable.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = ExplodedStarTable.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (clazz == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ExplodedStarTable.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ExplodedStarTable.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ColPointer {
        final int baseIndex_;
        final int subIndex_;
        final String label_;

        public ColPointer(int baseIndex, int subIndex, String label) {
            this.baseIndex_ = baseIndex;
            this.subIndex_ = subIndex;
            this.label_ = label;
        }

        public ColPointer(int baseIndex) {
            this(baseIndex, -1, null);
        }

        public int getBaseIndex() {
            return this.baseIndex_;
        }

        public int getSubIndex() {
            return this.subIndex_;
        }

        public String getLabel() {
            return this.label_;
        }
    }
}

