/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ProgressLineStarTable
extends WrapperStarTable {
    private static final char[] SPINNER = new char[]{'|', '/', '-', '\\'};
    private static final int INTERVAL = 500;
    private static final int INITIAL_WAIT = 1000;
    private final PrintStream out_;

    public ProgressLineStarTable(StarTable baseTable, PrintStream out) {
        super(baseTable);
        this.out_ = out;
    }

    public RowSequence getRowSequence() throws IOException {
        long nrow = this.getRowCount();
        final ProgressShower ps = nrow > 0L ? new DeterminateProgressShower(nrow) : new IndeterminateProgressShower();
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            boolean started;
            long alarm;
            long irow;
            {
                super(x0);
                this.started = false;
                this.alarm = System.currentTimeMillis() + 1000L;
                this.irow = 0L;
            }

            public boolean next() throws IOException {
                if (super.next()) {
                    ++this.irow;
                    if (System.currentTimeMillis() > this.alarm) {
                        this.alarm = System.currentTimeMillis() + 500L;
                        ProgressLineStarTable.this.out_.print(ps.getProgressLine(this.irow));
                        this.started = true;
                    }
                    return true;
                }
                return false;
            }

            public void close() throws IOException {
                if (this.started) {
                    ProgressLineStarTable.this.out_.println(ps.getFinishedLine(this.irow));
                }
                super.close();
            }
        };
    }

    private static class DeterminateProgressShower
    extends ProgressShower {
        int progCount = 0;
        final long nRow;
        final String nRowString;
        final int nDigit;

        DeterminateProgressShower(long nRow) {
            this.nRow = nRow;
            this.nRowString = Long.toString(nRow);
            this.nDigit = this.nRowString.length();
        }

        String getProgressLine(long irow) {
            StringBuffer buf = new StringBuffer().append('\r').append(' ').append(SPINNER[this.progCount]).append(' ');
            this.progCount = (this.progCount + 1) % SPINNER.length;
            String rowCountString = Long.toString(irow);
            int pad = this.nDigit - rowCountString.length();
            int i = 0;
            while (i < pad) {
                buf.append(' ');
                ++i;
            }
            buf.append(rowCountString).append('/').append(this.nRowString).append(' ').append('|');
            int nLeft = 78 - buf.length();
            int nDone = (int)(irow * (long)nLeft / this.nRow);
            int i2 = 0;
            while (i2 < nLeft) {
                buf.append(i2 < nDone ? (char)'+' : ' ');
                ++i2;
            }
            buf.append('|').append('\r');
            return buf.toString();
        }

        String getFinishedLine(long irow) {
            StringBuffer buf = new StringBuffer(this.getProgressLine(irow));
            buf.setCharAt(2, ' ');
            return buf.toString();
        }
    }

    private static class IndeterminateProgressShower
    extends ProgressShower {
        int progCount;

        private IndeterminateProgressShower() {
        }

        String getProgressLine(long irow) {
            StringBuffer buf = new StringBuffer().append('\r').append(SPINNER[this.progCount]).append(' ').append(irow).append('\r');
            this.progCount = (this.progCount + 1) % SPINNER.length;
            return buf.toString();
        }

        String getFinishedLine(long irow) {
            return "" + '\r' + ' ' + ' ' + irow + ' ' + "(done)" + '\r';
        }
    }

    private static abstract class ProgressShower {
        private ProgressShower() {
        }

        abstract String getProgressLine(long var1);

        abstract String getFinishedLine(long var1);
    }
}

