/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableTransferable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.util.Loader;

public class StarTableOutput {
    private List handlers = new ArrayList();
    private JDBCHandler jdbcHandler;
    private static String[] defaultHandlerClasses = new String[]{"uk.ac.starlink.votable.FitsPlusTableWriter", "uk.ac.starlink.fits.FitsTableWriter", "uk.ac.starlink.votable.VOTableWriter", (class$uk$ac$starlink$table$formats$TextTableWriter == null ? (class$uk$ac$starlink$table$formats$TextTableWriter = StarTableOutput.class$("uk.ac.starlink.table.formats.TextTableWriter")) : class$uk$ac$starlink$table$formats$TextTableWriter).getName(), (class$uk$ac$starlink$table$formats$AsciiTableWriter == null ? (class$uk$ac$starlink$table$formats$AsciiTableWriter = StarTableOutput.class$("uk.ac.starlink.table.formats.AsciiTableWriter")) : class$uk$ac$starlink$table$formats$AsciiTableWriter).getName(), (class$uk$ac$starlink$table$formats$CsvTableWriter == null ? (class$uk$ac$starlink$table$formats$CsvTableWriter = StarTableOutput.class$("uk.ac.starlink.table.formats.CsvTableWriter")) : class$uk$ac$starlink$table$formats$CsvTableWriter).getName(), (class$uk$ac$starlink$table$formats$HTMLTableWriter == null ? (class$uk$ac$starlink$table$formats$HTMLTableWriter = StarTableOutput.class$("uk.ac.starlink.table.formats.HTMLTableWriter")) : class$uk$ac$starlink$table$formats$HTMLTableWriter).getName(), (class$uk$ac$starlink$table$formats$LatexTableWriter == null ? (class$uk$ac$starlink$table$formats$LatexTableWriter = StarTableOutput.class$("uk.ac.starlink.table.formats.LatexTableWriter")) : class$uk$ac$starlink$table$formats$LatexTableWriter).getName(), "uk.ac.starlink.mirage.MirageTableWriter"};
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table");
    private StarTableWriter voWriter;
    private Method voWriteMethod;
    public static final String AUTO_HANDLER = "(auto)";
    public static final String EXTRA_WRITERS_PROPERTY = "startable.writers";
    static /* synthetic */ Class class$uk$ac$starlink$table$formats$TextTableWriter;
    static /* synthetic */ Class class$uk$ac$starlink$table$formats$AsciiTableWriter;
    static /* synthetic */ Class class$uk$ac$starlink$table$formats$CsvTableWriter;
    static /* synthetic */ Class class$uk$ac$starlink$table$formats$HTMLTableWriter;
    static /* synthetic */ Class class$uk$ac$starlink$table$formats$LatexTableWriter;
    static /* synthetic */ Class class$uk$ac$starlink$table$StarTableWriter;
    static /* synthetic */ Class class$uk$ac$starlink$table$StarTable;
    static /* synthetic */ Class class$java$io$OutputStream;

    public StarTableOutput() {
        int i = 0;
        while (i < defaultHandlerClasses.length) {
            String className = defaultHandlerClasses[i];
            try {
                this.getClass();
                Class<?> clazz = Class.forName(className);
                StarTableWriter[] writers = null;
                try {
                    Class<?> retClass;
                    Method getList = clazz.getMethod("getStarTableWriters", new Class[0]);
                    int mods = getList.getModifiers();
                    if (Modifier.isStatic(mods) && Modifier.isPublic(mods) && (retClass = getList.getReturnType()).isArray() && (class$uk$ac$starlink$table$StarTableWriter == null ? StarTableOutput.class$("uk.ac.starlink.table.StarTableWriter") : class$uk$ac$starlink$table$StarTableWriter).isAssignableFrom(retClass.getComponentType())) {
                        writers = (StarTableWriter[])getList.invoke(null, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (writers != null) {
                    int j = 0;
                    while (j < writers.length) {
                        void handler = writers[j];
                        this.handlers.add(handler);
                        logger.config("Handler " + handler.getFormatName() + " registered");
                        ++j;
                    }
                } else {
                    StarTableWriter handler = (StarTableWriter)clazz.newInstance();
                    this.handlers.add(handler);
                    logger.config("Handler " + handler.getFormatName() + " registered");
                }
            }
            catch (ClassNotFoundException e) {
                logger.config(className + " not found - can't register");
            }
            catch (Exception e) {
                logger.config("Failed to register " + className + " - " + e);
            }
            ++i;
        }
        this.handlers.addAll(Loader.getClassInstances(EXTRA_WRITERS_PROPERTY, class$uk$ac$starlink$table$StarTableWriter == null ? (class$uk$ac$starlink$table$StarTableWriter = StarTableOutput.class$("uk.ac.starlink.table.StarTableWriter")) : class$uk$ac$starlink$table$StarTableWriter));
        this.initializeForTransferables();
    }

    public List getHandlers() {
        return this.handlers;
    }

    public void setHandlers(StarTableWriter[] handlers) {
        this.handlers = new ArrayList<StarTableWriter>(Arrays.asList(handlers));
    }

    public void writeStarTable(StarTable startab, String location, String format) throws TableFormatException, IOException {
        if (location.startsWith("jdbc:")) {
            try {
                this.getJDBCHandler().createJDBCTable(startab, location);
                return;
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        this.getHandler(format, location).writeStarTable(startab, location, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, OutputStream out, StarTableWriter handler) throws IOException {
        try {
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            handler.writeStarTable(startab, out);
            out.flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public OutputStream getOutputStream(String location) throws IOException {
        if (location.equals("-")) {
            return System.out;
        }
        File file = new File(location);
        if (file.exists()) {
            if (file.delete()) {
                logger.info("Deleting file \"" + location + "\" prior to overwriting");
            } else {
                throw new IOException("Can't delete \"" + location + "\" prior to overwriting");
            }
        }
        return new FileOutputStream(file);
    }

    public StarTableWriter getHandler(String format) throws TableFormatException {
        block8: {
            if (format.equals(AUTO_HANDLER)) {
                throw new TableFormatException(format + " does not name a " + "specific output handler");
            }
            try {
                StarTableWriter handler;
                this.getClass();
                Class<?> fcls = Class.forName(format);
                if (!(class$uk$ac$starlink$table$StarTableWriter == null ? (class$uk$ac$starlink$table$StarTableWriter = StarTableOutput.class$("uk.ac.starlink.table.StarTableWriter")) : class$uk$ac$starlink$table$StarTableWriter).isAssignableFrom(fcls)) break block8;
                Iterator it = this.handlers.iterator();
                while (it.hasNext()) {
                    handler = (StarTableWriter)it.next();
                    if (!fcls.isInstance(handler)) continue;
                    return handler;
                }
                try {
                    handler = (StarTableWriter)fcls.newInstance();
                    return handler;
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            StarTableWriter handler = (StarTableWriter)it.next();
            if (!handler.getFormatName().toLowerCase().startsWith(format.toLowerCase())) continue;
            return handler;
        }
        throw new TableFormatException("No handler for table format \"" + format + "\"");
    }

    public StarTableWriter getHandler(String format, String location) throws TableFormatException {
        if (format != null && format.length() > 0 && !AUTO_HANDLER.equals(format)) {
            return this.getHandler(format);
        }
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            StarTableWriter handler = (StarTableWriter)it.next();
            if (!handler.looksLikeFile(location)) continue;
            return handler;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("No handler specified for writing table.\n").append("Known formats: ");
        Iterator it2 = this.getKnownFormats().iterator();
        while (it2.hasNext()) {
            msg.append(it2.next());
            if (!it2.hasNext()) continue;
            msg.append(", ");
        }
        throw new TableFormatException(msg.toString());
    }

    public List getKnownFormats() {
        ArrayList<String> kf = new ArrayList<String>();
        kf.add("jdbc");
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            kf.add(((StarTableWriter)it.next()).getFormatName());
        }
        return kf;
    }

    public JDBCHandler getJDBCHandler() {
        if (this.jdbcHandler == null) {
            this.jdbcHandler = new JDBCHandler();
        }
        return this.jdbcHandler;
    }

    public void setJDBCHandler(JDBCHandler handler) {
        this.jdbcHandler = handler;
    }

    public Transferable transferStarTable(StarTable startab) {
        if (this.voWriteMethod != null) {
            return new StarTableTransferable(this, startab);
        }
        return null;
    }

    private void initializeForTransferables() {
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            StarTableWriter handler = (StarTableWriter)it.next();
            if (!handler.getFormatName().equals("votable-binary-inline")) continue;
            try {
                Class[] args = new Class[]{class$uk$ac$starlink$table$StarTable == null ? StarTableOutput.class$("uk.ac.starlink.table.StarTable") : class$uk$ac$starlink$table$StarTable, class$java$io$OutputStream == null ? StarTableOutput.class$("java.io.OutputStream") : class$java$io$OutputStream};
                this.voWriteMethod = handler.getClass().getMethod("writeStarTable", args);
                this.voWriter = handler;
            }
            catch (NoSuchMethodException e) {
                this.voWriter = null;
            }
        }
        if (this.voWriteMethod == null) {
            logger.warning("No transferable serializer found");
        }
    }

    void transferTable(StarTable table, OutputStream ostrm) throws IOException {
        try {
            this.voWriteMethod.invoke((Object)this.voWriter, table, ostrm);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            System.err.println("Reflection trouble!");
            target.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

