/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class CsvStarTable
extends StreamStarTable {
    private boolean hasHeading_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$formats$CsvStarTable;

    public CsvStarTable(DataSource datsrc) throws TableFormatException, IOException {
        super(datsrc);
    }

    protected PushbackInputStream getInputStream() throws IOException {
        PushbackInputStream in = super.getInputStream();
        if (this.hasHeading_) {
            this.readRow(in);
        }
        return in;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StreamStarTable.Metadata obtainMetadata() throws TableFormatException, IOException {
        boolean isDataRow;
        StreamStarTable.RowEvaluator evaluator;
        String[] row0;
        block16: {
            PushbackInputStream in = super.getInputStream();
            row0 = this.readRow(in).toArray(new String[0]);
            evaluator = new StreamStarTable.RowEvaluator();
            long lrow = 0L;
            try {
                try {
                    List row;
                    while ((row = this.readRow(in)) != null) {
                        void var6_5;
                        ++lrow;
                        evaluator.submitRow((List)var6_5);
                    }
                }
                catch (TableFormatException e) {
                    throw new TableFormatException(e.getMessage() + " at row " + lrow, e);
                }
                Object var8_7 = null;
                if (in == null) break block16;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
        }
        StreamStarTable.Metadata meta = evaluator.getMetadata();
        if (meta.nrow_ == 0L) {
            throw new TableFormatException("No rows");
        }
        ColumnInfo[] colinfos = meta.colInfos_;
        StreamStarTable.Decoder[] decoders = meta.decoders_;
        int ncol = meta.ncol_;
        long nrow = meta.nrow_;
        if (row0.length != ncol) {
            this.hasHeading_ = true;
            return new StreamStarTable.Metadata(colinfos, decoders, nrow);
        }
        try {
            int icol = 0;
            while (true) {
                if (icol >= ncol) {
                    isDataRow = true;
                    break;
                }
                decoders[icol].decode(row0[icol]);
                ++icol;
            }
        }
        catch (Exception e) {
            isDataRow = false;
        }
        if (isDataRow) {
            return new StreamStarTable.Metadata(colinfos, decoders, ++nrow);
        }
        if (!$assertionsDisabled && isDataRow) {
            throw new AssertionError();
        }
        this.hasHeading_ = true;
        int icol = 0;
        while (icol < ncol) {
            String h = row0[icol];
            if (h != null && h.trim().length() > 0) {
                colinfos[icol].setName(h);
            }
            ++icol;
        }
        return new StreamStarTable.Metadata(colinfos, decoders, nrow);
    }

    protected List readRow(PushbackInputStream in) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean discard = false;
        boolean endFile = false;
        while (cellList.size() == 0 && !endFile) {
            boolean endLine = false;
            block8: while (!endLine) {
                char c = (char)in.read();
                switch (c) {
                    case '\uffff': {
                        endFile = true;
                    }
                    case '\n': 
                    case '\r': {
                        if (discard) {
                            discard = false;
                        } else if (cellList.size() > 0) {
                            cellList.add(buffer.toString().trim());
                        }
                        buffer.setLength(0);
                        endLine = true;
                        break;
                    }
                    case ',': {
                        if (discard) {
                            discard = false;
                        } else {
                            cellList.add(buffer.toString().trim());
                        }
                        buffer.setLength(0);
                        break;
                    }
                    case '\"': {
                        if (buffer.toString().trim().length() > 0) {
                            throw new TableFormatException("Mixed quoted/unquoted cell '" + buffer + "'");
                        }
                        cellList.add(this.readString(in));
                        discard = true;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (discard) continue block8;
                        buffer.append(c);
                        break;
                    }
                    default: {
                        if (discard) {
                            throw new TableFormatException("Mixed quoted/unquoted cell '" + c + "'");
                        }
                        buffer.append(c);
                    }
                }
            }
        }
        return cellList.size() == 0 ? null : cellList;
    }

    private String readString(PushbackInputStream in) throws IOException {
        StringBuffer buffer = new StringBuffer();
        block4: while (true) {
            char c = (char)in.read();
            switch (c) {
                case '\"': {
                    char c2 = (char)in.read();
                    if (c2 == '\"') {
                        buffer.append('\"');
                        continue block4;
                    }
                    if (c2 != '\uffff') {
                        in.unread(c2);
                    }
                    return buffer.toString();
                }
                case '\uffff': {
                    throw new TableFormatException("End of file within a string literal");
                }
            }
            buffer.append(c);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$formats$CsvStarTable == null ? (class$uk$ac$starlink$table$formats$CsvStarTable = CsvStarTable.class$("uk.ac.starlink.table.formats.CsvStarTable")) : class$uk$ac$starlink$table$formats$CsvStarTable).desiredAssertionStatus();
    }
}

