/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.Tables;

public class HTMLTableWriter
extends StreamStarTableWriter {
    private boolean standalone;

    public HTMLTableWriter() {
        this(true);
    }

    public HTMLTableWriter(boolean standalone) {
        this.setStandalone(standalone);
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public String getFormatName() {
        return this.standalone ? "HTML" : "HTML-element";
    }

    public boolean looksLikeFile(String location) {
        return location.endsWith(".html") || location.endsWith(".htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable table, OutputStream ostrm) throws IOException {
        RowSequence rseq = table.getRowSequence();
        try {
            if (this.standalone) {
                this.printHeader(ostrm, table);
            }
            StringBuffer sbuf = new StringBuffer();
            this.printLine(ostrm, "<TABLE BORDER='1'>");
            String tname = table.getName();
            if (tname != null) {
                this.printLine(ostrm, "<CAPTION><STRONG>" + tname + "</STRONG></CAPTION>");
            }
            sbuf = new StringBuffer();
            int ncol = table.getColumnCount();
            ColumnInfo[] colinfos = Tables.getColumnInfos(table);
            String[] names = new String[ncol];
            String[] units = new String[ncol];
            boolean hasUnits = false;
            int icol = 0;
            while (icol < ncol) {
                ColumnInfo colinfo = colinfos[icol];
                String name = colinfo.getName();
                String unit = colinfo.getUnitString();
                if (unit != null) {
                    hasUnits = true;
                    unit = "(" + unit + ")";
                }
                names[icol] = name;
                units[icol] = unit;
                ++icol;
            }
            String[] headings = new String[ncol];
            int icol2 = 0;
            while (icol2 < ncol) {
                String heading = names[icol2];
                String unit = units[icol2];
                if (hasUnits) {
                    heading = heading + "<br>";
                    if (unit != null) {
                        heading = heading + "(" + unit + ")";
                    }
                }
                headings[icol2] = heading;
                ++icol2;
            }
            this.outputRow(ostrm, "TH", null, names);
            if (hasUnits) {
                this.outputRow(ostrm, "TH", null, units);
            }
            this.printLine(ostrm, "<TR><TD colspan='" + ncol + "'></TD></TR>");
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                String[] cells = new String[ncol];
                int icol3 = 0;
                while (icol3 < ncol) {
                    cells[icol3] = this.escape(colinfos[icol3].formatValue(row[icol3], 200));
                    if (cells[icol3].length() == 0) {
                        cells[icol3] = "&nbsp;";
                    }
                    ++icol3;
                }
                this.outputRow(ostrm, "TD", null, cells);
            }
            this.printLine(ostrm, "</TABLE>");
            if (this.standalone) {
                this.printFooter(ostrm);
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
    }

    public static StarTableWriter[] getStarTableWriters() {
        return new StarTableWriter[]{new HTMLTableWriter(true), new HTMLTableWriter(false)};
    }

    private void outputRow(OutputStream ostrm, String tagname, String attlist, String[] values) throws IOException {
        int ncol = values.length;
        this.printLine(ostrm, "<TR>");
        StringBuffer sbuf = new StringBuffer();
        int icol = 0;
        while (icol < ncol) {
            sbuf.append(' ').append('<').append(tagname);
            if (attlist != null) {
                sbuf.append(" " + attlist);
            }
            sbuf.append('>');
            if (values[icol] != null) {
                sbuf.append(values[icol]);
            }
            sbuf.append("</").append(tagname).append(">");
            ++icol;
        }
        this.printLine(ostrm, sbuf.toString());
        this.printLine(ostrm, "</TR>");
    }

    private void printLine(OutputStream ostrm, String str) throws IOException {
        ostrm.write(str.getBytes());
        ostrm.write(10);
    }

    protected void printHeader(OutputStream ostrm, StarTable table) throws IOException {
        this.printLine(ostrm, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        this.printLine(ostrm, "<html>");
        String tname = table.getName();
        if (tname != null) {
            this.printLine(ostrm, "<head><title>Table " + this.escape(tname) + "</title></head>");
        }
        this.printLine(ostrm, "<body>");
    }

    protected void printFooter(OutputStream ostrm) throws IOException {
        this.printLine(ostrm, "</body>");
        this.printLine(ostrm, "</html>");
    }

    private String escape(String line) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            char chr = line.charAt(i);
            switch (chr) {
                case '&': {
                    sbuf.append("&amp;");
                    break;
                }
                case '<': {
                    sbuf.append("&lt;");
                    break;
                }
                case '>': {
                    sbuf.append("&gt;");
                    break;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    break;
                }
                case '\'': {
                    sbuf.append("&apos;");
                    break;
                }
                default: {
                    sbuf.append(chr > '\u0000' && chr < '\u00fe' ? chr : (char)'?');
                }
            }
            ++i;
        }
        return sbuf.toString();
    }
}

