/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ReaderRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.DataSource;

public abstract class StreamStarTable
extends AbstractStarTable {
    private final DataSource datsrc_;
    private final int ncol_;
    private final long nrow_;
    private final Decoder[] decoders_;
    private final ColumnInfo[] colInfos_;
    protected static final char END = '\uffff';
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    protected StreamStarTable(DataSource datsrc) throws TableFormatException, IOException {
        this.datsrc_ = datsrc;
        Metadata meta = this.obtainMetadata();
        this.decoders_ = meta.decoders_;
        this.colInfos_ = meta.colInfos_;
        this.nrow_ = meta.nrow_;
        this.ncol_ = meta.ncol_;
        this.setName(this.datsrc_.getName());
        this.setURL(datsrc.getURL());
    }

    public int getColumnCount() {
        return this.ncol_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public RowSequence getRowSequence() throws IOException {
        final PushbackInputStream in = this.getInputStream();
        final int ncol = this.getColumnCount();
        return new ReaderRowSequence(){

            protected Object[] readRow() throws IOException {
                List cellList = StreamStarTable.this.readRow(in);
                if (cellList == null) {
                    in.close();
                    return null;
                }
                Object[] row = new Object[ncol];
                int icol = 0;
                while (icol < ncol) {
                    String sval = (String)cellList.get(icol);
                    if (sval != null && sval.length() > 0) {
                        row[icol] = StreamStarTable.this.decoders_[icol].decode(sval);
                    }
                    ++icol;
                }
                return row;
            }

            public void close() throws IOException {
                in.close();
            }
        };
    }

    protected PushbackInputStream getInputStream() throws IOException {
        return new PushbackInputStream(new BufferedInputStream(this.datsrc_.getInputStream()));
    }

    protected abstract Metadata obtainMetadata() throws TableFormatException, IOException;

    protected abstract List readRow(PushbackInputStream var1) throws TableFormatException, IOException;

    private static ParsedFloat parseFloating(String item) {
        int nc = item.length();
        boolean foundExp = false;
        int sigFig = 0;
        int i = 0;
        while (i < nc) {
            char c = item.charAt(i);
            switch (c) {
                case 'D': 
                case 'd': {
                    if (!foundExp) {
                        StringBuffer sbuf = new StringBuffer(item);
                        sbuf.setCharAt(i, 'e');
                        item = sbuf.toString();
                    }
                    foundExp = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    foundExp = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (foundExp) break;
                    ++sigFig;
                    break;
                }
            }
            ++i;
        }
        double dvalue = Double.parseDouble(item);
        return ParsedFloat.getInstance(sigFig, dvalue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParsedFloat {
        static ParsedFloat instance = new ParsedFloat();
        int sigFig;
        double dValue;

        private ParsedFloat() {
        }

        static ParsedFloat getInstance(int sigFig, double dValue) {
            ParsedFloat.instance.sigFig = sigFig;
            ParsedFloat.instance.dValue = dValue;
            return instance;
        }
    }

    protected static class RowEvaluator {
        private boolean[] maybeBoolean_;
        private boolean[] maybeShort_;
        private boolean[] maybeInteger_;
        private boolean[] maybeLong_;
        private boolean[] maybeFloat_;
        private boolean[] maybeDouble_;
        private int[] stringLength_;
        private long nrow_;
        private int ncol_;

        protected RowEvaluator() {
        }

        private void init(int ncol) {
            this.ncol_ = ncol;
            this.maybeBoolean_ = this.makeFlagArray(true);
            this.maybeShort_ = this.makeFlagArray(true);
            this.maybeInteger_ = this.makeFlagArray(true);
            this.maybeLong_ = this.makeFlagArray(true);
            this.maybeFloat_ = this.makeFlagArray(true);
            this.maybeDouble_ = this.makeFlagArray(true);
            this.stringLength_ = new int[ncol];
        }

        public void submitRow(List row) throws TableFormatException {
            if (this.nrow_++ == 0L) {
                this.init(row.size());
            }
            if (row.size() != this.ncol_) {
                throw new TableFormatException("Wrong number of columns at row " + this.nrow_ + " (expecting " + this.ncol_ + ", found " + row.size() + ")");
            }
            int icol = 0;
            while (icol < this.ncol_) {
                int val;
                boolean isMinus;
                boolean done = false;
                String cell = (String)row.get(icol);
                int leng = cell.length();
                if (cell == null || leng == 0) {
                    done = true;
                }
                if (leng > this.stringLength_[icol]) {
                    this.stringLength_[icol] = leng;
                }
                if (!done && this.maybeBoolean_[icol]) {
                    if (cell.equalsIgnoreCase("false") || cell.equalsIgnoreCase("true") || cell.equalsIgnoreCase("f") || cell.equalsIgnoreCase("t")) {
                        done = true;
                    } else {
                        this.maybeBoolean_[icol] = false;
                    }
                }
                boolean bl = !done ? cell.charAt(0) == '-' : (isMinus = false);
                if (!done && this.maybeShort_[icol]) {
                    try {
                        val = Short.parseShort(cell);
                        if (val == 0 && isMinus) {
                            throw new NumberFormatException();
                        }
                        done = true;
                    }
                    catch (NumberFormatException e) {
                        this.maybeShort_[icol] = false;
                    }
                }
                if (!done && this.maybeInteger_[icol]) {
                    try {
                        val = Integer.parseInt(cell);
                        if (val == 0 && isMinus) {
                            throw new NumberFormatException();
                        }
                        done = true;
                    }
                    catch (NumberFormatException e) {
                        this.maybeInteger_[icol] = false;
                    }
                }
                if (!done && this.maybeLong_[icol]) {
                    try {
                        long val2 = Long.parseLong(cell);
                        if (val2 == 0L && isMinus) {
                            throw new NumberFormatException();
                        }
                        done = true;
                    }
                    catch (NumberFormatException e) {
                        this.maybeLong_[icol] = false;
                    }
                }
                if (!done && (this.maybeFloat_[icol] || this.maybeDouble_[icol])) {
                    try {
                        ParsedFloat pf = StreamStarTable.parseFloating(cell);
                        if (this.maybeFloat_[icol]) {
                            if (pf.sigFig > 6) {
                                this.maybeFloat_[icol] = false;
                            } else if (!Double.isInfinite(pf.dValue) && Float.isInfinite((float)pf.dValue)) {
                                this.maybeFloat_[icol] = false;
                            }
                        }
                        done = true;
                    }
                    catch (NumberFormatException e) {
                        this.maybeFloat_[icol] = false;
                        this.maybeDouble_[icol] = false;
                    }
                }
                ++icol;
            }
        }

        protected Metadata getMetadata() {
            ColumnInfo[] colInfos = new ColumnInfo[this.ncol_];
            Decoder[] decoders = new Decoder[this.ncol_];
            int icol = 0;
            while (icol < this.ncol_) {
                Decoder decoder;
                ColumnInfo colinfo;
                String name = "col" + (icol + 1);
                if (this.maybeBoolean_[icol]) {
                    colinfo = new ColumnInfo(name, class$java$lang$Boolean == null ? StreamStarTable.class$("java.lang.Boolean") : class$java$lang$Boolean, null);
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            char v1 = value.charAt(0);
                            return v1 == 't' || v1 == 'T' ? Boolean.TRUE : Boolean.FALSE;
                        }
                    };
                } else if (this.maybeShort_[icol]) {
                    colinfo = new ColumnInfo(name, class$java$lang$Short == null ? StreamStarTable.class$("java.lang.Short") : class$java$lang$Short, null);
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            return new Short(Short.parseShort(value));
                        }
                    };
                } else if (this.maybeInteger_[icol]) {
                    colinfo = new ColumnInfo(name, class$java$lang$Integer == null ? StreamStarTable.class$("java.lang.Integer") : class$java$lang$Integer, null);
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            return new Integer(Integer.parseInt(value));
                        }
                    };
                } else if (this.maybeLong_[icol]) {
                    colinfo = new ColumnInfo(name, class$java$lang$Long == null ? StreamStarTable.class$("java.lang.Long") : class$java$lang$Long, null);
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            return new Long(Long.parseLong(value));
                        }
                    };
                } else if (this.maybeFloat_[icol]) {
                    colinfo = new ColumnInfo(name, class$java$lang$Float == null ? StreamStarTable.class$("java.lang.Float") : class$java$lang$Float, null);
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            return new Float(Float.parseFloat(value));
                        }
                    };
                } else if (this.maybeDouble_[icol]) {
                    colinfo = new ColumnInfo(name, class$java$lang$Double == null ? StreamStarTable.class$("java.lang.Double") : class$java$lang$Double, null);
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            return new Double(Double.parseDouble(value));
                        }
                    };
                } else {
                    colinfo = new ColumnInfo(name, class$java$lang$String == null ? StreamStarTable.class$("java.lang.String") : class$java$lang$String, null);
                    colinfo.setElementSize(this.stringLength_[icol]);
                    Class clazz = class$java$lang$String == null ? StreamStarTable.class$("java.lang.String") : class$java$lang$String;
                    decoder = new Decoder(this){
                        private final /* synthetic */ RowEvaluator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        Object decode(String value) {
                            return value;
                        }
                    };
                }
                colInfos[icol] = colinfo;
                decoders[icol] = decoder;
                ++icol;
            }
            return new Metadata(colInfos, decoders, this.nrow_);
        }

        private boolean[] makeFlagArray(boolean val) {
            boolean[] flags = new boolean[this.ncol_];
            Arrays.fill(flags, val);
            return flags;
        }
    }

    protected static abstract class Decoder {
        protected Decoder() {
        }

        abstract Object decode(String var1);
    }

    protected static class Metadata {
        public final ColumnInfo[] colInfos_;
        public final Decoder[] decoders_;
        public final long nrow_;
        public final int ncol_;

        public Metadata(ColumnInfo[] colInfos, Decoder[] decoders, long nrow) {
            this.colInfos_ = colInfos;
            this.decoders_ = decoders;
            this.nrow_ = nrow;
            if (this.colInfos_.length != this.decoders_.length) {
                throw new IllegalArgumentException();
            }
            this.ncol_ = this.colInfos_.length;
        }
    }
}

