/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.StarTableModel;

public class StarJTable
extends JTable {
    private boolean rowHeader;
    private StarTable startable;
    private static final int MIN_WIDTH = 50;
    static /* synthetic */ Class class$java$lang$Integer;

    public StarJTable(boolean rowHeader) {
        this.rowHeader = rowHeader;
    }

    public StarJTable(StarTable startable, boolean rowHeader) {
        this(rowHeader);
        this.setStarTable(startable, rowHeader);
    }

    public boolean hasRowHeader() {
        return this.rowHeader;
    }

    public void setStarTable(StarTable startable, boolean rowHeader) {
        this.setModel(new StarTableModel(startable, rowHeader));
        this.startable = startable;
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        int jcol = 0;
        if (rowHeader) {
            ColumnInfo rhColInfo = new ColumnInfo(new DefaultValueInfo("Index", class$java$lang$Integer == null ? (class$java$lang$Integer = StarJTable.class$("java.lang.Integer")) : class$java$lang$Integer, "Row index"));
            StarTableColumn rhcol = new StarTableColumn(rhColInfo, jcol++);
            rhcol.setCellRenderer(StarJTable.getRowHeaderRenderer());
            tcm.addColumn(rhcol);
        }
        int icol = 0;
        while (icol < startable.getColumnCount()) {
            ColumnInfo cinfo = startable.getColumnInfo(icol);
            StarTableColumn tcol = new StarTableColumn(cinfo, jcol++);
            tcm.addColumn(tcol);
            ++icol;
        }
        this.setColumnModel(tcm);
    }

    public StarTable getStarTable() {
        return this.startable;
    }

    public void configureColumnWidths(int maxpix, int nrows) {
        StarJTable.configureColumnWidths(this, maxpix, nrows);
        if (this.rowHeader) {
            int hwidth = Math.max(StarJTable.getCellWidth(this, 0, 0), StarJTable.getCellWidth(this, this.getRowCount() - 1, 0)) + 8;
            this.getColumnModel().getColumn(0).setPreferredWidth(hwidth);
        }
    }

    public static void configureColumnWidths(JTable table, int maxpix, int rowSample) {
        int ncol = table.getColumnCount();
        int[] widths = new int[ncol];
        int icol = 0;
        while (icol < ncol) {
            widths[icol] = StarJTable.getHeaderWidth(table, icol);
            ++icol;
        }
        Iterator it = StarJTable.sampleIterator(table.getRowCount(), rowSample);
        while (it.hasNext()) {
            int irow = (Integer)it.next();
            int icol2 = 0;
            while (icol2 < ncol) {
                int w;
                if (widths[icol2] < maxpix && (w = StarJTable.getCellWidth(table, irow, icol2)) > widths[icol2]) {
                    widths[icol2] = Math.min(w, maxpix);
                }
                ++icol2;
            }
        }
        TableColumnModel tcm = table.getColumnModel();
        int wtot = 0;
        int icol3 = 0;
        while (icol3 < ncol) {
            int w = Math.max(widths[icol3] + 8, 50);
            wtot += w;
            tcm.getColumn(icol3).setPreferredWidth(w);
            ++icol3;
        }
        Container holder = table.getParent();
        table.setAutoResizeMode(holder != null && wtot <= holder.getSize().width ? 4 : 0);
    }

    public static void configureColumnWidth(JTable table, int maxpix, int rowSample, int icol) {
        int width = Math.min(StarJTable.getColumnWidth(table, icol, rowSample), maxpix);
        table.getColumnModel().getColumn(icol).setPreferredWidth(width);
    }

    private static int getColumnWidth(JTable table, int icol, int rowSample) {
        int width = StarJTable.getHeaderWidth(table, icol);
        Iterator it = StarJTable.sampleIterator(table.getRowCount(), rowSample);
        while (it.hasNext()) {
            int irow = (Integer)it.next();
            int w = StarJTable.getCellWidth(table, irow, icol);
            width = Math.max(w, width);
        }
        return Math.max(width + 10, 50);
    }

    private static int getHeaderWidth(JTable jtab, int icol) {
        TableCellRenderer headRend = jtab.getColumnModel().getColumn(icol).getHeaderRenderer();
        if (headRend == null) {
            headRend = jtab.getTableHeader().getDefaultRenderer();
        }
        String headObj = jtab.getColumnName(icol);
        Component headComp = headRend.getTableCellRendererComponent(jtab, headObj, false, false, 0, icol);
        int width = headComp.getPreferredSize().width;
        return Math.max(50, width);
    }

    public static int getCellWidth(JTable jtab, int irow, int icol) {
        TableCellRenderer rend = jtab.getCellRenderer(irow, icol);
        Object value = jtab.getValueAt(irow, icol);
        Component comp = rend.getTableCellRendererComponent(jtab, value, false, false, irow, icol);
        return comp.getPreferredSize().width;
    }

    private static TableCellRenderer getRowHeaderRenderer() {
        DefaultTableCellRenderer rend = new DefaultTableCellRenderer();
        rend.setFont(UIManager.getFont("TableHeader.font"));
        rend.setBackground(UIManager.getColor("TableHeader.background"));
        rend.setForeground(UIManager.getColor("TableHeader.foreground"));
        rend.setHorizontalAlignment(4);
        return rend;
    }

    private static Iterator sampleIterator(final int nrow, final int nsample) {
        if (nsample >= nrow) {
            return new Iterator(){
                int irow = 0;

                public boolean hasNext() {
                    return this.irow < nrow;
                }

                public Object next() {
                    return new Integer(this.irow++);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator(){
            int irow = 0;
            int isamp = 0;
            int ns4 = nsample / 4;
            int ns2 = nsample / 2;

            public boolean hasNext() {
                return this.isamp < nsample;
            }

            public Object next() {
                int is = this.isamp++;
                switch (is * 4 / nsample) {
                    case 0: {
                        return new Integer(is);
                    }
                    case 1: 
                    case 2: {
                        double frac = 2.0 * ((double)is / (double)nsample - 0.25);
                        int irow = this.ns4 + (int)(frac * (double)(nrow - this.ns2));
                        return new Integer(irow);
                    }
                    case 3: {
                        return new Integer(nrow - (nsample - is));
                    }
                }
                throw new AssertionError();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

