/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.jdbc.Connector;

public class JDBCStarTable
extends AbstractStarTable {
    private int ncol;
    private ColumnInfo[] colinfo;
    private final Connector connx;
    private final String sql;
    private ResultSet randomResultSet;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table.jdbc");
    private static final ValueInfo labelInfo = new DefaultValueInfo("Label", class$java$lang$String == null ? (class$java$lang$String = JDBCStarTable.class$("java.lang.String")) : class$java$lang$String);
    private static final List auxDataInfos = Arrays.asList(labelInfo);
    private static final ValueInfo sqlInfo = new DefaultValueInfo("SQL", class$java$lang$String == null ? (class$java$lang$String = JDBCStarTable.class$("java.lang.String")) : class$java$lang$String, "SQL query text");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;

    public JDBCStarTable(Connector connx, String sql) throws SQLException {
        this(connx, sql, false);
        List params = this.getParameters();
        params.add(new DescribedValue(sqlInfo, sql));
    }

    public JDBCStarTable(Connector connx, String sql, boolean isRandom) throws SQLException {
        ResultSetMetaData rsmeta;
        this.connx = connx;
        this.sql = sql;
        Connection conn = connx.getConnection();
        this.setName(conn.getMetaData().getURL() + '#' + sql);
        if (isRandom) {
            Statement stmt = conn.createStatement(1004, 1007);
            this.randomResultSet = JDBCStarTable.makeRandomResultSet(conn, sql);
        }
        if (isRandom) {
            rsmeta = this.randomResultSet.getMetaData();
        } else {
            Statement stmt = conn.createStatement();
            stmt.setMaxRows(1);
            ResultSet rset = stmt.executeQuery(sql);
            rsmeta = rset.getMetaData();
            rset.close();
        }
        this.ncol = rsmeta.getColumnCount();
        this.colinfo = new ColumnInfo[this.ncol];
        int icol = 0;
        while (icol < this.ncol) {
            int jcol = icol + 1;
            String name = rsmeta.getColumnName(jcol);
            this.colinfo[icol] = new ColumnInfo(name);
            ColumnInfo col = this.colinfo[icol];
            try {
                this.getClass();
                Class<?> ccls = Class.forName(rsmeta.getColumnClassName(jcol));
                col.setContentClass(ccls);
            }
            catch (ClassNotFoundException e) {
                col.setContentClass(class$java$lang$Object == null ? JDBCStarTable.class$("java.lang.Object") : class$java$lang$Object);
            }
            if (rsmeta.isNullable(jcol) == 0) {
                col.setNullable(false);
            }
            List auxdata = col.getAuxData();
            String label = rsmeta.getColumnLabel(jcol);
            if (label != null && label.trim().length() > 0 && !label.equalsIgnoreCase(name)) {
                auxdata.add(new DescribedValue(labelInfo, label.trim()));
            }
            ++icol;
        }
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colinfo[icol];
    }

    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    public int getColumnCount() {
        return this.ncol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowCount() {
        if (this.randomResultSet != null) {
            try {
                int lastRow;
                ResultSet resultSet = this.randomResultSet;
                synchronized (resultSet) {
                    this.randomResultSet.afterLast();
                    this.randomResultSet.previous();
                    lastRow = this.randomResultSet.getRow();
                }
                return lastRow;
            }
            catch (SQLException e) {
                logger.warning("Failed to get length of table: " + e);
                return 0L;
            }
        }
        return -1L;
    }

    public void setRandom() throws SQLException {
        if (this.randomResultSet == null) {
            this.randomResultSet = JDBCStarTable.makeRandomResultSet(this.connx.getConnection(), this.sql);
            this.checkConsistent(this.randomResultSet);
        }
    }

    public boolean isRandom() {
        return this.randomResultSet != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCell(long lrow, int icol) throws IOException {
        if (this.randomResultSet == null) {
            throw new UnsupportedOperationException("No random access");
        }
        try {
            ResultSet resultSet = this.randomResultSet;
            synchronized (resultSet) {
                this.randomResultSet.absolute(AbstractStarTable.checkedLongToInt(lrow) + 1);
                return this.getPackagedCell(this.randomResultSet, icol);
            }
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRow(long lrow) throws IOException {
        if (this.randomResultSet == null) {
            throw new UnsupportedOperationException("No random access");
        }
        try {
            Object[] row = new Object[this.ncol];
            ResultSet resultSet = this.randomResultSet;
            synchronized (resultSet) {
                this.randomResultSet.absolute(AbstractStarTable.checkedLongToInt(lrow) + 1);
                int i = 0;
                while (i < this.ncol) {
                    row[i] = this.getPackagedCell(this.randomResultSet, i);
                    ++i;
                }
            }
            return row;
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public RowSequence getRowSequence() throws IOException {
        ResultSet rset;
        Connection conn;
        try {
            conn = this.connx.getConnection();
            rset = conn.createStatement().executeQuery(this.sql);
            this.checkConsistent(rset);
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return new RowSequence(){

            public boolean next() throws IOException {
                try {
                    return rset.next();
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            public Object getCell(int icol) throws IOException {
                try {
                    if (rset.isBeforeFirst()) {
                        throw new NoSuchElementException("No current row");
                    }
                    return JDBCStarTable.this.getPackagedCell(rset, icol);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            public Object[] getRow() throws IOException {
                try {
                    if (rset.isBeforeFirst()) {
                        throw new NoSuchElementException("No current row");
                    }
                    Object[] row = new Object[JDBCStarTable.this.ncol];
                    int i = 0;
                    while (i < JDBCStarTable.this.ncol) {
                        row[i] = JDBCStarTable.this.getPackagedCell(rset, i);
                        ++i;
                    }
                    return row;
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            public void close() throws IOException {
                try {
                    rset.close();
                    conn.close();
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
        };
    }

    public Connection getConnection() throws SQLException {
        return this.connx.getConnection();
    }

    public String getSql() {
        return this.sql;
    }

    private Object getPackagedCell(ResultSet rset, int icol) throws SQLException {
        Object base = rset.getObject(icol + 1);
        Class colclass = this.getColumnInfo(icol).getContentClass();
        if (base instanceof byte[] && !colclass.equals(array$B == null ? (array$B = JDBCStarTable.class$("[B")) : array$B)) {
            return new String((byte[])base);
        }
        if (base instanceof char[] && !colclass.equals(array$C == null ? (array$C = JDBCStarTable.class$("[C")) : array$C)) {
            return new String((char[])base);
        }
        return base;
    }

    private static ResultSet makeRandomResultSet(Connection conn, String sql) throws SQLException {
        return conn.createStatement(1004, 1007).executeQuery(sql);
    }

    private void checkConsistent(ResultSet rset) throws SQLException {
        ResultSetMetaData rsmeta1 = rset.getMetaData();
        if (rsmeta1.getColumnCount() != this.ncol) {
            throw new IllegalStateException("ResultSet column count has changed");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

