/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;

public class TerminalAuthenticator
implements JDBCAuthenticator {
    public String[] authenticate() throws IOException {
        return new String[]{TerminalAuthenticator.readUser(), TerminalAuthenticator.readPassword()};
    }

    public static String readUser() throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("JDBC User: ");
        return rdr.readLine();
    }

    public static String readPassword() throws IOException {
        return TerminalAuthenticator.getMaskedString("JDBC Password: ");
    }

    private static String getMaskedString(String prompt) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        char linesep0 = System.getProperty("line.separator").charAt(0);
        MaskingThread masker = new MaskingThread(prompt);
        masker.start();
        try {
            while (true) {
                int c;
                if ((c = System.in.read()) == linesep0 || c < 0) {
                    masker.interrupt();
                    if (c < 0) {
                        System.out.println();
                    }
                    break;
                }
                sbuf.append(c);
            }
        }
        catch (IOException e) {
            masker.interrupt();
            System.out.println();
            throw e;
        }
        return sbuf.toString();
    }

    private static class MaskingThread
    extends Thread {
        private String out;

        public MaskingThread(String prompt) {
            this.out = '\r' + prompt + " \r" + prompt;
        }

        public void run() {
            while (!Thread.interrupted()) {
                System.out.print(this.out);
                System.out.flush();
                try {
                    MaskingThread.sleep(1L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }
}

