/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public class CombinedMatchEngine
implements MatchEngine {
    private final MatchEngine[] engines;
    private final int[] tupleSizes;
    private final int[] tupleStarts;
    private final int nPart;
    private String name;
    private final Object[][] work0;
    private final Object[][] work1;
    private final Object[][] work2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$join$CombinedMatchEngine;

    public CombinedMatchEngine(MatchEngine[] engines) {
        this.engines = engines;
        this.nPart = engines.length;
        this.tupleSizes = new int[this.nPart];
        int i = 0;
        while (i < this.nPart) {
            this.tupleSizes[i] = engines[i].getTupleInfos().length;
            ++i;
        }
        this.tupleStarts = new int[this.nPart];
        int ts = 0;
        this.work0 = new Object[this.nPart][];
        this.work1 = new Object[this.nPart][];
        this.work2 = new Object[this.nPart][];
        int i2 = 0;
        while (i2 < this.nPart) {
            this.tupleStarts[i2] = ts;
            ts += this.tupleSizes[i2];
            this.work0[i2] = new Object[this.tupleSizes[i2]];
            this.work1[i2] = new Object[this.tupleSizes[i2]];
            this.work2[i2] = new Object[this.tupleSizes[i2]];
            ++i2;
        }
        StringBuffer buf = new StringBuffer("(");
        int i3 = 0;
        while (i3 < this.nPart) {
            if (i3 > 0) {
                buf.append(", ");
            }
            buf.append(engines[i3].toString());
            ++i3;
        }
        buf.append(")");
        this.name = buf.toString();
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double totalScore = 0.0;
        int i = 0;
        while (i < this.nPart) {
            Object[] subTuple1 = this.work1[i];
            Object[] subTuple2 = this.work2[i];
            System.arraycopy(tuple1, this.tupleStarts[i], subTuple1, 0, this.tupleSizes[i]);
            System.arraycopy(tuple2, this.tupleStarts[i], subTuple2, 0, this.tupleSizes[i]);
            double score = this.engines[i].matchScore(subTuple1, subTuple2);
            if (score < 0.0) {
                return -1.0;
            }
            totalScore += score;
            ++i;
        }
        return totalScore;
    }

    public Object[] getBins(Object[] tuple) {
        Object[][] binBag = new Object[this.nPart][];
        int i = 0;
        while (i < this.nPart) {
            Object[] subTuple = this.work0[i];
            System.arraycopy(tuple, this.tupleStarts[i], subTuple, 0, this.tupleSizes[i]);
            binBag[i] = this.engines[i].getBins(subTuple);
            ++i;
        }
        int nBin = 1;
        int i2 = 0;
        while (i2 < this.nPart) {
            nBin *= binBag[i2].length;
            ++i2;
        }
        Object[] bins = new Object[nBin];
        int[] offset = new int[this.nPart];
        int ibin = 0;
        while (ibin < nBin) {
            ArrayList<Object> bin = new ArrayList<Object>(this.nPart);
            int i3 = 0;
            while (i3 < this.nPart) {
                bin.add(binBag[i3][offset[i3]]);
                ++i3;
            }
            bins[ibin] = bin;
            int j = 0;
            while (j < this.nPart) {
                int n = j;
                offset[n] = offset[n] + 1;
                if (offset[n] < binBag[j].length) break;
                offset[j] = 0;
                ++j;
            }
            ++ibin;
        }
        int i4 = 0;
        while (i4 < this.nPart) {
            if (!$assertionsDisabled && offset[i4] != 0) {
                throw new AssertionError();
            }
            ++i4;
        }
        return bins;
    }

    public ValueInfo[] getTupleInfos() {
        int nargs = this.tupleStarts[this.nPart - 1] + this.tupleSizes[this.nPart - 1];
        ValueInfo[] infos = new ValueInfo[nargs];
        int i = 0;
        while (i < this.nPart) {
            System.arraycopy(this.engines[i].getTupleInfos(), 0, infos, this.tupleStarts[i], this.tupleSizes[i]);
            ++i;
        }
        return infos;
    }

    public DescribedValue[] getMatchParameters() {
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        int i = 0;
        while (i < this.nPart) {
            params.addAll(Arrays.asList(this.engines[i].getMatchParameters()));
            ++i;
        }
        return params.toArray(new DescribedValue[0]);
    }

    public boolean canBoundMatch() {
        int i = 0;
        while (i < this.nPart) {
            if (this.engines[i].canBoundMatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Comparable[][] getMatchBounds(Comparable[] min, Comparable[] max) {
        min = (Comparable[])min.clone();
        max = (Comparable[])max.clone();
        int i = 0;
        while (i < this.nPart) {
            if (this.engines[i].canBoundMatch()) {
                int size = this.tupleSizes[i];
                int start = this.tupleStarts[i];
                Comparable[] subMin = new Comparable[size];
                Comparable[] subMax = new Comparable[size];
                System.arraycopy(min, start, subMin, 0, size);
                System.arraycopy(max, start, subMax, 0, size);
                Comparable[][] subBounds = this.engines[i].getMatchBounds(subMin, subMax);
                subMin = subBounds[0];
                subMax = subBounds[1];
                System.arraycopy(subMin, 0, min, start, size);
                System.arraycopy(subMax, 0, max, start, size);
            }
            ++i;
        }
        return new Comparable[][]{min, max};
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$join$CombinedMatchEngine == null ? (class$uk$ac$starlink$table$join$CombinedMatchEngine = CombinedMatchEngine.class$("uk.ac.starlink.table.join.CombinedMatchEngine")) : class$uk$ac$starlink$table$join$CombinedMatchEngine).desiredAssertionStatus();
    }
}

