/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMindex;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.HTMrangeIterator;
import edu.jhu.htm.geometry.Circle;
import java.util.ArrayList;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.SkyMatchEngine;

public class HTMMatchEngine
extends SkyMatchEngine {
    private HTMindex htm_;
    private double arcminSep_;
    public static final double MESH_SCALE = 1.0;

    public HTMMatchEngine(double separation) {
        super(separation);
    }

    public void setSeparation(double separation) {
        super.setSeparation(separation);
        this.arcminSep_ = Math.toDegrees(separation) * 60.0;
        try {
            this.htm_ = new HTMindexImp(Math.toDegrees(separation) * 1.0);
        }
        catch (HTMException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad separation? " + separation + " radians").initCause(e);
        }
    }

    public Object[] getBins(Object[] radec) {
        if (radec[0] instanceof Number && radec[1] instanceof Number) {
            Circle zone = new Circle(((Number)radec[0]).doubleValue(), ((Number)radec[1]).doubleValue(), this.arcminSep_);
            HTMrange range = this.htm_.intersect(zone.getDomain());
            ArrayList binList = new ArrayList();
            try {
                HTMrangeIterator it = new HTMrangeIterator(range, false);
                while (it.hasNext()) {
                    binList.add(it.next());
                }
            }
            catch (HTMException e) {
                throw new RuntimeException("Uh-oh", e);
            }
            return binList.toArray();
        }
        return MatchEngine.NO_BINS;
    }
}

