/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public class MatchStarTables {
    public static final ValueInfo GRP_ID_INFO;
    public static final ValueInfo GRP_SIZE_INFO;
    public static final ValueInfo MATCH_SCORE_INFO;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$join$MatchStarTables;

    public static StarTable makeJoinTable(StarTable[] tables, Collection rowLinks, Map matchScores, JoinStarTable.FixAction[] fixActs) {
        double[] scores;
        int nTable = tables.length;
        int nRow = rowLinks.size();
        long[][] rowIndices = new long[nTable][];
        int iTable = 0;
        while (iTable < nTable) {
            if (tables[iTable] != null) {
                rowIndices[iTable] = new long[nRow];
                Arrays.fill(rowIndices[iTable], -1L);
            }
            ++iTable;
        }
        if (matchScores != null && !matchScores.isEmpty()) {
            scores = new double[nRow];
            Arrays.fill(scores, Double.NaN);
        } else {
            scores = null;
        }
        int nScore = 0;
        int iLink = 0;
        Iterator it = rowLinks.iterator();
        while (it.hasNext()) {
            double dscore;
            Number score;
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                int iTable2 = ref.getTableIndex();
                if (tables[iTable2] != null) {
                    rowIndices[iTable2][iLink] = ref.getRowIndex();
                }
                ++i;
            }
            Number number = score = matchScores != null ? (Number)((Number)matchScores.get(link)) : (Number)null;
            if (score != null && !Double.isNaN(dscore = score.doubleValue())) {
                scores[iLink] = dscore;
                ++nScore;
            }
            ++iLink;
        }
        if (!$assertionsDisabled && iLink != nRow) {
            throw new AssertionError();
        }
        ArrayList<StarTable> subTableList = new ArrayList<StarTable>();
        int iTable3 = 0;
        while (iTable3 < nTable) {
            StarTable table = tables[iTable3];
            if (table != null) {
                RowPermutedStarTable subTable = new RowPermutedStarTable(table, rowIndices[iTable3]);
                subTableList.add(subTable);
            }
            ++iTable3;
        }
        if (nScore > 0) {
            ColumnStarTable scoreTable = ColumnStarTable.makeTableWithRows(nRow);
            ColumnInfo scoreInfo = new ColumnInfo(MATCH_SCORE_INFO);
            scoreTable.addColumn(ArrayColumn.makeColumn(scoreInfo, (Object)scores));
            subTableList.add(scoreTable);
            JoinStarTable.FixAction[] fa = fixActs;
            fixActs = new JoinStarTable.FixAction[nTable + 1];
            System.arraycopy(fa, 0, fixActs, 0, nTable);
            fixActs[nTable] = JoinStarTable.FixAction.NO_ACTION;
        }
        StarTable[] subTables = subTableList.toArray(new StarTable[0]);
        JoinStarTable joined = new JoinStarTable(subTables, fixActs);
        joined.setName("Joined");
        return joined;
    }

    public static StarTable makeInternalMatchTable(int iTable, Collection rowLinks, long rowCount) {
        final int nrow = Tables.checkedLongToInt(rowCount);
        final int[] grpIds = new int[nrow];
        final int[] grpSizes = new int[nrow];
        int grpId = 0;
        Iterator it = rowLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            ++grpId;
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() == iTable) {
                    long lrow = ref.getRowIndex();
                    int irow = Tables.checkedLongToInt(lrow);
                    grpIds[irow] = grpId;
                    int n = grpId;
                    grpSizes[n] = grpSizes[n] + 1;
                }
                ++i;
            }
        }
        ColumnData grpIdColumn = new ColumnData(GRP_ID_INFO){

            public Object readValue(long lrow) {
                if (lrow >= (long)nrow) {
                    return null;
                }
                int grpId = grpIds[(int)lrow];
                return grpId > 0 ? new Integer(grpId) : null;
            }
        };
        ColumnData grpSizeColumn = new ColumnData(GRP_SIZE_INFO){

            public Object readValue(long lrow) {
                if (lrow >= (long)nrow) {
                    return null;
                }
                int grpId = grpIds[(int)lrow];
                return grpId > 0 ? new Integer(grpSizes[grpId]) : null;
            }
        };
        ColumnStarTable grpTable = ColumnStarTable.makeTableWithRows(nrow);
        grpTable.addColumn(grpIdColumn);
        grpTable.addColumn(grpSizeColumn);
        return grpTable;
    }

    public static StarTable makeParallelMatchTable(StarTable table, int iTable, Collection links, int width, int minSize, int maxSize, JoinStarTable.FixAction[] fixActs) {
        String name;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int n0ref = 0;
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() == iTable) {
                    ++n0ref;
                }
                ++i;
            }
            if (n0ref >= minSize && n0ref <= maxSize) continue;
            it.remove();
        }
        int nrow = links.size();
        long[][] rowIndices = new long[width][];
        int i = 0;
        while (i < width) {
            rowIndices[i] = new long[nrow];
            Arrays.fill(rowIndices[i], -1L);
            ++i;
        }
        int iLink = 0;
        Iterator it2 = links.iterator();
        while (it2.hasNext()) {
            RowLink link = (RowLink)it2.next();
            int nref = link.size();
            int refPos = 0;
            int i2 = 0;
            while (i2 < nref && refPos < width) {
                RowRef ref = link.getRef(i2);
                if (ref.getTableIndex() == iTable) {
                    rowIndices[refPos++][iLink] = ref.getRowIndex();
                }
                ++i2;
            }
            if (!($assertionsDisabled || refPos >= minSize && refPos <= maxSize)) {
                throw new AssertionError();
            }
            ++iLink;
        }
        if (!$assertionsDisabled && iLink != nrow) {
            throw new AssertionError();
        }
        StarTable[] subTables = new StarTable[width];
        int i3 = 0;
        while (i3 < width) {
            subTables[i3] = new RowPermutedStarTable(table, rowIndices[i3]);
            ++i3;
        }
        int ncol = table.getColumnCount();
        int xNcol = ncol * width;
        final ColumnInfo[] colinfos = new ColumnInfo[xNcol];
        int ic = 0;
        while (ic < ncol) {
            ColumnInfo cinfo = table.getColumnInfo(ic);
            int iw = 0;
            while (iw < width) {
                ColumnInfo ci = new ColumnInfo(cinfo);
                ci.setName(ci.getName() + "_" + (iw + 1));
                colinfos[ic + iw * ncol] = ci;
                ++iw;
            }
            ++ic;
        }
        JoinStarTable joined = new JoinStarTable(subTables, fixActs){

            public ColumnInfo getColumnInfo(int icol) {
                return colinfos[icol];
            }
        };
        switch (width) {
            case 2: {
                name = "pairs";
                break;
            }
            case 3: {
                name = "triples";
                break;
            }
            case 4: {
                name = "quads";
                break;
            }
            default: {
                name = "setsOf" + width;
            }
        }
        joined.setName(name);
        return joined;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$join$MatchStarTables == null ? (class$uk$ac$starlink$table$join$MatchStarTables = MatchStarTables.class$("uk.ac.starlink.table.join.MatchStarTables")) : class$uk$ac$starlink$table$join$MatchStarTables).desiredAssertionStatus();
        GRP_ID_INFO = new DefaultValueInfo("MatchID", class$java$lang$Integer == null ? (class$java$lang$Integer = MatchStarTables.class$("java.lang.Integer")) : class$java$lang$Integer, "ID for internal match group");
        GRP_SIZE_INFO = new DefaultValueInfo("MatchCount", class$java$lang$Integer == null ? (class$java$lang$Integer = MatchStarTables.class$("java.lang.Integer")) : class$java$lang$Integer, "Number of rows in internal match group");
        MATCH_SCORE_INFO = new DefaultValueInfo("MatchScore", class$java$lang$Double == null ? (class$java$lang$Double = MatchStarTables.class$("java.lang.Double")) : class$java$lang$Double, "Proximity of rows in match (0 is closest)");
    }
}

