/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;

public abstract class SkyMatchEngine
implements MatchEngine {
    private double separation_;
    private DescribedValue sepValue_ = new SkySeparationValue();
    private static final DefaultValueInfo SEP_INFO = new DefaultValueInfo("Error", class$java$lang$Double == null ? (class$java$lang$Double = SkyMatchEngine.class$("java.lang.Double")) : class$java$lang$Double, "Maximum separation along a great circle");
    static /* synthetic */ Class class$java$lang$Double;

    public SkyMatchEngine(double separation) {
        this.setSeparation(separation);
    }

    public void setSeparation(double separation) {
        this.separation_ = separation;
    }

    public double getSeparation() {
        return this.separation_;
    }

    public double matchScore(Object[] radec1, Object[] radec2) {
        double ra2;
        double dec2;
        double dec1 = ((Number)radec1[1]).doubleValue();
        if (Math.abs(dec1 - (dec2 = ((Number)radec2[1]).doubleValue())) > this.separation_) {
            return -1.0;
        }
        double ra1 = ((Number)radec1[0]).doubleValue();
        double sep = this.calculateSeparation(ra1, dec1, ra2 = ((Number)radec2[0]).doubleValue(), dec2);
        return sep <= this.separation_ ? sep : -1.0;
    }

    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO};
    }

    public DescribedValue[] getMatchParameters() {
        return new DescribedValue[]{this.sepValue_};
    }

    public String toString() {
        return "Sky";
    }

    public boolean canBoundMatch() {
        return true;
    }

    public Comparable[][] getMatchBounds(Comparable[] radecMinIn, Comparable[] radecMaxIn) {
        double rMaxOut;
        double rMinOut;
        double rMinIn = radecMinIn[0] == null ? Double.NaN : ((Number)((Object)radecMinIn[0])).doubleValue();
        double dMinIn = radecMinIn[1] == null ? Double.NaN : ((Number)((Object)radecMinIn[1])).doubleValue();
        double rMaxIn = radecMaxIn[0] == null ? Double.NaN : ((Number)((Object)radecMaxIn[0])).doubleValue();
        double dMaxIn = radecMaxIn[1] == null ? Double.NaN : ((Number)((Object)radecMaxIn[1])).doubleValue();
        double dMinOut = dMinIn - this.separation_;
        double dMaxOut = dMaxIn + this.separation_;
        if (!Double.isNaN(dMinOut) && !Double.isNaN(dMaxOut)) {
            double rDiffMax = Math.max(Math.abs(this.separation_ / Math.cos(dMinOut)), Math.abs(this.separation_ / Math.cos(dMaxOut)));
            rMinOut = rMinIn - rDiffMax;
            rMaxOut = rMaxIn + rDiffMax;
        } else {
            rMinOut = Double.NaN;
            rMaxOut = Double.NaN;
        }
        Comparable[] radecMinOut = new Comparable[2];
        Comparable[] radecMaxOut = new Comparable[2];
        if (!Double.isNaN(rMinOut)) {
            if (radecMinIn[0] instanceof Float) {
                radecMinOut[0] = new Float((float)rMinOut);
            } else if (radecMinIn[0] instanceof Double) {
                radecMinOut[0] = new Double(rMinOut);
            }
        }
        if (!Double.isNaN(dMinOut)) {
            if (radecMinIn[1] instanceof Float) {
                radecMinOut[1] = new Float((float)dMinOut);
            } else if (radecMinIn[1] instanceof Double) {
                radecMinOut[1] = new Double(dMinOut);
            }
        }
        if (!Double.isNaN(rMaxOut)) {
            if (radecMaxIn[0] instanceof Float) {
                radecMaxOut[0] = new Float((float)rMaxOut);
            } else if (radecMaxIn[0] instanceof Double) {
                radecMaxOut[0] = new Double(rMaxOut);
            }
        }
        if (!Double.isNaN(dMaxOut)) {
            if (radecMaxIn[1] instanceof Float) {
                radecMaxOut[1] = new Float((float)dMaxOut);
            } else if (radecMaxIn[1] instanceof Double) {
                radecMaxOut[1] = new Double(dMaxOut);
            }
        }
        return new Comparable[][]{radecMinOut, radecMaxOut};
    }

    private double calculateSeparation(double ra1, double dec1, double ra2, double dec2) {
        return SkyMatchEngine.haversineSeparationFormula(ra1, dec1, ra2, dec2);
    }

    private static double cosineSeparationFormula(double ra1, double dec1, double ra2, double dec2) {
        return Math.acos(Math.sin(dec1) * Math.sin(dec2) + Math.cos(dec1) * Math.cos(dec2) * Math.cos(ra1 - ra2));
    }

    private static double haversineSeparationFormula(double ra1, double dec1, double ra2, double dec2) {
        double sr2;
        double sd2 = Math.sin(0.5 * (dec2 - dec1));
        double a = sd2 * sd2 + (sr2 = Math.sin(0.5 * (ra2 - ra1))) * sr2 * Math.cos(dec1) * Math.cos(dec2);
        return a < 1.0 ? 2.0 * Math.asin(Math.sqrt(a)) : Math.PI;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SEP_INFO.setUnitString("radians");
    }

    private class SkySeparationValue
    extends DescribedValue {
        SkySeparationValue() {
            super(SEP_INFO);
        }

        public Object getValue() {
            return new Double(SkyMatchEngine.this.getSeparation());
        }

        public void setValue(Object value) {
            SkyMatchEngine.this.setSeparation((Double)value);
        }
    }
}

