/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.storage.ColumnWidth;

abstract class Offsets {
    Offsets() {
    }

    public abstract long getRowOffset(long var1);

    public abstract long getCellOffset(long var1, int var3);

    public abstract long getLength();

    public abstract boolean isFixed();

    public static Offsets getOffsets(ColumnWidth[] widths, long nrow) {
        boolean allFixed = true;
        int icol = 0;
        while (icol < widths.length) {
            allFixed = allFixed && widths[icol].isConstant();
            ++icol;
        }
        return allFixed ? new FixedOffsets(widths, nrow) : new VariableOffsets(widths, nrow);
    }

    private static class VariableOffsets
    extends Offsets {
        final ColumnWidth[] widths_;
        final int nrow_;
        final long[] rowOffsets_;
        final long leng_;

        VariableOffsets(ColumnWidth[] widths, long nrow) {
            this.widths_ = widths;
            this.nrow_ = Tables.checkedLongToInt(nrow);
            this.rowOffsets_ = new long[this.nrow_];
            int ncol = widths.length;
            long pos = 0L;
            int irow = 0;
            while (irow < this.nrow_) {
                this.rowOffsets_[irow] = pos;
                int icol = 0;
                while (icol < ncol) {
                    pos += (long)widths[icol].getWidth(irow);
                    ++icol;
                }
                ++irow;
            }
            this.leng_ = pos;
        }

        public long getRowOffset(long lrow) {
            int irow = Tables.checkedLongToInt(lrow);
            return this.rowOffsets_[irow];
        }

        public long getCellOffset(long lrow, int icol) {
            long off = this.getRowOffset(lrow);
            int ic = 0;
            while (ic < icol) {
                off += (long)this.widths_[ic].getWidth(lrow);
                ++ic;
            }
            return off;
        }

        public long getLength() {
            return this.leng_;
        }

        public boolean isFixed() {
            return false;
        }
    }

    private static class FixedOffsets
    extends Offsets {
        final long[] colOffs_;
        final long rowSize_;
        final long leng_;

        FixedOffsets(ColumnWidth[] widths, long nrow) {
            int ncol = widths.length;
            this.colOffs_ = new long[ncol];
            long pos = 0L;
            int icol = 0;
            while (icol < ncol) {
                this.colOffs_[icol] = pos;
                pos += (long)widths[icol].getWidth(0L);
                ++icol;
            }
            this.rowSize_ = pos;
            this.leng_ = nrow * this.rowSize_;
        }

        public long getRowOffset(long lrow) {
            return this.rowSize_ * lrow;
        }

        public long getCellOffset(long lrow, int icol) {
            return this.rowSize_ * lrow + this.colOffs_[icol];
        }

        public long getLength() {
            return this.leng_;
        }

        public boolean isFixed() {
            return true;
        }
    }
}

