/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.ColumnComboBoxModel;
import uk.ac.starlink.topcat.CutoutSelector;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.func.Image;
import uk.ac.starlink.topcat.func.Spectrum;

public class ActivationQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel_;
    private ActivatorFactory activeFactory_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$io$File;

    public ActivationQueryWindow(TopcatModel tcModel, Component parent) {
        super("Set Activation Action", parent);
        this.tcModel_ = tcModel;
        ActivatorFactory[] factories = new ActivatorFactory[]{new NopActivatorFactory(), new CutoutActivatorFactory(), new ImageActivatorFactory(), new SpectrumActivatorFactory(), new JELActivatorFactory()};
        GridBagLayout layer = new GridBagLayout();
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridy = 0;
        bc.gridx = 0;
        bc.ipadx = 4;
        bc.ipady = 4;
        bc.insets = new Insets(2, 2, 2, 2);
        bc.anchor = 17;
        GridBagConstraints qc = (GridBagConstraints)bc.clone();
        ++qc.gridx;
        qc.fill = 1;
        qc.weightx = 1.0;
        JPanel mainBox = new JPanel(layer);
        this.getMainArea().add(mainBox);
        ButtonGroup buttGroup = new ButtonGroup();
        int i = 0;
        while (i < factories.length) {
            ActivatorFactory fact = factories[i];
            fact.setEnabled(false);
            JRadioButton butt = fact.button_;
            butt.setEnabled(fact.isPossible());
            buttGroup.add(butt);
            layer.setConstraints(butt, bc);
            mainBox.add(butt);
            JComponent query = fact.getQueryComponent();
            Border border = BorderFactory.createBevelBorder(0);
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5));
            query.setBorder(border);
            layer.setConstraints(query, qc);
            mainBox.add(query);
            ++bc.gridy;
            ++qc.gridy;
            ++i;
        }
        factories[0].button_.setSelected(true);
        this.getToolBar().add(MethodWindow.getWindowAction(this, true));
        this.getToolBar().addSeparator();
        this.addHelp("ActivationQueryWindow");
        this.pack();
        this.setVisible(true);
    }

    public boolean perform() {
        Activator actor = this.activeFactory_.makeActivator();
        if (actor != null) {
            this.tcModel_.setActivator(actor);
            return true;
        }
        return false;
    }

    private String getWindowLabel(TableColumn tcol) {
        String tname = tcol instanceof StarTableColumn ? ((StarTableColumn)tcol).getColumnInfo().getName() : tcol.getHeaderValue().toString();
        return tname + "(" + this.tcModel_.getID() + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$300(ActivationQueryWindow x0, TableColumn x1) {
        return x0.getWindowLabel(x1);
    }

    private abstract class ColumnActivator
    implements Activator {
        final int icol_;
        final String funcName_;

        ColumnActivator(String funcName, TableColumn tcol) {
            this.icol_ = tcol.getModelIndex();
            this.funcName_ = funcName;
        }

        abstract String activateValue(Object var1);

        public String activateRow(long lrow) {
            Object value;
            try {
                value = ActivationQueryWindow.this.tcModel_.getDataModel().getCell(lrow, this.icol_);
            }
            catch (IOException e) {
                value = null;
            }
            return value == null ? null : this.activateValue(value);
        }

        public String toString() {
            String colName = ActivationQueryWindow.this.tcModel_.getDataModel().getColumnInfo(this.icol_).getName();
            return this.funcName_ + "( " + colName + " )";
        }
    }

    private class SpectrumActivatorFactory
    extends ColumnActivatorFactory {
        SpectrumActivatorFactory() {
            super("Spectrum");
        }

        Activator makeActivator(TableColumn tcol) {
            return new ColumnActivator(this, "spectrum", tcol, tcol){
                private final /* synthetic */ TableColumn val$tcol;
                private final /* synthetic */ SpectrumActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$tcol = val$tcol;
                    super(x0, x1);
                }

                String activateValue(Object val) {
                    return val == null ? null : Spectrum.displaySpectrum(ActivationQueryWindow.access$300(SpectrumActivatorFactory.access$400(this.this$1), this.val$tcol), val.toString());
                }
            };
        }

        boolean isPossible() {
            return super.isPossible() && TopcatUtils.canSplat();
        }

        static /* synthetic */ ActivationQueryWindow access$400(SpectrumActivatorFactory x0) {
            return x0.ActivationQueryWindow.this;
        }
    }

    private class ImageActivatorFactory
    extends ColumnActivatorFactory {
        ImageActivatorFactory() {
            super("Image");
            this.selectColumnByUCD("VOX:Image_AccessReference");
        }

        Activator makeActivator(TableColumn tcol) {
            return new ColumnActivator(this, "image", tcol, tcol){
                private final /* synthetic */ TableColumn val$tcol;
                private final /* synthetic */ ImageActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$tcol = val$tcol;
                    super(x0, x1);
                }

                String activateValue(Object val) {
                    return val == null ? null : Image.displayImage(ActivationQueryWindow.access$300(ImageActivatorFactory.access$200(this.this$1), this.val$tcol), val.toString());
                }
            };
        }

        static /* synthetic */ ActivationQueryWindow access$200(ImageActivatorFactory x0) {
            return x0.ActivationQueryWindow.this;
        }
    }

    private abstract class ColumnActivatorFactory
    extends ActivatorFactory {
        JComboBox colSelector_;

        ColumnActivatorFactory(String descrip) {
            super("Display Named " + descrip);
            this.colSelector_ = new RestrictedColumnComboBoxModel(this, ActivationQueryWindow.this.tcModel_.getColumnModel(), true){
                private final /* synthetic */ ColumnActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1);
                }

                public boolean acceptColumn(ColumnInfo cinfo) {
                    Class clazz = cinfo.getContentClass();
                    return clazz == (class$java$lang$String == null ? (class$java$lang$String = ActivationQueryWindow.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$net$URL == null ? (class$java$net$URL = ActivationQueryWindow.class$("java.net.URL")) : class$java$net$URL) || clazz == (class$java$net$URI == null ? (class$java$net$URI = ActivationQueryWindow.class$("java.net.URI")) : class$java$net$URI) || clazz == (class$java$io$File == null ? (class$java$io$File = ActivationQueryWindow.class$("java.io.File")) : class$java$io$File);
                }
            }.makeComboBox();
            this.colSelector_.setSelectedIndex(0);
            JLabel colLabel = new JLabel(descrip + " Location column: ");
            this.enablables_ = new Component[]{colLabel, this.colSelector_};
            Box box = Box.createHorizontalBox();
            box.add(colLabel);
            box.add(this.colSelector_);
            box.add(Box.createHorizontalGlue());
            this.queryPanel_.add(box);
        }

        boolean isPossible() {
            return this.colSelector_.getItemCount() > 1;
        }

        Activator makeActivator() {
            TableColumn tcol = (TableColumn)this.colSelector_.getSelectedItem();
            if (tcol == ColumnComboBoxModel.NO_COLUMN) {
                tcol = null;
            }
            if (tcol != null) {
                return this.makeActivator(tcol);
            }
            return null;
        }

        protected void selectColumnByUCD(String ucd) {
            int i = 0;
            while (i < this.colSelector_.getItemCount()) {
                ColumnInfo cinfo;
                TableColumn tcol = (TableColumn)this.colSelector_.getItemAt(i);
                if (tcol instanceof StarTableColumn && ucd.equals((cinfo = ((StarTableColumn)tcol).getColumnInfo()).getUCD())) {
                    this.colSelector_.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }

        abstract Activator makeActivator(TableColumn var1);
    }

    private class CutoutActivatorFactory
    extends ActivatorFactory {
        CutoutSelector cutter_;

        CutoutActivatorFactory() {
            super("Display Cutout Image");
            this.cutter_ = new CutoutSelector(ActivationQueryWindow.this.tcModel_);
            Box box = Box.createHorizontalBox();
            box.add(this.cutter_);
            box.add(Box.createHorizontalGlue());
            this.queryPanel_.add(box);
            this.enablables_ = new Component[]{this.cutter_};
        }

        Activator makeActivator() {
            return this.cutter_.makeActivator();
        }
    }

    private class JELActivatorFactory
    extends ActivatorFactory {
        JComboBox codeField_;

        JELActivatorFactory() {
            super("Execute Custom Code");
            this.codeField_ = ActivationQueryWindow.this.tcModel_.getActivatorList().makeComboBox();
            this.codeField_.setEditable(true);
            this.codeField_.validate();
            JLabel codeLabel = new JLabel("Executable Expression: ");
            this.enablables_ = new Component[]{this.codeField_, codeLabel};
            Box box = Box.createHorizontalBox();
            box.add(codeLabel);
            box.add(this.codeField_);
            this.queryPanel_.add(box);
        }

        Activator makeActivator() {
            Object sel = this.codeField_.getSelectedItem();
            String expr = sel == null ? null : sel.toString();
            try {
                Activator activ = ActivationQueryWindow.this.tcModel_.makeActivator(expr);
                OptionsListModel actlist = ActivationQueryWindow.this.tcModel_.getActivatorList();
                if (!actlist.contains(expr)) {
                    actlist.add(expr);
                }
                return activ;
            }
            catch (CompilationException e) {
                String[] msg = new String[]{"Syntax error in activation function \"" + expr + "\":", e.getMessage()};
                JOptionPane.showMessageDialog(ActivationQueryWindow.this, msg, "Syntax Error", 0);
                return null;
            }
        }
    }

    private class NopActivatorFactory
    extends ActivatorFactory {
        JComponent qcomp_;

        NopActivatorFactory() {
            super("No Action");
            this.qcomp_ = new JPanel();
        }

        Activator makeActivator() {
            return Activator.NOP;
        }
    }

    private abstract class ActivatorFactory
    implements ChangeListener {
        String description_;
        JRadioButton button_;
        JPanel queryPanel_;
        Component[] enablables_;

        ActivatorFactory(String desc) {
            this.description_ = desc;
            this.button_ = new JRadioButton(desc);
            this.button_.addChangeListener(this);
            this.queryPanel_ = new JPanel(new BorderLayout());
        }

        JComponent getQueryComponent() {
            return this.queryPanel_;
        }

        boolean isPossible() {
            return true;
        }

        public void setEnabled(boolean enabled) {
            if (this.enablables_ != null) {
                int i = 0;
                while (i < this.enablables_.length) {
                    this.enablables_[i].setEnabled(enabled);
                    ++i;
                }
            }
        }

        abstract Activator makeActivator();

        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() == this.button_) {
                boolean active = this.button_.isSelected();
                this.setEnabled(active);
                if (active) {
                    ActivationQueryWindow.this.activeFactory_ = this;
                }
            }
        }
    }
}

