/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnList
implements TableColumnModelListener {
    private final TableColumnModel columnModel;
    private final List columnList;
    private final List active;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ColumnList;

    public ColumnList(TableColumnModel columnModel) {
        this.columnModel = columnModel;
        this.columnList = Collections.list(columnModel.getColumns());
        this.active = new ArrayList<Boolean>(Collections.nCopies(this.columnList.size(), Boolean.TRUE));
        columnModel.addColumnModelListener(this);
    }

    public TableColumn getColumn(int jcol) {
        return (TableColumn)this.columnList.get(jcol);
    }

    public boolean isActive(int jcol) {
        return (Boolean)this.active.get(jcol);
    }

    public void setActive(int jcol, boolean actv) {
        if (actv != this.isActive(jcol)) {
            TableColumn tcol = this.getColumn(jcol);
            if (actv) {
                if (!$assertionsDisabled && this.isActive(jcol)) {
                    throw new AssertionError();
                }
                int last1 = this.columnModel.getColumnCount();
                this.columnModel.addColumn(tcol);
                this.columnModel.moveColumn(last1, this.getModelIndex(jcol));
            } else {
                if (!$assertionsDisabled && !this.isActive(jcol)) {
                    throw new AssertionError();
                }
                this.columnModel.removeColumn(tcol);
            }
        }
    }

    public int size() {
        return this.columnList.size();
    }

    public int indexOf(TableColumn tcol) {
        return this.columnList.indexOf(tcol);
    }

    public int getModelIndex(int jcol) {
        int i = 0;
        int j = 0;
        while (j < jcol) {
            if (this.isActive(j)) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    private boolean invariants() {
        int ncol = this.size();
        boolean ok = true;
        ok = ok && ncol == this.columnList.size() && ncol == this.active.size();
        int i = 0;
        int j = 0;
        while (j < ncol) {
            if (this.isActive(j)) {
                ok = ok && this.columnModel.getColumn(i++) == this.columnList.get(j);
            }
            ++j;
        }
        return ok;
    }

    private int getExistingActiveIndex(int i) {
        int nActive = 0;
        int ncol = this.size();
        int j = 0;
        while (j < ncol) {
            if (this.isActive(j) && nActive++ == i) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private int getNewActiveIndex(int i) {
        int nActive = 0;
        int ncol = this.size();
        int j = 0;
        while (j < ncol) {
            if (nActive == i) {
                return j;
            }
            if (this.isActive(j)) {
                ++nActive;
            }
            ++j;
        }
        return ncol;
    }

    public void columnAdded(TableColumnModelEvent evt) {
        int iTo = evt.getToIndex();
        TableColumn tcol = this.columnModel.getColumn(iTo);
        if (!this.columnList.contains(tcol)) {
            int jTo = this.getNewActiveIndex(iTo);
            this.columnList.add(jTo, tcol);
            this.active.add(jTo, Boolean.TRUE);
        } else {
            int jcol = this.columnList.indexOf(tcol);
            if (!$assertionsDisabled && this.isActive(jcol)) {
                throw new AssertionError();
            }
            this.active.set(jcol, Boolean.TRUE);
        }
    }

    public void columnMoved(TableColumnModelEvent evt) {
        int iFrom = evt.getFromIndex();
        int jFrom = this.getExistingActiveIndex(iFrom);
        int iTo = evt.getToIndex();
        int jTo = this.getExistingActiveIndex(iTo);
        TableColumn tcol = this.columnModel.getColumn(iTo);
        if (tcol == this.columnList.get(jFrom) && iFrom != iTo) {
            if (!$assertionsDisabled && !this.isActive(jFrom)) {
                throw new AssertionError();
            }
            this.columnList.remove(jFrom);
            this.active.remove(jFrom);
            this.columnList.add(jTo, tcol);
            this.active.add(jTo, Boolean.TRUE);
        }
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        int iFrom = evt.getFromIndex();
        int jFrom = this.getExistingActiveIndex(iFrom);
        if (!$assertionsDisabled && !this.isActive(jFrom)) {
            throw new AssertionError();
        }
        this.active.set(jFrom, Boolean.FALSE);
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$ColumnList == null ? (class$uk$ac$starlink$topcat$ColumnList = ColumnList.class$("uk.ac.starlink.topcat.ColumnList")) : class$uk$ac$starlink$topcat$ColumnList).desiredAssertionStatus();
    }
}

