/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.ColumnConverter;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;

public class ColumnSelectorModel
implements ListDataListener {
    private final TopcatModel tcModel_;
    private final ValueInfo info_;
    private final ComboBoxModel colChooser_;
    private final ComboBoxModel convChooser_;
    private final ColumnConverter converter0_;
    private final Map convMap_ = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ColumnSelectorModel;

    public ColumnSelectorModel(TopcatModel tcModel, ValueInfo info) {
        this.tcModel_ = tcModel;
        this.info_ = info;
        this.colChooser_ = ColumnSelectorModel.makeColumnModel(this.tcModel_, info);
        this.colChooser_.addListDataListener(this);
        String units = info.getUnitString();
        ColumnConverter[] converters = ColumnConverter.getConverters(info);
        if (converters.length > 1) {
            this.converter0_ = null;
            this.convChooser_ = new DefaultComboBoxModel<ColumnConverter>(converters);
            this.convChooser_.addListDataListener(this);
        } else {
            this.convChooser_ = null;
            this.converter0_ = converters[0];
        }
        StarTableColumn tcol = this.getSelectedColumn();
        if (tcol != null) {
            this.columnSelected(tcol);
        }
    }

    public ColumnConverter getConverter() {
        if (this.converter0_ != null) {
            return this.converter0_;
        }
        return (ColumnConverter)this.convChooser_.getSelectedItem();
    }

    public ValueInfo getValueInfo() {
        return this.info_;
    }

    public ComboBoxModel getColumnModel() {
        return this.colChooser_;
    }

    public ComboBoxModel getConverterModel() {
        return this.convChooser_;
    }

    public ColumnData getColumnData() {
        StarTableColumn tcol = this.getSelectedColumn();
        if (tcol == null) {
            return null;
        }
        int icol = tcol.getModelIndex();
        final ColumnConverter colConverter = this.getConverter();
        PlasticStarTable table = this.tcModel_.getDataModel();
        if (!$assertionsDisabled && colConverter == null) {
            throw new AssertionError();
        }
        return new ColumnData(tcol.getColumnInfo(), (StarTable)table, icol){
            private final /* synthetic */ StarTable val$table;
            private final /* synthetic */ int val$icol;
            {
                this.val$table = val$table;
                this.val$icol = val$icol;
                super(x0);
            }

            public Object readValue(long irow) throws IOException {
                return colConverter.convertValue(this.val$table.getCell(irow, this.val$icol));
            }
        };
    }

    private StarTableColumn getSelectedColumn() {
        return (StarTableColumn)this.colChooser_.getSelectedItem();
    }

    private void columnSelected(StarTableColumn tcol) {
        if (this.convChooser_ != null) {
            ColumnConverter storedConverter = (ColumnConverter)this.convMap_.get(tcol);
            if (storedConverter != null) {
                this.convChooser_.setSelectedItem(storedConverter);
            } else {
                this.convChooser_.setSelectedItem(this.guessConverter(tcol.getColumnInfo()));
            }
        }
    }

    private void converterSelected(ColumnConverter conv) {
        this.convMap_.put(this.colChooser_.getSelectedItem(), conv);
    }

    private ColumnConverter guessConverter(ColumnInfo cinfo) {
        block13: {
            if (this.converter0_ != null) {
                return this.converter0_;
            }
            String units = this.info_.getUnitString();
            String cunits = cinfo.getUnitString();
            if (units == null || cunits == null) break block13;
            units = units.toLowerCase();
            cunits = cunits.toLowerCase();
            int nconv = this.convChooser_.getSize();
            if (units.equals("radian") || units.equals("radians")) {
                if (cunits.startsWith("rad")) {
                    int i = 0;
                    while (i < nconv) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (conv.toString().toLowerCase().startsWith("rad")) {
                            return conv;
                        }
                        ++i;
                    }
                } else if (cunits.startsWith("deg")) {
                    int i = 0;
                    while (i < nconv) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (conv.toString().toLowerCase().startsWith("deg")) {
                            return conv;
                        }
                        ++i;
                    }
                } else if (cunits.startsWith("hour") || cunits.equals("hr") || cunits.equals("hrs")) {
                    int i = 0;
                    while (i < nconv) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (conv.toString().toLowerCase().startsWith("hour")) {
                            return conv;
                        }
                        ++i;
                    }
                }
            }
        }
        return (ColumnConverter)this.convChooser_.getElementAt(0);
    }

    private static ComboBoxModel makeColumnModel(TopcatModel tcModel, ValueInfo argInfo) {
        String name;
        TableColumnModel columnModel = tcModel.getColumnModel();
        RestrictedColumnComboBoxModel model = RestrictedColumnComboBoxModel.makeClassColumnComboBoxModel(columnModel, argInfo.isNullable(), argInfo.getContentClass());
        int selection = -1;
        ColumnInfo[] cinfos = Tables.getColumnInfos((StarTable)tcModel.getApparentStarTable());
        int ncol = cinfos.length;
        String ucd = argInfo.getUCD();
        if (ucd != null) {
            int i = 0;
            while (i < ncol && selection < 0) {
                if (model.acceptColumn(cinfos[i]) && cinfos[i].getUCD() != null && cinfos[i].getUCD().indexOf(ucd) >= 0) {
                    selection = i;
                }
                ++i;
            }
        }
        if ((name = argInfo.getName().toLowerCase()) != null && selection < 0) {
            int i = 0;
            while (i < ncol && selection < 0) {
                String cname;
                if (model.acceptColumn(cinfos[i]) && (cname = cinfos[i].getName()) != null && cname.toLowerCase().startsWith(name)) {
                    selection = i;
                }
                ++i;
            }
        }
        if (selection >= 0) {
            model.setSelectedItem(columnModel.getColumn(selection));
        }
        return model;
    }

    public void intervalAdded(ListDataEvent evt) {
    }

    public void intervalRemoved(ListDataEvent evt) {
    }

    public void contentsChanged(ListDataEvent evt) {
        if (evt.getSource() == this.colChooser_) {
            StarTableColumn col = this.getSelectedColumn();
            if (col != null) {
                this.columnSelected(col);
            }
        } else if (evt.getSource() == this.convChooser_) {
            ColumnConverter conv = (ColumnConverter)this.convChooser_.getSelectedItem();
            if (conv != null) {
                this.converterSelected(conv);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$ColumnSelectorModel == null ? (class$uk$ac$starlink$topcat$ColumnSelectorModel = ColumnSelectorModel.class$("uk.ac.starlink.topcat.ColumnSelectorModel")) : class$uk$ac$starlink$topcat$ColumnSelectorModel).desiredAssertionStatus();
    }
}

