/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.gui.PasteLoader;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ConcatWindow;
import uk.ac.starlink.topcat.Driver;
import uk.ac.starlink.topcat.LoadQueryWindow;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.MirageHandler;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.UpDownButton;
import uk.ac.starlink.topcat.ViewerTableModel;
import uk.ac.starlink.topcat.join.MatchWindow;
import uk.ac.starlink.util.gui.DragListener;
import uk.ac.starlink.util.gui.ErrorDialog;

public class ControlWindow
extends AuxWindow
implements ListSelectionListener,
ListDataListener,
TableModelListener,
TableColumnModelListener,
TopcatListener {
    private static ControlWindow instance;
    private final JList tablesList;
    private final DefaultListModel tablesModel;
    private final TableModelListener tableWatcher = this;
    private final TopcatListener topcatWatcher = this;
    private final ListSelectionListener selectionWatcher = this;
    private final ListDataListener tablesWatcher = this;
    private final TableColumnModelListener columnWatcher = this;
    private final WindowListener windowWatcher = new ControlWindowListener();
    private final StarTableOutput taboutput = new StarTableOutput();
    private final boolean canWrite = Driver.canWrite();
    private final boolean canRead = Driver.canRead();
    private final TransferHandler importTransferHandler = new ControlTransferHandler(true, false);
    private final TransferHandler exportTransferHandler = new ControlTransferHandler(false, true);
    private final TransferHandler bothTransferHandler = new ControlTransferHandler(true, true);
    private final Window window = this;
    private final ComboBoxModel dummyComboBoxModel = new DefaultComboBoxModel();
    private final ButtonModel dummyButtonModel = new DefaultButtonModel();
    private StarTableFactory tabfact = new StarTableFactory(true);
    private TableLoadChooser loadChooser;
    private LoadQueryWindow loadWindow;
    private ConcatWindow concatWindow;
    private final JTextField idField = new JTextField();
    private final JLabel indexLabel = new JLabel();
    private final JLabel locLabel = new JLabel();
    private final JLabel nameLabel = new JLabel();
    private final JLabel rowsLabel = new JLabel();
    private final JLabel colsLabel = new JLabel();
    private final JComboBox subsetSelector = new JComboBox();
    private final JComboBox sortSelector = new JComboBox();
    private final JToggleButton sortSenseButton = new UpDownButton();
    private final JButton activatorButton = new JButton();
    private final Action viewerAct;
    private final Action paramAct;
    private final Action colinfoAct;
    private final Action statsAct;
    private final Action subsetAct;
    private final Action plotAct;
    private final Action readAct;
    private final Action writeAct;
    private final Action dupAct;
    private final Action mirageAct;
    private final Action removeAct;
    private final Action concatAct;
    private final Action[] matchActs;
    private final ShowAction[] showActs;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ControlWindow;

    private ControlWindow() {
        super("Starlink TOPCAT", (Component)null);
        this.tablesModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesModel);
        this.tablesList.addListSelectionListener(this.selectionWatcher);
        this.tablesModel.addListDataListener(this.tablesWatcher);
        this.idField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ControlWindow.this.getCurrentModel().setLabel(ControlWindow.this.idField.getText());
            }
        });
        InfoStack info = new InfoStack();
        info.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        info.addLine("Label", this.idField);
        info.addLine("Location", this.locLabel);
        info.addLine("Name", this.nameLabel);
        info.addLine("Rows", this.rowsLabel);
        info.addLine("Columns", this.colsLabel);
        info.addLine("Sort Order", new Component[]{this.sortSenseButton, this.sortSelector});
        info.addLine("Row Subset", this.subsetSelector);
        info.addLine("Activation Action", this.activatorButton);
        this.activatorButton.setText("           ");
        info.fillIn();
        JSplitPane splitter = new JSplitPane(1);
        JScrollPane listScroller = new JScrollPane(this.tablesList);
        JScrollPane infoScroller = new JScrollPane(info);
        listScroller.setBorder(AuxWindow.makeTitledBorder("Table List"));
        infoScroller.setBorder(AuxWindow.makeTitledBorder("Current Table Properties"));
        splitter.setLeftComponent(listScroller);
        splitter.setRightComponent(infoScroller);
        splitter.setPreferredSize(new Dimension(600, 250));
        splitter.setDividerLocation(192);
        this.getMainArea().add(splitter);
        this.tablesList.setDragEnabled(true);
        this.tablesList.setTransferHandler(this.bothTransferHandler);
        this.removeAct = new ControlAction("Discard Table", ResourceIcon.DELETE, "Forget about the current table");
        this.readAct = new ControlAction("Load Table", ResourceIcon.LOAD, "Open a new table");
        this.concatAct = new ControlAction("Concatenate Tables", ResourceIcon.CONCAT, "Join tables by concatenating them");
        this.readAct.setEnabled(this.canRead);
        this.dupAct = new ExportAction("Duplicate Table", ResourceIcon.COPY, "Create a duplicate of the current table");
        this.mirageAct = new ExportAction("Export To Mirage", null, "Launch Mirage to display the current table");
        this.mirageAct.setEnabled(MirageHandler.isMirageAvailable());
        this.viewerAct = new ModelAction("Table Data", ResourceIcon.VIEWER, "Display table cell data");
        this.paramAct = new ModelAction("Table Parameters", ResourceIcon.PARAMS, "Display table metadata");
        this.colinfoAct = new ModelAction("Column Info", ResourceIcon.COLUMNS, "Display column metadata");
        this.subsetAct = new ModelAction("Row Subsets", ResourceIcon.SUBSETS, "Display row subsets");
        this.statsAct = new ModelAction("Column Statistics", ResourceIcon.STATS, "Display statistics for each column");
        this.plotAct = new ModelAction("Plot", ResourceIcon.PLOT, "Plot table columns");
        this.writeAct = new ModelAction("Save Table", ResourceIcon.SAVE, "Write out the current table");
        this.matchActs = new Action[]{new MatchWindowAction("Internal Match", ResourceIcon.MATCH1, "Perform row matching on a single table", 1), new MatchWindowAction("Pair Match", ResourceIcon.MATCH2, "Create new table by matching rows in two existing tables", 2), new MatchWindowAction("Triple Match", ResourceIcon.BLANK, "Create new table by matching rows in three existing tables", 3), new MatchWindowAction("Quadruple Match", ResourceIcon.BLANK, "Create new table by matching rows in four existing tables", 4)};
        PasteLoader pasteLoader = new PasteLoader(this){

            protected void tableLoaded(StarTable table, String loc) {
                ControlWindow.this.addTable(table, loc, true);
            }

            public StarTableFactory getTableFactory() {
                return ControlWindow.this.tabfact;
            }
        };
        this.tablesList.addMouseListener((MouseListener)pasteLoader);
        JButton readButton = new JButton(this.readAct);
        readButton.setText(null);
        readButton.setTransferHandler(this.importTransferHandler);
        readButton.addMouseListener((MouseListener)pasteLoader);
        this.tablesList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    ActionEvent aevt = new ActionEvent(evt.getSource(), evt.getID(), "Display Table");
                    ControlWindow.this.viewerAct.actionPerformed(aevt);
                }
            }
        });
        Object actkey = this.viewerAct.getValue("Name");
        this.tablesList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), actkey);
        this.tablesList.getActionMap().put(actkey, this.viewerAct);
        JToolBar toolBar = this.getToolBar();
        toolBar.setFloatable(true);
        toolBar.add(readButton);
        this.configureExportSource(toolBar.add(this.writeAct));
        this.configureExportSource(toolBar.add(this.dupAct));
        toolBar.addSeparator();
        toolBar.add(this.viewerAct);
        toolBar.add(this.paramAct);
        toolBar.add(this.colinfoAct);
        toolBar.add(this.subsetAct);
        toolBar.add(this.statsAct);
        toolBar.add(this.plotAct);
        toolBar.addSeparator();
        toolBar.add(this.concatAct);
        toolBar.add(this.matchActs[0]);
        toolBar.add(this.matchActs[1]);
        toolBar.addSeparator();
        toolBar.add(MethodWindow.getWindowAction(this, true));
        toolBar.addSeparator();
        JMenu fileMenu = this.getFileMenu();
        int fileMenuPos = 0;
        fileMenu.insert(this.readAct, fileMenuPos++);
        fileMenu.insert(this.removeAct, fileMenuPos++);
        fileMenu.insertSeparator(fileMenuPos++);
        fileMenu.insert(this.writeAct, fileMenuPos++);
        fileMenu.insert(this.dupAct, fileMenuPos++);
        if (MirageHandler.isMirageAvailable()) {
            fileMenu.insert(this.mirageAct, fileMenuPos++);
        }
        fileMenu.insertSeparator(fileMenuPos++);
        JMenu viewMenu = new JMenu("TableViews");
        viewMenu.setMnemonic(86);
        viewMenu.add(this.viewerAct);
        viewMenu.add(this.paramAct);
        viewMenu.add(this.colinfoAct);
        viewMenu.add(this.subsetAct);
        viewMenu.add(this.statsAct);
        viewMenu.add(this.plotAct);
        this.getJMenuBar().add(viewMenu);
        JMenu winMenu = new JMenu("Windows");
        winMenu.setMnemonic(87);
        this.showActs = this.makeShowActions();
        int i = 0;
        while (i < this.showActs.length) {
            winMenu.add(this.showActs[i]);
            ++i;
        }
        this.getJMenuBar().add(winMenu);
        JMenu joinMenu = new JMenu("Joins");
        joinMenu.setMnemonic(74);
        joinMenu.add(this.concatAct);
        int i2 = 0;
        while (i2 < this.matchActs.length) {
            joinMenu.add(this.matchActs[i2]);
            ++i2;
        }
        this.getJMenuBar().add(joinMenu);
        this.setCloseIsExit();
        this.addHelp("ControlWindow");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowWatcher);
        this.updateInfo();
        this.updateControls();
        this.pack();
        this.setVisible(true);
    }

    public static ControlWindow getInstance() {
        if (instance == null) {
            instance = new ControlWindow();
        }
        return instance;
    }

    public TopcatModel addTable(StarTable table, String location, boolean select) {
        TopcatModel tcModel = new TopcatModel(table, location, this);
        tcModel.setLabel(ControlWindow.shorten(location));
        this.tablesModel.addElement(tcModel);
        if (select || this.tablesList.getSelectedValue() == null) {
            this.tablesList.setSelectedValue(tcModel, true);
        }
        if (select) {
            this.makeVisible();
        }
        return tcModel;
    }

    public void removeTable(TopcatModel model) {
        if (this.tablesModel.contains(model)) {
            model.hideWindows();
            this.tablesList.clearSelection();
            this.tablesModel.removeElement(model);
        }
    }

    private TopcatModel getCurrentModel() {
        return (TopcatModel)this.tablesList.getSelectedValue();
    }

    public ListModel getTablesListModel() {
        return this.tablesModel;
    }

    public LoadQueryWindow getLoader() {
        if (this.loadWindow == null) {
            this.loadWindow = new LoadQueryWindow(this.tabfact, this.getLoadChooser(), this){

                protected void performLoading(StarTable st, String loc) {
                    ControlWindow.this.addTable(st, loc, true);
                }
            };
        }
        return this.loadWindow;
    }

    public ConcatWindow getConcatWindow() {
        if (this.concatWindow == null) {
            this.concatWindow = new ConcatWindow((Component)this);
        }
        return this.concatWindow;
    }

    public StarTableFactory getTableFactory() {
        return this.tabfact;
    }

    public StarTableOutput getTableOutput() {
        return this.taboutput;
    }

    public void setTableFactory(StarTableFactory tabfact) {
        this.tabfact = tabfact;
    }

    public TableLoadChooser getLoadChooser() {
        if (this.loadChooser == null) {
            this.loadChooser = new TableLoadChooser(this.getTableFactory());
        }
        return this.loadChooser;
    }

    public void setLoadChooser(TableLoadChooser chooser) {
        this.loadChooser = chooser;
    }

    public boolean exit(boolean confirm) {
        if (!confirm || this.tablesModel.getSize() == 0 || this.confirm("Shut down TOPCAT", "Confirm Exit")) {
            this.removeWindowListener(this.windowWatcher);
            if (Driver.isStandalone()) {
                System.exit(0);
            } else {
                Enumeration en = this.tablesModel.elements();
                while (en.hasMoreElements()) {
                    this.removeTable((TopcatModel)en.nextElement());
                }
                this.dispose();
            }
            return true;
        }
        return false;
    }

    private void updateInfo() {
        boolean hasModel;
        TopcatModel tcModel = this.getCurrentModel();
        boolean bl = hasModel = tcModel != null;
        if (hasModel) {
            PlasticStarTable dataModel = tcModel.getDataModel();
            ViewerTableModel viewModel = tcModel.getViewModel();
            TableColumnModel columnModel = tcModel.getColumnModel();
            long totCols = dataModel.getColumnCount();
            long totRows = dataModel.getRowCount();
            int visCols = columnModel.getColumnCount();
            int visRows = viewModel.getRowCount();
            String loc = tcModel.getLocation();
            String name = dataModel.getName();
            Activator activator = tcModel.getActivator();
            this.idField.setText(tcModel.getLabel());
            this.indexLabel.setText(tcModel.getID() + ": ");
            this.locLabel.setText(loc);
            this.nameLabel.setText(loc.equals(name) ? null : name);
            this.rowsLabel.setText(totRows + ((long)visRows == totRows ? "" : " (" + visRows + " apparent)"));
            this.colsLabel.setText(totCols + ((long)visCols == totCols ? "" : " (" + visCols + " apparent)"));
            this.sortSelector.setModel(tcModel.getSortSelectionModel());
            this.subsetSelector.setModel(tcModel.getSubsetSelectionModel());
            this.sortSenseButton.setModel(tcModel.getSortSenseModel());
            this.activatorButton.setAction(tcModel.getActivationAction());
            this.activatorButton.setText(activator.toString());
        } else {
            this.idField.setText(null);
            this.indexLabel.setText("0: ");
            this.locLabel.setText(null);
            this.nameLabel.setText(null);
            this.rowsLabel.setText(null);
            this.colsLabel.setText(null);
            this.sortSelector.setModel(this.dummyComboBoxModel);
            this.subsetSelector.setModel(this.dummyComboBoxModel);
            this.sortSenseButton.setModel(this.dummyButtonModel);
            this.activatorButton.setModel(this.dummyButtonModel);
        }
        this.writeAct.setEnabled(hasModel && this.canWrite);
        this.dupAct.setEnabled(hasModel);
        this.mirageAct.setEnabled(hasModel);
        this.removeAct.setEnabled(hasModel);
        this.subsetSelector.setEnabled(hasModel);
        this.sortSelector.setEnabled(hasModel);
        this.sortSenseButton.setEnabled(hasModel);
        this.viewerAct.setEnabled(hasModel);
        this.paramAct.setEnabled(hasModel);
        this.colinfoAct.setEnabled(hasModel);
        this.statsAct.setEnabled(hasModel);
        this.subsetAct.setEnabled(hasModel);
        this.plotAct.setEnabled(hasModel);
        int i = 0;
        while (i < this.showActs.length) {
            ShowAction sact = this.showActs[i];
            if (sact.selEffect != sact.otherEffect) {
                sact.setEnabled(hasModel);
            }
            ++i;
        }
        this.idField.setEnabled(hasModel);
        this.idField.setEditable(hasModel);
    }

    public void updateControls() {
        boolean hasTables = this.tablesModel.getSize() > 0;
        this.concatAct.setEnabled(hasTables);
        int i = 0;
        while (i < this.matchActs.length) {
            this.matchActs[i].setEnabled(hasTables);
            ++i;
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        int watchCount = 0;
        int i = evt.getFirstIndex();
        while (i <= evt.getLastIndex()) {
            if (i < this.tablesModel.size()) {
                TopcatModel tcModel = (TopcatModel)this.tablesModel.getElementAt(i);
                ViewerTableModel viewModel = tcModel.getViewModel();
                TableColumnModel columnModel = tcModel.getColumnModel();
                if (this.tablesList.isSelectedIndex(i)) {
                    ++watchCount;
                    tcModel.addTopcatListener(this.topcatWatcher);
                    viewModel.addTableModelListener(this.tableWatcher);
                    columnModel.addColumnModelListener(this.columnWatcher);
                } else {
                    tcModel.removeTopcatListener(this.topcatWatcher);
                    viewModel.removeTableModelListener(this.tableWatcher);
                    columnModel.removeColumnModelListener(this.columnWatcher);
                }
            }
            ++i;
        }
        if (!$assertionsDisabled && watchCount > 1) {
            throw new AssertionError();
        }
        this.updateInfo();
    }

    public void tableChanged(TableModelEvent evt) {
        this.updateInfo();
    }

    public void modelChanged(TopcatModel tcModel, int code) {
        switch (code) {
            case 1: {
                this.updateInfo();
                int index = this.tablesModel.indexOf(tcModel);
                if (index < 0) break;
                ListDataEvent event = new ListDataEvent(this, 0, index, index);
                ListDataListener[] listWatchers = this.tablesModel.getListDataListeners();
                int i = 0;
                while (i < listWatchers.length) {
                    listWatchers[i].contentsChanged(event);
                    ++i;
                }
                break;
            }
            case 2: {
                this.updateInfo();
            }
        }
    }

    public void columnAdded(TableColumnModelEvent evt) {
        this.updateInfo();
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        this.updateInfo();
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnMoved(TableColumnModelEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    public void contentsChanged(ListDataEvent evt) {
        this.updateControls();
    }

    public void intervalAdded(ListDataEvent evt) {
        this.updateControls();
    }

    public void intervalRemoved(ListDataEvent evt) {
        this.updateControls();
    }

    private ShowAction[] makeShowActions() {
        return new ShowAction[]{new ShowAction("Show Selected Views Only", "Show viewer windows for selected table only", WindowEffect.REVEAL, WindowEffect.HIDE), new ShowAction("Show Selected Views", "Show viewer windows for selected table", WindowEffect.REVEAL, WindowEffect.NOOP), new ShowAction("Show All Views", "Show viewer windows of all tables", WindowEffect.REVEAL, WindowEffect.REVEAL), new ShowAction("Hide Unselected Views", "Hide viewer windows for tables except selected one", WindowEffect.NOOP, WindowEffect.HIDE), new ShowAction("Hide Selected Views", "Hide viewer windows for selected table", WindowEffect.HIDE, WindowEffect.NOOP), new ShowAction("Hide All Views", "Hide viewer windows for all tables", WindowEffect.HIDE, WindowEffect.HIDE)};
    }

    private void configureExportSource(JComponent comp) {
        DragListener dragListener = new DragListener();
        comp.addMouseMotionListener((MouseMotionListener)dragListener);
        comp.addMouseListener((MouseListener)dragListener);
        comp.setTransferHandler(this.exportTransferHandler);
    }

    private static String shorten(String label) {
        int sindex = label.lastIndexOf(47);
        if (sindex < 0 || sindex == label.length() - 1) {
            sindex = label.lastIndexOf(92);
        }
        if (sindex < 0 || sindex == label.length() - 1) {
            sindex = label.lastIndexOf(58);
        }
        if (sindex > 0 && sindex < label.length() - 1) {
            label = label.substring(sindex + 1);
        }
        return label;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$ControlWindow == null ? (class$uk$ac$starlink$topcat$ControlWindow = ControlWindow.class$("uk.ac.starlink.topcat.ControlWindow")) : class$uk$ac$starlink$topcat$ControlWindow).desiredAssertionStatus();
    }

    private static class InfoStack
    extends JPanel {
        GridBagLayout layer = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();

        InfoStack() {
            this.setLayout(this.layer);
            this.c1.gridx = 0;
            this.c1.ipadx = 2;
            this.c1.ipady = 2;
            this.c1.anchor = 13;
            this.c2.gridx = 1;
            this.c2.ipadx = 2;
            this.c2.weightx = 1.0;
            this.c2.fill = 0;
            this.c2.gridwidth = 0;
            this.c2.anchor = 17;
        }

        void addLine(String name, JComponent comp) {
            ++this.c1.gridy;
            ++this.c2.gridy;
            this.addItem(new JLabel(name + ": "), this.c1);
            GridBagConstraints c2c = (GridBagConstraints)this.c2.clone();
            if (comp instanceof JTextField) {
                c2c.fill = 2;
            }
            this.addItem(comp, c2c);
        }

        void addLine(String name, Component[] comps) {
            ++this.c1.gridy;
            ++this.c2.gridy;
            this.addItem(new JLabel(name + ": "), this.c1);
            GridBagConstraints c2c = (GridBagConstraints)this.c2.clone();
            c2c.gridwidth = 1;
            c2c.weightx = 0.0;
            c2c.ipadx = 10;
            int i = 0;
            while (i < comps.length) {
                this.addItem(comps[i], c2c);
                ++c2c.gridx;
                ++i;
            }
        }

        void addItem(Component comp, GridBagConstraints c) {
            this.layer.setConstraints(comp, c);
            this.add(comp);
        }

        void fillIn() {
            ++this.c1.gridy;
            JPanel filler = new JPanel();
            this.c1.weighty = 1.0;
            this.layer.setConstraints(filler, this.c1);
            this.add(filler);
        }
    }

    private class ControlWindowListener
    extends WindowAdapter {
        private ControlWindowListener() {
        }

        public void windowClosing(WindowEvent evt) {
            ControlWindow.this.exit(true);
        }

        public void windowClosed(WindowEvent evt) {
            if (!ControlWindow.this.exit(true)) {
                ControlWindow.this.setVisible(true);
            }
        }
    }

    private class ControlTransferHandler
    extends TransferHandler {
        private boolean imprt;
        private boolean export;

        ControlTransferHandler(boolean imprt, boolean export) {
            this.imprt = imprt;
            this.export = export;
        }

        public int getSourceActions(JComponent comp) {
            return this.export && ControlWindow.this.getCurrentModel() != null ? 1 : 0;
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavs) {
            return this.imprt && ControlWindow.this.tabfact.canImport(flavs);
        }

        public Icon getVisualRepresentation() {
            return ResourceIcon.TABLE;
        }

        protected Transferable createTransferable(JComponent comp) {
            return ControlWindow.this.taboutput.transferStarTable(ControlWindow.this.getCurrentModel().getApparentStarTable());
        }

        public boolean importData(JComponent comp, Transferable trans) {
            StarTable table;
            try {
                table = ControlWindow.this.tabfact.makeStarTable(trans);
                if (table == null) {
                    return false;
                }
            }
            catch (IOException e) {
                ErrorDialog.showError((Component)ControlWindow.this.window, (String)"Drop Error", (Throwable)e, (String)"Table drop operation failed");
                return false;
            }
            try {
                table = ControlWindow.this.tabfact.randomTable(table);
                String loc = table.getName();
                loc = loc == null ? "dropped" : loc;
                ControlWindow.this.addTable(table, loc, true);
                return true;
            }
            catch (IOException e) {
                ErrorDialog.showError((Component)ControlWindow.this.window, (String)"I/O Error", (Throwable)e, (String)"Can't randomise table");
                return false;
            }
        }
    }

    private class ExportAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        ExportAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            block5: {
                StarTable table;
                block4: {
                    TopcatModel tcModel = ControlWindow.this.getCurrentModel();
                    if (!$assertionsDisabled && tcModel == null) {
                        throw new AssertionError((Object)"Action should be disabled!");
                    }
                    table = tcModel.getApparentStarTable();
                    if (this != ControlWindow.this.dupAct) break block4;
                    ControlWindow.this.addTable(table, "Copy of " + tcModel.getID(), true);
                    break block5;
                }
                if (this != ControlWindow.this.mirageAct) break block5;
                if (!$assertionsDisabled && !MirageHandler.isMirageAvailable()) {
                    throw new AssertionError();
                }
                try {
                    MirageHandler.invokeMirage(table, null);
                }
                catch (Exception e) {
                    ErrorDialog.showError((Component)ControlWindow.this.window, (String)"Mirage Error", (Throwable)e);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$ControlWindow == null ? (class$uk$ac$starlink$topcat$ControlWindow = ControlWindow.class$("uk.ac.starlink.topcat.ControlWindow")) : class$uk$ac$starlink$topcat$ControlWindow).desiredAssertionStatus();
        }
    }

    private static class WindowEffect {
        static final WindowEffect HIDE = new WindowEffect();
        static final WindowEffect REVEAL = new WindowEffect();
        static final WindowEffect NOOP = null;

        private WindowEffect() {
        }
    }

    private class ShowAction
    extends BasicAction {
        final WindowEffect selEffect;
        final WindowEffect otherEffect;

        ShowAction(String name, String shortdesc, WindowEffect selEffect, WindowEffect otherEffect) {
            super(name, null, shortdesc);
            this.selEffect = selEffect;
            this.otherEffect = otherEffect;
        }

        public void actionPerformed(ActionEvent evt) {
            int ntab = ControlWindow.this.tablesModel.getSize();
            int i = 0;
            while (i < ntab) {
                WindowEffect effect;
                boolean isSelected = ControlWindow.this.tablesList.isSelectedIndex(i);
                TopcatModel tcModel = (TopcatModel)ControlWindow.this.tablesModel.getElementAt(i);
                WindowEffect windowEffect = effect = isSelected ? this.selEffect : this.otherEffect;
                if (effect == WindowEffect.HIDE) {
                    tcModel.hideWindows();
                } else if (effect == WindowEffect.REVEAL) {
                    tcModel.revealWindows();
                }
                ++i;
            }
        }
    }

    private class ModelAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        ModelAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            Action act;
            TopcatModel tcModel = ControlWindow.this.getCurrentModel();
            if (tcModel == null && !$assertionsDisabled) {
                throw new AssertionError();
            }
            if (this == ControlWindow.this.viewerAct) {
                act = tcModel.getViewerAction();
            } else if (this == ControlWindow.this.paramAct) {
                act = tcModel.getParameterAction();
            } else if (this == ControlWindow.this.colinfoAct) {
                act = tcModel.getColumnInfoAction();
            } else if (this == ControlWindow.this.statsAct) {
                act = tcModel.getStatsAction();
            } else if (this == ControlWindow.this.subsetAct) {
                act = tcModel.getSubsetAction();
            } else if (this == ControlWindow.this.plotAct) {
                act = tcModel.getPlotAction();
            } else if (this == ControlWindow.this.writeAct) {
                act = tcModel.getSaveAction();
            } else {
                throw new AssertionError();
            }
            act.actionPerformed(evt);
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$ControlWindow == null ? (class$uk$ac$starlink$topcat$ControlWindow = ControlWindow.class$("uk.ac.starlink.topcat.ControlWindow")) : class$uk$ac$starlink$topcat$ControlWindow).desiredAssertionStatus();
        }
    }

    private class MatchWindowAction
    extends BasicAction {
        private final int nTable;
        private MatchWindow matchWin;

        MatchWindowAction(String name, Icon icon, String shortdesc, int nTable) {
            super(name, icon, shortdesc);
            this.nTable = nTable;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.matchWin == null) {
                this.matchWin = new MatchWindow((Component)ControlWindow.this, this.nTable);
            }
            this.matchWin.makeVisible();
        }
    }

    private class ControlAction
    extends BasicAction {
        ControlAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == ControlWindow.this.readAct) {
                ControlWindow.this.getLoader().makeVisible();
            } else if (this == ControlWindow.this.removeAct) {
                TopcatModel tcModel = ControlWindow.this.getCurrentModel();
                if (ControlWindow.this.confirm("Remove table \"" + tcModel + "\" from list?", "Confirm Remove")) {
                    ControlWindow.this.removeTable(tcModel);
                }
            } else if (this == ControlWindow.this.concatAct) {
                ControlWindow.this.getConcatWindow().makeVisible();
            } else {
                throw new AssertionError();
            }
        }
    }
}

