/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.gui.ErrorDialog;

public class Driver {
    private static boolean standalone;
    private static boolean securityChecked;
    private static Boolean canRead;
    private static Boolean canWrite;
    private static StarTable[] demoTables;
    private static Logger logger;
    private static StarTableFactory tabfact;
    private static ControlWindow control;
    private static String[] extraLoaders;
    private static final ValueInfo DEMOLOC_INFO;
    private static String[] KNOWN_DIALOGS;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$uk$ac$starlink$table$gui$SQLReadDialog;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$Driver;

    public static void setStandalone(boolean standalone) {
        Driver.standalone = standalone;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static boolean canRead() {
        Driver.checkSecurity();
        return canRead;
    }

    public static boolean canWrite() {
        Driver.checkSecurity();
        return canWrite;
    }

    private static void checkSecurity() {
        if (!securityChecked) {
            SecurityManager sman = System.getSecurityManager();
            if (sman == null) {
                canRead = Boolean.TRUE;
                canWrite = Boolean.TRUE;
            } else {
                String writeDir;
                String readDir;
                try {
                    readDir = System.getProperty("user.home");
                }
                catch (SecurityException e) {
                    readDir = ".";
                }
                try {
                    writeDir = System.getProperty("java.io.tmpdir");
                }
                catch (SecurityException e) {
                    writeDir = ".";
                }
                try {
                    sman.checkRead(readDir);
                    canRead = Boolean.TRUE;
                }
                catch (SecurityException e) {
                    canRead = Boolean.FALSE;
                }
                try {
                    sman.checkWrite(new File(writeDir, "tOpCTeSt.tmp").toString());
                    canWrite = Boolean.TRUE;
                }
                catch (SecurityException e) {
                    canWrite = Boolean.FALSE;
                }
            }
            if (!$assertionsDisabled && canRead == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && canWrite == null) {
                throw new AssertionError();
            }
        }
    }

    public static void main(String[] args) {
        String cmdname;
        try {
            Loader.loadProperties();
            cmdname = System.getProperty("uk.ac.starlink.topcat.cmdname");
        }
        catch (SecurityException e) {
            cmdname = null;
        }
        Loader.tweakGuiForMac();
        if (cmdname == null) {
            cmdname = "topcat";
        }
        String pre = "Usage: " + cmdname;
        String pad = pre.replaceAll(".", " ");
        String usage = pre + " [-help] [-demo] [-disk]\n" + pad + " [-tree] [-file] [-sql] [-cone] [-siap] [-registry]\n" + pad + " [[-f <format>] table ...]";
        Driver.setStandalone(true);
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        ArrayList<String> loaderList = new ArrayList<String>();
        boolean demo = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-h")) {
                System.out.println(Driver.getHelp(cmdname));
                return;
            }
            if (arg.equals("-demo")) {
                it.remove();
                demo = true;
                continue;
            }
            if (arg.equals("-disk")) {
                it.remove();
                tabfact.setStoragePolicy(StoragePolicy.PREFER_DISK);
                continue;
            }
            if (arg.equals("-f") || arg.equals("-format")) continue;
            if (arg.equals("-tree")) {
                it.remove();
                loaderList.add("uk.ac.starlink.datanode.tree.TreeTableLoadDialog");
                continue;
            }
            if (arg.equals("-file")) {
                it.remove();
                loaderList.add("uk.ac.starlink.table.gui.FileChooserLoader");
                continue;
            }
            if (arg.equals("-sql")) {
                it.remove();
                loaderList.add((class$uk$ac$starlink$table$gui$SQLReadDialog == null ? Driver.class$("uk.ac.starlink.table.gui.SQLReadDialog") : class$uk$ac$starlink$table$gui$SQLReadDialog).getName());
                continue;
            }
            if (arg.equals("-cone")) {
                it.remove();
                loaderList.add("uk.ac.starlink.vo.ConeSearchDialog");
                continue;
            }
            if (arg.equals("-siap")) {
                it.remove();
                loaderList.add("uk.ac.starlink.vo.SiapTableLoadDialog");
                continue;
            }
            if (arg.equals("-registry")) {
                it.remove();
                loaderList.add("uk.ac.starlink.vo.RegistryTableLoadDialog");
                continue;
            }
            if (!arg.startsWith("-")) continue;
            System.err.println(usage);
            System.exit(1);
        }
        extraLoaders = loaderList.toArray(new String[0]);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> handlers = new ArrayList<String>();
        String handler = null;
        Iterator it2 = argList.iterator();
        while (it2.hasNext()) {
            String arg = (String)it2.next();
            if (arg.equals("-f") || arg.equals("-format")) {
                if (it2.hasNext()) {
                    handler = (String)it2.next();
                    if (!handler.equals("auto")) continue;
                    handler = null;
                    continue;
                }
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            names.add(arg);
            handlers.add(handler);
        }
        int nload = names.size();
        if (!$assertionsDisabled && nload != handlers.size()) {
            throw new AssertionError();
        }
        try {
            Logger.getLogger("uk.ac.starlink.hds").setLevel(Level.OFF);
            Logger.getLogger("uk.ac.starlink.ast").setLevel(Level.OFF);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Driver.getControlWindow();
        if (demo) {
            StarTable[] demoTables = Driver.getDemoTables();
            int i = 0;
            while (i < demoTables.length) {
                StarTable table = demoTables[i];
                if (table != null) {
                    String loc = table.getParameterByName(DEMOLOC_INFO.getName()).getValue().toString();
                    Driver.addTableLater(table, "[Demo]:" + loc);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < nload) {
            final String name = (String)names.get(i);
            String hand = (String)handlers.get(i);
            try {
                StarTable startab = tabfact.makeStarTable(name, hand);
                Driver.addTableLater(tabfact.randomTable(startab), name);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (e instanceof TableFormatException) {
                            ErrorDialog.showError((Component)Driver.getControlWindow(), (String)"Load Error", (Throwable)e);
                        } else if (e instanceof FileNotFoundException) {
                            ErrorDialog.showError((Component)Driver.getControlWindow(), (String)"Load Error", (Throwable)e, (String)("No such file: " + name));
                        } else {
                            ErrorDialog.showError((Component)Driver.getControlWindow(), (String)"Load Error", (Throwable)e, (String)("Can't open table " + name));
                        }
                    }
                });
            }
            ++i;
        }
    }

    private static ControlWindow getControlWindow() {
        if (control == null) {
            TableLoadChooser chooser = Driver.makeLoadChooser();
            control = ControlWindow.getInstance();
            control.setTableFactory(tabfact);
            control.setLoadChooser(chooser);
        }
        return control;
    }

    private static void addTableLater(final StarTable table, final String location) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Driver.getControlWindow().addTable(table, location, false);
            }
        });
    }

    private static TableLoadChooser makeLoadChooser() {
        ArrayList<TableLoadDialog> dList = new ArrayList<TableLoadDialog>();
        dList.addAll(Arrays.asList(TableLoadChooser.makeDefaultLoadDialogs()));
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator it = dList.iterator();
        while (it.hasNext()) {
            nameList.add(it.next().getClass().getName());
        }
        int i = 0;
        while (i < extraLoaders.length) {
            String cname = extraLoaders[i];
            if (!nameList.contains(cname)) {
                try {
                    Class clazz = class$uk$ac$starlink$topcat$Driver == null ? Driver.class$("uk.ac.starlink.topcat.Driver") : class$uk$ac$starlink$topcat$Driver;
                    TableLoadDialog tld = (TableLoadDialog)Class.forName(extraLoaders[i]).newInstance();
                    dList.add(tld);
                }
                catch (Throwable th) {
                    System.err.println("Class loading error for optional loader:");
                    th.printStackTrace(System.err);
                    System.exit(1);
                }
            }
            ++i;
        }
        TableLoadDialog[] dialogs = dList.toArray(new TableLoadDialog[0]);
        return new TableLoadChooser(tabfact, dialogs, KNOWN_DIALOGS);
    }

    static StarTable[] getDemoTables() {
        String base = TopcatUtils.DEMO_LOCATION + '/';
        String[] demoNames = new String[]{"6dfgs_mini.xml.bz2", "cover.xml"};
        int ntab = demoNames.length;
        if (demoTables == null) {
            demoTables = new StarTable[ntab];
            StarTableFactory demoFactory = new StarTableFactory(true);
            int i = 0;
            while (i < ntab) {
                String demoName = demoNames[i];
                try {
                    String frag;
                    String name;
                    int fragIndex = demoName.indexOf(35);
                    if (fragIndex > 0) {
                        name = demoName.substring(0, fragIndex);
                        frag = demoName.substring(fragIndex + 1);
                    } else {
                        name = demoName;
                        frag = null;
                    }
                    URL url = (class$uk$ac$starlink$topcat$Driver == null ? Driver.class$("uk.ac.starlink.topcat.Driver") : class$uk$ac$starlink$topcat$Driver).getClassLoader().getResource(base + name);
                    if (url != null) {
                        DataSource datsrc = DataSource.makeDataSource((String)url.toString());
                        if (frag != null) {
                            datsrc.setPosition(frag);
                        }
                        StarTable table = demoFactory.makeStarTable(datsrc);
                        table.getParameters().add(new DescribedValue(DEMOLOC_INFO, (Object)demoName));
                        Driver.demoTables[i] = demoFactory.randomTable(table);
                    } else {
                        logger.warning("Demo table resource not located: " + base + demoName);
                    }
                }
                catch (IOException e) {
                    logger.warning("Demo table " + demoName + " not loaded: " + e.toString());
                }
                ++i;
            }
        }
        return demoTables;
    }

    private static String getHelp(String cmdname) {
        StringBuffer buf = new StringBuffer();
        String p1 = "\n\n    ";
        String p2 = "\n        ";
        buf.append("Usage: ").append(cmdname).append(" <flags> [[-f <format>] <table> ...]");
        buf.append(p1 + "Auto-detected formats: ").append(p2);
        Iterator it = tabfact.getDefaultBuilders().iterator();
        while (it.hasNext()) {
            buf.append(((TableBuilder)it.next()).getFormatName().toLowerCase());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(p1 + "All known formats:").append(p2);
        Iterator it2 = tabfact.getKnownFormats().iterator();
        while (it2.hasNext()) {
            buf.append(((String)it2.next()).toLowerCase());
            if (!it2.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(p1 + "General flags:").append(p2 + "-help      print this message").append(p2 + "-demo      start with demo data").append(p2 + "-disk      use disk backing store for large tables");
        buf.append(p1 + "Optional load dialogues").append(p2 + "-tree      hierarchy browser").append(p2 + "-file      basic file browser").append(p2 + "-sql       SQL query on relational database").append(p2 + "-cone      cone search dialogue").append(p2 + "-registry  VO registry query").append(p2 + "-siap      Simple Image Access Protocol queries");
        buf.append(p1 + "Useful system properties " + "(-Dname=value - lists are colon-separated)").append(p2).append("java.io.tmpdir          temporary filespace directory").append(p2).append("jdbc.drivers            JDBC driver classes").append(p2).append("jel.classes             custom algebraic function classes").append(p2).append("jel.classes.activation  custom action function classes").append(p2).append("star.connectors         custom remote filestore classes").append(p2).append("startable.load.dialogs  custom load dialogue classes").append(p2).append("startable.readers       custom table input handlers").append(p2).append("startable.writers       custom table output handlers").append(p2).append("startable.storage       default storage policy");
        buf.append(p1 + "Useful Java flags").append(p2).append("-classpath jar1:jar2..  specify additional classes").append(p2).append("-XmxnnnM                use nnn megabytes of memory");
        return "\n" + buf.toString() + "\n";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$Driver == null ? (class$uk$ac$starlink$topcat$Driver = Driver.class$("uk.ac.starlink.topcat.Driver")) : class$uk$ac$starlink$topcat$Driver).desiredAssertionStatus();
        standalone = false;
        logger = Logger.getLogger("uk.ac.starlink.topcat");
        tabfact = new StarTableFactory(true);
        DEMOLOC_INFO = new DefaultValueInfo("DemoLoc", class$java$lang$String == null ? (class$java$lang$String = Driver.class$("java.lang.String")) : class$java$lang$String, "Demo file location");
        KNOWN_DIALOGS = new String[]{"uk.ac.starlink.table.gui.FileChooserLoader", "uk.ac.starlink.datanode.tree.TreeTableLoadDialog", (class$uk$ac$starlink$table$gui$SQLReadDialog == null ? (class$uk$ac$starlink$table$gui$SQLReadDialog = Driver.class$("uk.ac.starlink.table.gui.SQLReadDialog")) : class$uk$ac$starlink$table$gui$SQLReadDialog).getName(), "uk.ac.starlink.vo.ConeSearchDialog", "uk.ac.starlink.vo.RegistryTableLoadDialog"};
    }
}

