/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.BasicTableConsumer;
import uk.ac.starlink.table.gui.LoadWorker;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.SwingAuthenticator;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.DemoLoadDialog;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.TopcatUtils;

public abstract class LoadQueryWindow
extends QueryWindow {
    private final TableLoadChooser chooser_;
    private final StarTableFactory tableFactory_;
    private final JProgressBar progBar_;
    private TopcatTableConsumer tableConsumer_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.topcat");
    static /* synthetic */ Class class$uk$ac$starlink$topcat$LoadQueryWindow;

    public LoadQueryWindow(StarTableFactory factory, TableLoadChooser chooser, Component parent) {
        super("Load New Table", parent, false, true);
        this.tableFactory_ = factory;
        this.chooser_ = chooser;
        SwingAuthenticator auth = new SwingAuthenticator();
        auth.setParentComponent((Component)this);
        this.tableFactory_.getJDBCHandler().setAuthenticator((JDBCAuthenticator)auth);
        this.progBar_ = this.placeProgressBar();
        this.getAuxControlPanel().add((Component)this.chooser_);
        JMenu dialogMenu = this.chooser_.makeKnownDialogsMenu("DataSources");
        dialogMenu.setMnemonic(68);
        this.getJMenuBar().add(dialogMenu);
        JMenu demoMenu = new JMenu("Examples");
        demoMenu.setMnemonic(88);
        demoMenu.add(new AbstractAction("Load Example Table"){

            public void actionPerformed(ActionEvent evt) {
                String demoPath = TopcatUtils.DEMO_LOCATION + "/" + TopcatUtils.DEMO_TABLE;
                String loc = this.getClass().getClassLoader().getResource(demoPath).toString();
                new LoadWorker(this, (TableConsumer)LoadQueryWindow.this.tableConsumer_, loc, loc){
                    private final /* synthetic */ String val$loc;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$loc = val$loc;
                        super(x0, x1);
                    }

                    public StarTable attemptLoad() throws IOException {
                        return LoadQueryWindow.access$200(1.access$100(this.this$1)).makeStarTable(this.val$loc, null);
                    }
                }.invoke();
            }

            static /* synthetic */ LoadQueryWindow access$100(1 x0) {
                return x0.LoadQueryWindow.this;
            }
        });
        try {
            DemoLoadDialog treed = new DemoLoadDialog();
            BasicAction treedAct = new BasicAction(treed.getName(), null, treed.getDescription(), (TableLoadDialog)treed){
                private final /* synthetic */ TableLoadDialog val$treed;
                {
                    this.val$treed = val$treed;
                    super(x0, x1, x2);
                }

                public void actionPerformed(ActionEvent evt) {
                    this.val$treed.showLoadDialog((Component)LoadQueryWindow.this, LoadQueryWindow.this.tableFactory_, null, (TableConsumer)LoadQueryWindow.this.tableConsumer_);
                }
            };
            demoMenu.add(treedAct);
        }
        catch (Throwable e) {
            logger_.info("Error instantiating demo load dialog" + e);
        }
        this.getJMenuBar().add(demoMenu);
        this.addHelp("LoadQueryWindow");
        this.pack();
    }

    protected abstract void performLoading(StarTable var1, String var2);

    public void makeVisible() {
        if (this.tableConsumer_ == null) {
            this.tableConsumer_ = new TopcatTableConsumer();
            this.chooser_.setTableConsumer((TableConsumer)this.tableConsumer_);
            this.chooser_.setEnabled(true);
        }
        super.makeVisible();
    }

    public void dispose() {
        this.tableConsumer_.cancel();
        this.tableConsumer_ = null;
        this.chooser_.setTableConsumer(null);
        super.dispose();
    }

    protected boolean perform() {
        this.chooser_.getSubmitAction().actionPerformed(new ActionEvent(this, 0, "OK"));
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TopcatTableConsumer
    extends BasicTableConsumer {
        private String id_;
        static final /* synthetic */ boolean $assertionsDisabled;

        TopcatTableConsumer() {
            super((Component)LoadQueryWindow.this);
        }

        public void loadStarted(String id) {
            this.id_ = id;
            super.loadStarted(id);
        }

        protected void setLoading(boolean loading) {
            super.setLoading(loading);
            if (LoadQueryWindow.this.tableConsumer_ == this) {
                LoadQueryWindow.this.chooser_.setEnabled(!loading);
                LoadQueryWindow.this.progBar_.setIndeterminate(loading);
            }
        }

        protected void tableLoaded(StarTable table) {
            if (!$assertionsDisabled && table == null) {
                throw new AssertionError();
            }
            if (LoadQueryWindow.this.tableConsumer_ == this) {
                if (table.getRowCount() > 0L) {
                    LoadQueryWindow.this.dispose();
                    LoadQueryWindow.this.performLoading(table, this.id_);
                } else {
                    JOptionPane.showMessageDialog(LoadQueryWindow.this, "Table contained no rows", "Empty Table", 0);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$LoadQueryWindow == null ? (class$uk$ac$starlink$topcat$LoadQueryWindow = LoadQueryWindow.class$("uk.ac.starlink.topcat.LoadQueryWindow")) : class$uk$ac$starlink$topcat$LoadQueryWindow).desiredAssertionStatus();
        }
    }
}

