/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.util.BitSet;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.topcat.CheckBoxMenu;

public class MetaColumnModel
extends DefaultTableColumnModel {
    private DefaultListModel listModel;
    private ListSelectionModel visibleModel;
    private TableModel tableModel;
    private BitSet purgedColumns = new BitSet();

    public MetaColumnModel(TableColumnModel baseColumnModel, TableModel tableModel) {
        this.tableModel = tableModel;
        int ipos = 0;
        while (ipos < baseColumnModel.getColumnCount()) {
            super.addColumn(baseColumnModel.getColumn(ipos));
            ++ipos;
        }
        this.setColumnMargin(baseColumnModel.getColumnMargin());
        this.setSelectionModel(baseColumnModel.getSelectionModel());
        this.setColumnSelectionAllowed(baseColumnModel.getColumnSelectionAllowed());
        this.listModel = new DefaultListModel();
        int ipos2 = 0;
        while (ipos2 < baseColumnModel.getColumnCount()) {
            this.listModel.addElement(baseColumnModel.getColumn(ipos2));
            ++ipos2;
        }
        this.visibleModel = new DefaultListSelectionModel();
        int i = 0;
        while (i < this.listModel.getSize()) {
            if (this.isVisible(i)) {
                this.visibleModel.addSelectionInterval(i, i);
            }
            ++i;
        }
        this.visibleModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MetaColumnModel.this.handleSelectionChange(evt);
            }
        });
        tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                MetaColumnModel.this.handleTableChange(evt);
            }
        });
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public ListSelectionModel getVisibleModel() {
        return this.visibleModel;
    }

    private boolean isVisible(int i) {
        return this.tableColumns.contains(this.listModel.get(i));
    }

    public void addColumn(TableColumn tcol) {
        super.addColumn(tcol);
        if (!this.listModel.contains(tcol)) {
            int insertPos = this.listModel.getSize();
            this.listModel.addElement(tcol);
            this.visibleModel.addSelectionInterval(insertPos, insertPos);
            this.purgedColumns.clear(insertPos);
        }
    }

    public void removeColumn(TableColumn tcol) {
        super.removeColumn(tcol);
        int ipos = this.listModel.indexOf(tcol);
        if (ipos >= 0) {
            this.visibleModel.removeSelectionInterval(ipos, ipos);
            this.purgedColumns.clear(ipos);
        }
    }

    public void removeColumn(int ipos) {
        this.removeColumn((TableColumn)this.listModel.get(ipos));
    }

    public void purgeEmptyColumns() {
        int nrow = this.tableModel.getRowCount();
        int ipos = 0;
        while (ipos < this.listModel.getSize()) {
            TableColumn tcol = (TableColumn)this.listModel.get(ipos);
            int modelIndex = tcol.getModelIndex();
            boolean stillBlank = true;
            int irow = 0;
            while (irow < nrow && stillBlank) {
                Object val = this.tableModel.getValueAt(irow, modelIndex);
                stillBlank = stillBlank && (val == null || val.toString().trim().length() == 0);
                ++irow;
            }
            if (stillBlank) {
                this.removeColumn(tcol);
                this.purgedColumns.set(ipos);
            }
            ++ipos;
        }
    }

    public JMenu makeCheckBoxMenu(String name) {
        CheckBoxMenu menu = new CheckBoxMenu(name);
        int i = 0;
        while (i < this.listModel.getSize()) {
            TableColumn tcol = (TableColumn)this.listModel.getElementAt(i);
            Object title = tcol.getHeaderValue();
            menu.addMenuItem(title == null ? null : title.toString());
            ++i;
        }
        menu.setSelectionModel(this.visibleModel);
        return menu;
    }

    private void handleSelectionChange(ListSelectionEvent evt) {
        int i = evt.getFirstIndex();
        while (i <= evt.getLastIndex()) {
            TableColumn tcol;
            if (!this.visibleModel.isSelectedIndex(i) && this.isVisible(i)) {
                tcol = (TableColumn)this.listModel.get(i);
                this.removeColumn(tcol);
            } else if (this.visibleModel.isSelectedIndex(i) && !this.isVisible(i)) {
                tcol = (TableColumn)this.listModel.get(i);
                this.addColumn(tcol);
                int colPos = this.listModel.indexOf(tcol);
                int ipos = 0;
                while (ipos < this.getColumnCount() && this.listModel.indexOf(this.getColumn(ipos)) < colPos) {
                    ++ipos;
                }
                int from = this.getColumnCount() - 1;
                if (ipos < from && ipos >= 0) {
                    this.moveColumn(from, ipos);
                }
            }
            ++i;
        }
    }

    private void handleTableChange(TableModelEvent evt) {
        if (evt.getType() == -1) {
            return;
        }
        TableModel tableModel = (TableModel)evt.getSource();
        int first = Math.max(evt.getFirstRow(), 0);
        int last = Math.min(evt.getLastRow(), tableModel.getRowCount() - 1);
        int ipos = 0;
        while (ipos < this.listModel.size()) {
            if (this.purgedColumns.get(ipos)) {
                int irow = first;
                while (irow <= last) {
                    TableColumn tcol = (TableColumn)this.listModel.get(ipos);
                    int modelIndex = tcol.getModelIndex();
                    Object val = tableModel.getValueAt(irow, modelIndex);
                    if (!this.isVisible(ipos) && val != null && val.toString().trim().length() > 0) {
                        this.visibleModel.addSelectionInterval(ipos, ipos);
                    }
                    ++irow;
                }
            }
            ++ipos;
        }
    }
}

