/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.doc.DocNames;
import uk.ac.starlink.topcat.doc.Heading;

public class MethodWindow
extends AuxWindow
implements TreeSelectionListener {
    private static MethodWindow window;
    private final JTree tree = new JTree(new DefaultMutableTreeNode());
    private final JEditorPane docPane;
    private final DefaultMutableTreeNode activNode;
    private static Logger logger;
    private static Map objLabels;
    private static Pattern TITLE_PATTERN;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$MethodWindow;

    public MethodWindow(Component parent) {
        super("Available Functions", parent);
        final DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        Iterator it = TopcatJELUtils.getStaticClasses().iterator();
        while (it.hasNext()) {
            this.addStaticClass((Class)it.next(), root);
        }
        this.activNode = new DefaultMutableTreeNode(Heading.ACTIVATION, true);
        root.add(this.activNode);
        Iterator it2 = TopcatJELUtils.getActivationStaticClasses().iterator();
        while (it2.hasNext()) {
            this.addStaticClass((Class)it2.next(), this.activNode);
        }
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
            Font basicFont;
            Font strongFont;

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int irow, boolean hasFocus) {
                Component comp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, irow, hasFocus);
                if (comp instanceof JLabel && value instanceof DefaultMutableTreeNode) {
                    Icon icon;
                    JLabel label = (JLabel)comp;
                    Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
                    String text = MethodWindow.this.textFor(userObj);
                    if (text != null) {
                        if (this.basicFont == null) {
                            this.basicFont = label.getFont();
                            this.strongFont = this.basicFont.deriveFont(1);
                        }
                        label.setFont(userObj instanceof Heading ? this.strongFont : this.basicFont);
                        label.setText(text);
                    }
                    if ((icon = MethodWindow.this.iconFor(userObj)) != null) {
                        label.setIcon(icon);
                    }
                }
                return comp;
            }
        });
        final MethodWindow subpar = this;
        final String[] message = new String[]{"Enter the fully-qualified path of a", "class on the class path containing", "public static methods to import into", "the expressions namespace"};
        BasicAction addAction = new BasicAction("Add Class", ResourceIcon.ADD, "Add a class containing more methods"){

            public void actionPerformed(ActionEvent evt) {
                String cname = null;
                while (true) {
                    Object c;
                    String string = cname = (c = JOptionPane.showInputDialog(subpar, message, "Add New Class", 3, null, null, cname)) == null ? null : c.toString();
                    if (cname == null) {
                        return;
                    }
                    Class clazz = TopcatJELUtils.classForName(cname);
                    if (clazz != null) {
                        TopcatJELUtils.getStaticClasses().add(clazz);
                        MethodWindow.this.addStaticClass(clazz, root);
                        return;
                    }
                    JOptionPane.showMessageDialog(subpar, "The class " + cname + " is not on the class path", "Class not found", 0);
                }
            }
        };
        addAction.setEnabled(TopcatUtils.canJel());
        TreePath rootPath = new TreePath(root);
        this.tree.expandPath(rootPath);
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeScroller = new JScrollPane(this.tree);
        treeScroller.setPreferredSize(new Dimension(350, 450));
        this.docPane = new JEditorPane();
        this.docPane.setEditable(false);
        JScrollPane docScroller = new JScrollPane(this.docPane);
        docScroller.setPreferredSize(new Dimension(500, 450));
        JSplitPane splitter = new JSplitPane(1, false, treeScroller, docScroller);
        this.getMainArea().add(splitter);
        this.getToolBar().add(addAction);
        this.getToolBar().addSeparator();
        this.addHelp("MethodWindow");
        this.pack();
        this.setVisible(true);
    }

    public void addStaticClass(Class clazz, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode clazzNode = new DefaultMutableTreeNode(clazz);
        this.getTreeModel().insertNodeInto(clazzNode, parent, parent.getChildCount());
        parent.add(clazzNode);
        this.addPublicStaticMembers(clazzNode, clazz.getDeclaredFields());
        this.addPublicStaticMembers(clazzNode, clazz.getDeclaredMethods());
    }

    private void addPublicStaticMembers(DefaultMutableTreeNode parent, Member[] members) {
        ArrayList<Member> mems = new ArrayList<Member>(Arrays.asList(members));
        Iterator it = mems.iterator();
        while (it.hasNext()) {
            Member mem = (Member)it.next();
            int mods = mem.getModifiers();
            if (Modifier.isStatic(mods) && Modifier.isPublic(mods)) continue;
            it.remove();
        }
        Collections.sort(mems, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Member)o1).getName().compareTo(((Member)o2).getName());
            }
        });
        DefaultTreeModel model = this.getTreeModel();
        Iterator it2 = mems.iterator();
        while (it2.hasNext()) {
            model.insertNodeInto(new DefaultMutableTreeNode(it2.next()), parent, parent.getChildCount());
        }
    }

    private void showActivation(boolean show) {
        TreePath activPath = new TreePath(new Object[]{this.tree.getModel().getRoot(), this.activNode});
        if (show) {
            this.tree.expandPath(activPath);
        } else {
            this.tree.collapsePath(activPath);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        Object leaf;
        TreePath path = evt.getNewLeadSelectionPath();
        URL docUrl = null;
        if (path != null && (leaf = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            Object item = ((DefaultMutableTreeNode)leaf).getUserObject();
            docUrl = DocNames.docURL(item);
            if (docUrl != null) {
                try {
                    this.docPane.setPage(docUrl);
                }
                catch (IOException e) {
                    logger.info("Trouble loading documentation at " + docUrl);
                }
            } else {
                logger.info("No documentation for " + leaf);
            }
        }
    }

    public static Action getWindowAction(final Component parent, final boolean activation) {
        return new BasicAction("Available Functions", ResourceIcon.FUNCTION, "Display information about available algebraic functions"){

            public void actionPerformed(ActionEvent evt) {
                if (window == null) {
                    window = new MethodWindow(parent);
                } else {
                    window.showActivation(activation);
                    window.makeVisible();
                }
            }
        };
    }

    public String textFor(Object userObj) {
        if (userObj == null) {
            return null;
        }
        if (!objLabels.containsKey(userObj)) {
            String text = null;
            if (userObj instanceof Heading) {
                text = ((Heading)userObj).getUserString();
            }
            if (text == null) {
                text = this.readTitleFromResource(DocNames.docURL(userObj));
            }
            if (text == null) {
                if (userObj instanceof Class) {
                    text = ((Class)userObj).getName();
                } else {
                    if (userObj instanceof Method) {
                        Method method = (Method)userObj;
                        StringBuffer sbuf = new StringBuffer().append(method.getReturnType().getName()).append(' ').append(method.getName()).append("( ");
                        Class<?>[] params = method.getParameterTypes();
                        int i = 0;
                        while (i < params.length) {
                            if (i > 0) {
                                sbuf.append(", ");
                            }
                            sbuf.append(params[i].getName());
                            ++i;
                        }
                        sbuf.append(" )");
                        return sbuf.toString();
                    }
                    if (userObj != null) {
                        text = userObj.toString();
                    }
                }
            }
            objLabels.put(userObj, text);
        }
        return (String)objLabels.get(userObj);
    }

    public Icon iconFor(Object userObj) {
        if (userObj instanceof Method) {
            return ResourceIcon.FUNCTION_NODE;
        }
        if (userObj instanceof Field) {
            return ResourceIcon.CONSTANT_NODE;
        }
        if (userObj instanceof Class) {
            return ResourceIcon.LIBRARY_NODE;
        }
        if (userObj instanceof Heading) {
            return ResourceIcon.FOLDER_NODE;
        }
        if (userObj == null) {
            return null;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readTitleFromResource(URL url) {
        block12: {
            if (url == null) {
                return null;
            }
            in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader(url.openStream()));
                    do {
                        if ((line = in.readLine()) != null) continue;
                        var4_5 = null;
                        break block12;
                    } while (!(matcher = MethodWindow.TITLE_PATTERN.matcher((CharSequence)var3_3)).matches());
                    var5_7 = matcher.group(1);
                    var7_8 = null;
                    if (in == null) return var5_7;
                }
                catch (IOException e) {
                    var4_6 = null;
                    var7_10 = null;
                    if (in == null) return var4_6;
                    try {
                        in.close();
                        return var4_6;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return var4_6;
                }
            }
            catch (Throwable var6_16) {
                var7_11 = null;
                if (in == null) throw var6_16;
                try {}
                catch (IOException e) {
                    throw var6_16;
                }
                in.close();
                throw var6_16;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 103->110)] { 
lbl40:
            // 1 sources

            in.close();
            return var5_7;
lbl42:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (in == null) return var4_5;
        try {}
        catch (IOException e) {
            // empty catch block
            return var4_5;
        }
        in.close();
        return var4_5;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$MethodWindow == null ? (class$uk$ac$starlink$topcat$MethodWindow = MethodWindow.class$("uk.ac.starlink.topcat.MethodWindow")) : class$uk$ac$starlink$topcat$MethodWindow).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.topcat");
        objLabels = new HashMap();
        TITLE_PATTERN = Pattern.compile(".*<title>([^<&].*?)</title>.*", 2);
    }
}

