/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.gui.UCDSelector;
import uk.ac.starlink.topcat.ClassComboBoxRenderer;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.TopcatModel;

public class ParameterQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel_;
    private final JTextField nameField_;
    private final JComboBox typeBox_;
    private final JTextField valueField_;
    private final JTextField unitsField_;
    private final JTextField descField_;
    private final UCDSelector ucdSelector_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ParameterQueryWindow(TopcatModel tcModel, Component parent) {
        super("Add New Parameter", parent);
        this.tcModel_ = tcModel;
        LabelledComponentStack stack = this.getStack();
        this.nameField_ = new JTextField();
        stack.addLine("Parameter Name", (Component)this.nameField_);
        this.typeBox_ = new JComboBox();
        this.typeBox_.addItem(class$java$lang$String == null ? (class$java$lang$String = ParameterQueryWindow.class$("java.lang.String")) : class$java$lang$String);
        this.typeBox_.addItem(class$java$lang$Byte == null ? (class$java$lang$Byte = ParameterQueryWindow.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.typeBox_.addItem(class$java$lang$Short == null ? (class$java$lang$Short = ParameterQueryWindow.class$("java.lang.Short")) : class$java$lang$Short);
        this.typeBox_.addItem(class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterQueryWindow.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.typeBox_.addItem(class$java$lang$Long == null ? (class$java$lang$Long = ParameterQueryWindow.class$("java.lang.Long")) : class$java$lang$Long);
        this.typeBox_.addItem(class$java$lang$Float == null ? (class$java$lang$Float = ParameterQueryWindow.class$("java.lang.Float")) : class$java$lang$Float);
        this.typeBox_.addItem(class$java$lang$Double == null ? (class$java$lang$Double = ParameterQueryWindow.class$("java.lang.Double")) : class$java$lang$Double);
        this.typeBox_.addItem(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParameterQueryWindow.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.typeBox_.setRenderer(ClassComboBoxRenderer.getInstance());
        this.typeBox_.setSelectedItem(class$java$lang$String == null ? (class$java$lang$String = ParameterQueryWindow.class$("java.lang.String")) : class$java$lang$String);
        stack.addLine("Type", (Component)this.typeBox_);
        this.valueField_ = new JTextField();
        stack.addLine("Value", (Component)this.valueField_);
        this.unitsField_ = new JTextField();
        stack.addLine("Units", (Component)this.unitsField_);
        this.descField_ = new JTextField();
        stack.addLine("Description", (Component)this.descField_);
        this.ucdSelector_ = new UCDSelector();
        stack.addLine("UCD", (Component)this.ucdSelector_);
        this.addHelp("ParameterQueryWindow");
        this.pack();
        this.setVisible(true);
    }

    protected boolean perform() {
        Object value;
        String name = ParameterQueryWindow.normalize(this.nameField_.getText());
        Class clazz = (Class)this.typeBox_.getSelectedItem();
        String valueString = ParameterQueryWindow.normalize(this.valueField_.getText());
        String units = ParameterQueryWindow.normalize(this.unitsField_.getText());
        String desc = ParameterQueryWindow.normalize(this.descField_.getText());
        String ucd = this.ucdSelector_.getID();
        if (name == null) {
            return false;
        }
        DefaultValueInfo vinfo = new DefaultValueInfo(name, clazz, desc);
        vinfo.setUnitString(units);
        vinfo.setUCD(ucd);
        if (valueString == null) {
            value = null;
        } else {
            try {
                value = vinfo.unformatString(valueString);
            }
            catch (RuntimeException e) {
                String[] msg = new String[]{"Invalid value \"" + valueString + "\"", "for type " + clazz.getName(), "(" + e.toString() + ")"};
                JOptionPane.showMessageDialog(this, msg, "Invalid Parameter Value", 0);
                return false;
            }
        }
        DescribedValue dval = new DescribedValue((ValueInfo)vinfo, value);
        this.tcModel_.addParameter(dval);
        return true;
    }

    private static String normalize(String base) {
        return base == null || base.trim().length() == 0 ? null : base;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

