/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.ParameterQueryWindow;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.TableColumnModelAdapter;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatViewWindow;

public class ParameterWindow
extends TopcatViewWindow
implements TopcatListener,
ListSelectionListener {
    private TopcatModel tcModel;
    private PlasticStarTable dataModel;
    private TableModel viewModel;
    private TableColumnModel columnModel;
    private ParamList params;
    private Collection uneditableParams;
    private DescribedValue ncolParam;
    private DescribedValue nrowParam;
    private MetaColumnTableModel metaTableModel;
    private final ListSelectionModel rowSelectionModel;
    private final Action removeAct;
    private int ncolRowIndex;
    private int nrowRowIndex;
    private static final ValueInfo NAME_INFO = new DefaultValueInfo("Name", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String, "Table name");
    private static final ValueInfo URL_INFO = new DefaultValueInfo("URL", class$java$net$URL == null ? (class$java$net$URL = ParameterWindow.class$("java.net.URL")) : class$java$net$URL, "URL of original table");
    private static final ValueInfo NCOL_INFO = new DefaultValueInfo("Column Count", class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterWindow.class$("java.lang.Integer")) : class$java$lang$Integer, "Number of columns");
    private static final ValueInfo NROW_INFO = new DefaultValueInfo("Row Count", class$java$lang$Long == null ? (class$java$lang$Long = ParameterWindow.class$("java.lang.Long")) : class$java$lang$Long, "Number of rows");
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.topcat");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Object;

    public ParameterWindow(TopcatModel tcModel, Component parent) {
        super(tcModel, "Table Parameters", parent);
        this.tcModel = tcModel;
        this.dataModel = tcModel.getDataModel();
        this.viewModel = tcModel.getViewModel();
        this.columnModel = tcModel.getColumnModel();
        tcModel.addTopcatListener(this);
        this.params = new ParamList(this.dataModel.getParameters());
        this.uneditableParams = new HashSet();
        DescribedValue nameParam = new DescribedValue(NAME_INFO){

            public Object getValue() {
                return ParameterWindow.this.dataModel.getName();
            }

            public void setValue(Object value) {
                String name;
                String string = name = value == null ? null : value.toString();
                if (name.trim().length() == 0) {
                    name = null;
                }
                ParameterWindow.this.dataModel.setName(name);
            }
        };
        this.params.addPseudoParameter(nameParam);
        URL url = this.dataModel.getBaseTable().getURL();
        if (url != null) {
            DescribedValue urlParam = new DescribedValue(URL_INFO, (Object)url);
            this.params.addPseudoParameter(urlParam);
            this.uneditableParams.add(urlParam);
        }
        this.ncolParam = new DescribedValue(NCOL_INFO);
        this.nrowParam = new DescribedValue(NROW_INFO);
        this.params.addPseudoParameter(this.ncolParam);
        this.params.addPseudoParameter(this.nrowParam);
        this.uneditableParams.add(this.ncolParam);
        this.uneditableParams.add(this.nrowParam);
        this.columnModel.addColumnModelListener(new TableColumnModelAdapter(){

            public void columnAdded(TableColumnModelEvent evt) {
                ParameterWindow.this.configureColumnCount();
            }

            public void columnRemoved(TableColumnModelEvent evt) {
                ParameterWindow.this.configureColumnCount();
            }
        });
        this.viewModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                ParameterWindow.this.configureRowCount();
            }
        });
        this.ncolRowIndex = this.params.indexOf(this.ncolParam);
        this.nrowRowIndex = this.params.indexOf(this.nrowParam);
        ArrayList<MetaColumn> metas = new ArrayList<MetaColumn>();
        metas.add(new MetaColumn("Name", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getName();
            }
        });
        metas.add(new MetaColumn("Value", class$java$lang$Object == null ? (class$java$lang$Object = ParameterWindow.class$("java.lang.Object")) : class$java$lang$Object){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParam(irow).getValueAsString(64);
            }

            public boolean isEditable(int irow) {
                return ParameterWindow.this.isEditableParameter(irow);
            }

            public void setValue(int irow, Object value) {
                ParameterWindow.this.getParam(irow).setValue(value);
            }
        });
        int classPos = metas.size();
        metas.add(new MetaColumn("Class", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return DefaultValueInfo.formatClass((Class)ParameterWindow.this.getParamInfo(irow).getContentClass());
            }
        });
        metas.add(new MetaColumn("Shape", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return DefaultValueInfo.formatShape((int[])ParameterWindow.this.getParamInfo(irow).getShape());
            }
        });
        int sizePos = metas.size();
        metas.add(new MetaColumn("Element Size", class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterWindow.class$("java.lang.Integer")) : class$java$lang$Integer){

            public Object getValue(int irow) {
                int size = ParameterWindow.this.getParamInfo(irow).getElementSize();
                return size > 0 ? new Integer(size) : null;
            }

            public boolean isEditable(int irow) {
                return ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                int size;
                if (value instanceof Number) {
                    size = ((Number)value).intValue();
                } else if (value instanceof String) {
                    try {
                        size = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        size = -1;
                    }
                } else {
                    size = -1;
                }
                if (size <= 0) {
                    size = -1;
                }
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setElementSize(size);
            }
        });
        metas.add(new MetaColumn("Units", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getUnitString();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setUnitString(value == null ? null : value.toString());
            }
        });
        metas.add(new MetaColumn("Description", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getDescription();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setDescription(value == null ? null : value.toString());
            }
        });
        metas.add(new MetaColumn("UCD", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getUCD();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setUCD(value == null ? null : value.toString());
            }
        });
        metas.add(new MetaColumn("UCD description", class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String){

            public Object getValue(int irow) {
                UCD ucd;
                String ucdid = ParameterWindow.this.getParamInfo(irow).getUCD();
                if (ucdid != null && (ucd = UCD.getUCD((String)ucdid)) != null) {
                    return ucd.getDescription();
                }
                return null;
            }
        });
        this.metaTableModel = new MetaColumnTableModel(metas){

            public int getRowCount() {
                return ParameterWindow.this.params.size();
            }
        };
        final JTable jtab = new JTable(this.metaTableModel);
        jtab.setAutoResizeMode(0);
        jtab.setColumnSelectionAllowed(false);
        jtab.setRowSelectionAllowed(true);
        this.rowSelectionModel = jtab.getSelectionModel();
        this.rowSelectionModel.setSelectionMode(0);
        this.rowSelectionModel.addListSelectionListener(this);
        StarJTable.configureColumnWidths((JTable)jtab, (int)20000, (int)100);
        MetaColumnModel metaColumnModel = new MetaColumnModel(jtab.getColumnModel(), this.metaTableModel);
        metaColumnModel.purgeEmptyColumns();
        jtab.setColumnModel(metaColumnModel);
        metaColumnModel.removeColumn(classPos);
        metaColumnModel.removeColumn(sizePos);
        this.configureColumnCount();
        this.configureRowCount();
        this.getMainArea().add(new SizingScrollPane(jtab));
        BasicAction addAct = new BasicAction("New Parameter", ResourceIcon.ADD, "Add a new parameter"){

            public void actionPerformed(ActionEvent evt) {
                ParameterWindow paramWindow = ParameterWindow.this;
                new ParameterQueryWindow(paramWindow.tcModel, (Component)paramWindow);
            }
        };
        this.getToolBar().add(addAct);
        this.removeAct = new BasicAction("Remove Parameter", ResourceIcon.DELETE, "Delete the selected parameter"){

            public void actionPerformed(ActionEvent evt) {
                if (jtab.getSelectedRowCount() == 1) {
                    int irow = jtab.getSelectedRow();
                    DescribedValue dval = ParameterWindow.this.getParam(irow);
                    if (ParameterWindow.this.tcModel.getDataModel().getParameters().contains(dval)) {
                        if (ParameterWindow.this.confirm("Remove Parameter \"" + dval + "\"?", "Confirm Removal")) {
                            ParameterWindow.this.tcModel.removeParameter(dval);
                        }
                    } else {
                        logger.warning("Parameter \"" + dval + "\" missing from model??");
                    }
                }
            }
        };
        this.removeAct.setEnabled(false);
        this.getToolBar().add(this.removeAct);
        this.getToolBar().addSeparator();
        JMenu paramMenu = new JMenu("Parameters");
        paramMenu.setMnemonic(80);
        paramMenu.add(addAct);
        paramMenu.add(this.removeAct);
        this.getJMenuBar().add(paramMenu);
        JMenu displayMenu = metaColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        this.addHelp("ParameterWindow");
        this.pack();
        this.setVisible(true);
    }

    private DescribedValue getParam(int irow) {
        return (DescribedValue)this.params.get(irow);
    }

    private ValueInfo getParamInfo(int irow) {
        return this.getParam(irow).getInfo();
    }

    private boolean isPseudoParameter(int irow) {
        return this.params.isPseudoParam(irow);
    }

    private boolean isEditableParameter(int irow) {
        return !this.uneditableParams.contains(this.getParam(irow));
    }

    private void configureColumnCount() {
        this.ncolParam.setValue((Object)new Integer(this.columnModel.getColumnCount()));
        this.metaTableModel.fireTableRowsUpdated(this.ncolRowIndex, this.ncolRowIndex);
    }

    private void configureRowCount() {
        this.nrowParam.setValue((Object)new Long(this.viewModel.getRowCount()));
        this.metaTableModel.fireTableRowsUpdated(this.nrowRowIndex, this.nrowRowIndex);
    }

    public void modelChanged(TopcatModel tcModel, int code) {
        if (code == 3) {
            this.metaTableModel.fireTableDataChanged();
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.rowSelectionModel) {
            int index = this.rowSelectionModel.getMinSelectionIndex();
            boolean active = index >= 0 && index == this.rowSelectionModel.getMaxSelectionIndex() && !this.params.isPseudoParam(index);
            this.removeAct.setEnabled(active);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParamList
    extends AbstractList {
        private final List pseudoParams;
        private final List normalParams;

        ParamList(List normalParams) {
            this.normalParams = normalParams;
            this.pseudoParams = new ArrayList();
        }

        public void addPseudoParameter(DescribedValue dval) {
            this.pseudoParams.add(dval);
        }

        public int size() {
            return this.pseudoParams.size() + this.normalParams.size();
        }

        public Object get(int index) {
            return this.isPseudoParam(index) ? this.pseudoParams.get(index) : this.normalParams.get(index - this.pseudoParams.size());
        }

        public boolean isPseudoParam(int index) {
            return index < this.pseudoParams.size();
        }
    }
}

