/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.metal.MetalCheckBoxIcon;

public class ResourceIcon
implements Icon {
    public static final String PREFIX = "images/";
    public static final ImageIcon DO_WHAT = ResourceIcon.makeIcon("burst.gif");
    public static final ImageIcon TOPCAT = ResourceIcon.makeIcon("TopCat2.gif");
    public static final ImageIcon TOPCAT_LOGO = ResourceIcon.makeIcon("tc3.gif");
    public static final ImageIcon STARLINK = ResourceIcon.makeIcon("starlinklogo3.gif");
    public static final ImageIcon STAR_LOGO = ResourceIcon.makeIcon("starlinklogo1b.gif");
    public static final ImageIcon TABLE = ResourceIcon.makeIcon("browser1.gif");
    public static final ImageIcon CLOSE = ResourceIcon.makeIcon("multiply4.gif");
    public static final ImageIcon EXIT = ResourceIcon.makeIcon("exit.gif");
    public static final ImageIcon LOAD = ResourceIcon.makeIcon("Open24.gif");
    public static final ImageIcon SAVE = ResourceIcon.makeIcon("Save24.gif");
    public static final ImageIcon PRINT = ResourceIcon.makeIcon("Print24.gif");
    public static final ImageIcon IMAGE = ResourceIcon.makeIcon("picture.gif");
    public static final ImageIcon COPY = ResourceIcon.makeIcon("Copy24.gif");
    public static final ImageIcon REDO = ResourceIcon.makeIcon("Redo24.gif");
    public static final ImageIcon ADD = ResourceIcon.makeIcon("Plus1.gif");
    public static final ImageIcon DELETE = ResourceIcon.makeIcon("trash2.gif");
    public static final ImageIcon HELP = ResourceIcon.makeIcon("Help3.gif");
    public static final ImageIcon DEMO = ResourceIcon.makeIcon("demo.gif");
    public static final ImageIcon HIDE = ResourceIcon.makeIcon("false.gif");
    public static final ImageIcon REVEAL = ResourceIcon.makeIcon("true.gif");
    public static final ImageIcon MODIFY = ResourceIcon.makeIcon("redo3.gif");
    public static final ImageIcon SEARCH = ResourceIcon.makeIcon("search2.gif");
    public static final ImageIcon HIDE_WINDOWS = ResourceIcon.makeIcon("hide1.gif");
    public static final ImageIcon CONTROL = ResourceIcon.makeIcon("controlw.gif");
    public static final ImageIcon COLUMNS = ResourceIcon.makeIcon("colmeta0.gif");
    public static final ImageIcon STATS = ResourceIcon.makeIcon("sigma0.gif");
    public static final ImageIcon PLOT = ResourceIcon.makeIcon("plot0.gif");
    public static final ImageIcon PARAMS = ResourceIcon.makeIcon("tablemeta0.gif");
    public static final ImageIcon VIEWER = ResourceIcon.makeIcon("browser1.gif");
    public static final ImageIcon SUBSETS = ResourceIcon.makeIcon("venn2.gif");
    public static final ImageIcon FUNCTION = ResourceIcon.makeIcon("fx2.gif");
    public static final ImageIcon MATCH1 = ResourceIcon.makeIcon("matchOne2.gif");
    public static final ImageIcon MATCH2 = ResourceIcon.makeIcon("matchTwo2.gif");
    public static final ImageIcon CONCAT = ResourceIcon.makeIcon("concat4.gif");
    public static final ImageIcon UNSORT = DO_WHAT;
    public static final ImageIcon DELETE_COLUMN = ResourceIcon.makeIcon("ColumnDelete24.gif");
    public static final ImageIcon VISIBLE_SUBSET = ResourceIcon.makeIcon("spoints5.gif");
    public static final ImageIcon BLOB_SUBSET = ResourceIcon.makeIcon("blob2.gif");
    public static final ImageIcon BLOB_SUBSET_END = ResourceIcon.makeIcon("ublob3b.gif");
    public static final ImageIcon RESIZE = ResourceIcon.makeIcon("4way3.gif");
    public static final ImageIcon GRID_ON = ResourceIcon.makeIcon("gridon.gif");
    public static final ImageIcon GRID_OFF = ResourceIcon.makeIcon("gridoff.gif");
    public static final ImageIcon TO_COLUMN = ResourceIcon.makeIcon("Column.gif");
    public static final ImageIcon COUNT = ResourceIcon.makeIcon("ab3.gif");
    public static final ImageIcon INVERT = ResourceIcon.makeIcon("invert3.gif");
    public static final ImageIcon INCLUDE_ROWS = ResourceIcon.makeIcon("selrows3.gif");
    public static final ImageIcon EXCLUDE_ROWS = ResourceIcon.makeIcon("exrows.gif");
    public static final ImageIcon UP = ResourceIcon.makeIcon("arrow_n_pad.gif");
    public static final ImageIcon DOWN = ResourceIcon.makeIcon("arrow_s_pad.gif");
    public static final ImageIcon UP_TRIM = ResourceIcon.makeIcon("arrow_n.gif");
    public static final ImageIcon DOWN_TRIM = ResourceIcon.makeIcon("arrow_s.gif");
    public static final ImageIcon EQUATION = ResourceIcon.makeIcon("xeq.gif");
    public static final ImageIcon PLOT_LINES = ResourceIcon.makeIcon("lines.gif");
    public static final ImageIcon EXPLODE = ResourceIcon.makeIcon("explode.gif");
    public static final ImageIcon FORWARD = ResourceIcon.makeIcon("Forward24.gif");
    public static final ImageIcon BACKWARD = ResourceIcon.makeIcon("Back24.gif");
    public static final ImageIcon PAGE_SETUP = ResourceIcon.makeIcon("PageSetup24.gif");
    public static final ImageIcon COLLAPSED = ResourceIcon.makeIcon("handle1.gif");
    public static final ImageIcon EXPANDED = ResourceIcon.makeIcon("handle2.gif");
    public static final ImageIcon HOME = ResourceIcon.makeIcon("Home24.gif");
    public static final ImageIcon TV_UP = ResourceIcon.makeIcon("Up.gif");
    public static final ImageIcon TV_DOWN = ResourceIcon.makeIcon("Down.gif");
    public static final ImageIcon FOLDER_NODE = ResourceIcon.makeIcon("folder_node.gif");
    public static final ImageIcon LIBRARY_NODE = ResourceIcon.makeIcon("book_leaf.gif");
    public static final ImageIcon FUNCTION_NODE = ResourceIcon.makeIcon("fx_leaf.gif");
    public static final ImageIcon CONSTANT_NODE = ResourceIcon.makeIcon("c_leaf.gif");
    public static final ImageIcon dummy = DO_WHAT;
    public static final Icon BLANK = new Icon(){

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };
    private String location;
    private Icon baseIcon;
    private Boolean resourceFound;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ResourceIcon;
    static /* synthetic */ Class class$javax$swing$Icon;

    private ResourceIcon(String location) {
        this.location = location;
    }

    private Icon getBaseIcon() {
        if (this.baseIcon == null) {
            this.baseIcon = this.readBaseIcon();
        }
        return this.baseIcon;
    }

    public int getIconHeight() {
        return this.getBaseIcon().getIconHeight();
    }

    public int getIconWidth() {
        return this.getBaseIcon().getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getBaseIcon().paintIcon(c, g, x, y);
    }

    public Image getImage() {
        Icon icon = this.getBaseIcon();
        return icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
    }

    public URL getURL() {
        return this.getClass().getResource(PREFIX + this.location);
    }

    /*
     * WARNING - void declaration
     */
    private Icon readBaseIcon() {
        Icon icon = null;
        URL resource = this.getURL();
        if (resource != null) {
            try {
                int datum;
                InputStream istrm = resource.openStream();
                istrm = new BufferedInputStream(istrm);
                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                while ((datum = istrm.read()) > -1) {
                    void var5_6;
                    ostrm.write((int)var5_6);
                }
                istrm.close();
                ostrm.close();
                icon = new ImageIcon(ostrm.toByteArray());
                this.resourceFound = Boolean.TRUE;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (icon == null) {
            icon = ResourceIcon.dummyIcon();
            this.resourceFound = Boolean.FALSE;
        }
        return icon;
    }

    private static Icon dummyIcon() {
        return new MetalCheckBoxIcon();
    }

    public static void checkResourcesPresent() throws FileNotFoundException {
        ArrayList<String> notFound = new ArrayList<String>();
        Iterator it = ResourceIcon.getMemberNameMap().entrySet().iterator();
        while (it.hasNext()) {
            ResourceIcon icon = (ResourceIcon)it.next().getValue();
            icon.readBaseIcon();
            if (icon.resourceFound.booleanValue()) continue;
            notFound.add(icon.location);
        }
        if (notFound.size() > 0) {
            StringBuffer msg = new StringBuffer().append("Resource files not found:");
            Iterator it2 = notFound.iterator();
            while (it2.hasNext()) {
                msg.append(' ').append(it2.next());
            }
            throw new FileNotFoundException(msg.toString());
        }
    }

    public static void writeHelpMapXML(OutputStream ostrm, String prefix) {
        PrintStream pstrm = ostrm instanceof PrintStream ? (PrintStream)ostrm : new PrintStream(ostrm);
        pstrm.println("<?xml version='1.0'?>");
        pstrm.println("<!DOCTYPE map");
        pstrm.println("  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\"");
        pstrm.println("         \"http://java.sun.com/products/javahelp/map_1_0.dtd\">");
        pstrm.println("\n<!-- Automatically generated by " + (class$uk$ac$starlink$topcat$ResourceIcon == null ? (class$uk$ac$starlink$topcat$ResourceIcon = ResourceIcon.class$("uk.ac.starlink.topcat.ResourceIcon")) : class$uk$ac$starlink$topcat$ResourceIcon).getName() + " -->");
        pstrm.println("\n<map version='1.0'>");
        Map iconMap = ResourceIcon.getMemberNameMap();
        ArrayList iconList = new ArrayList(iconMap.keySet());
        Collections.sort(iconList);
        Iterator it = iconList.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ResourceIcon icon = (ResourceIcon)iconMap.get(name);
            String mapID = "  <mapID target='" + name + "'" + " url='" + prefix + PREFIX + icon.location + "'/>";
            pstrm.println(mapID);
        }
        pstrm.println("</map>");
    }

    private static Map getMemberNameMap() {
        HashMap<String, ResourceIcon> nameMap = new HashMap<String, ResourceIcon>();
        Field[] fields = (class$uk$ac$starlink$topcat$ResourceIcon == null ? (class$uk$ac$starlink$topcat$ResourceIcon = ResourceIcon.class$("uk.ac.starlink.topcat.ResourceIcon")) : class$uk$ac$starlink$topcat$ResourceIcon).getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mods = field.getModifiers();
            String name = field.getName();
            if ((class$javax$swing$Icon == null ? ResourceIcon.class$("javax.swing.Icon") : class$javax$swing$Icon).isAssignableFrom(field.getType()) && Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods) && name.equals(name.toUpperCase())) {
                ResourceIcon ricon;
                Icon icon;
                try {
                    icon = (Icon)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                if (icon instanceof ResourceIcon) {
                    ricon = (ResourceIcon)icon;
                } else if (icon instanceof ResourceImageIcon) {
                    ricon = ((ResourceImageIcon)icon).getResourceIcon();
                } else if (icon == BLANK) {
                    ricon = null;
                } else {
                    throw new AssertionError();
                }
                if (ricon != null) {
                    nameMap.put(name, ricon);
                }
            }
            ++i;
        }
        return nameMap;
    }

    private static ImageIcon makeIcon(String location) {
        return new ResourceImageIcon(new ResourceIcon(location));
    }

    public static void main(String[] args) {
        String mode;
        String string = mode = args.length == 1 ? args[0] : null;
        if ("-map".equals(mode)) {
            ResourceIcon.writeHelpMapXML(System.out, "../");
        } else if ("-files".equals(mode)) {
            Map iconMap = ResourceIcon.getMemberNameMap();
            Iterator it = iconMap.keySet().iterator();
            while (it.hasNext()) {
                ResourceIcon icon = (ResourceIcon)iconMap.get(it.next());
                System.out.println(icon.location);
            }
        } else if ("-entities".equals(mode)) {
            Map iconMap = ResourceIcon.getMemberNameMap();
            String t1 = "  <!ENTITY IMG.";
            String t2 = " '<img src=\"../images/";
            String t3 = "\"/>'>";
            Iterator it = iconMap.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                ResourceIcon icon = (ResourceIcon)iconMap.get(name);
                System.out.println(t1 + name + t2 + icon.location + t3);
            }
        } else {
            String usage = "Usage: ResourceIcon [-map|-files|-entities]";
            System.err.println(usage);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ResourceImageIcon
    extends ImageIcon {
        ResourceIcon resourceIcon;

        ResourceImageIcon(ResourceIcon resourceIcon) {
            this.resourceIcon = resourceIcon;
        }

        public ResourceIcon getResourceIcon() {
            return this.resourceIcon;
        }

        protected void loadImage() {
        }

        public int getImageLoadStatus() {
            return 8;
        }

        public Image getImage() {
            return this.resourceIcon.getImage();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.resourceIcon.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.resourceIcon.getIconWidth();
        }

        public int getIconHeight() {
            return this.resourceIcon.getIconHeight();
        }
    }
}

