/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.SyntheticRowSubset;
import uk.ac.starlink.topcat.TopcatModel;

public class SyntheticSubsetQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel;
    private final OptionsListModel subsets;
    private final PlasticStarTable dataModel;
    private JTextField nameField;
    private JTextField exprField;

    public SyntheticSubsetQueryWindow(TopcatModel tcModel, Component parent) {
        super("Define Row Subset", parent);
        this.tcModel = tcModel;
        this.subsets = tcModel.getSubsets();
        this.dataModel = tcModel.getDataModel();
        LabelledComponentStack stack = this.getStack();
        this.nameField = new JTextField();
        stack.addLine("Subset Name", (Component)this.nameField);
        this.exprField = new JTextField();
        stack.addLine("Expression", (Component)this.exprField);
        this.getToolBar().add(MethodWindow.getWindowAction(this, false));
        this.getToolBar().addSeparator();
        this.addHelp("SyntheticSubsetQueryWindow");
        this.pack();
        this.setVisible(true);
    }

    protected boolean perform() {
        String name = this.nameField.getText();
        String expr = this.exprField.getText();
        try {
            SyntheticRowSubset rset = new SyntheticRowSubset((StarTable)this.dataModel, this.subsets, name, expr);
            this.subsets.add(rset);
            return true;
        }
        catch (CompilationException e) {
            String[] msg = new String[]{"Syntax error in algebraic subset expression \"" + expr + "\":", e.getMessage()};
            JOptionPane.showMessageDialog(this, msg, "Expression Syntax Error", 0);
            return false;
        }
    }
}

