/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.BitSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.TableRowHeader;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.SortOrder;
import uk.ac.starlink.topcat.SyntheticColumnQueryWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.TopcatViewWindow;
import uk.ac.starlink.topcat.ViewerTableModel;

public class TableViewerWindow
extends TopcatViewWindow
implements TableModelListener,
TableColumnModelListener {
    private final TopcatModel tcModel;
    private final PlasticStarTable dataModel;
    private final ViewerTableModel viewModel;
    private final TableColumnModel columnModel;
    private final OptionsListModel subsets;
    private final ColumnList columnList;
    private JTable jtab;
    private TableRowHeader rowHead;
    private JScrollPane scrollpane;
    private JProgressBar progBar;
    private Action includeAct;
    private Action excludeAct;
    private boolean selfHighlighting;
    private static int MAX_COLUMN_WIDTH;
    private static int MAX_SAMPLE_ROWS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$TableViewerWindow;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$String;

    public TableViewerWindow(final TopcatModel tcModel, Component parent) {
        super(tcModel, "Table Browser", parent);
        this.tcModel = tcModel;
        this.dataModel = tcModel.getDataModel();
        this.viewModel = tcModel.getViewModel();
        this.columnModel = tcModel.getColumnModel();
        this.subsets = tcModel.getSubsets();
        this.columnList = tcModel.getColumnList();
        this.jtab = new JTable();
        this.jtab.setCellSelectionEnabled(false);
        this.jtab.setColumnSelectionAllowed(false);
        this.jtab.setRowSelectionAllowed(true);
        this.jtab.setModel(this.viewModel);
        this.jtab.setColumnModel(this.columnModel);
        this.scrollpane = new SizingScrollPane(this.jtab);
        this.getMainArea().add((Component)this.scrollpane, "Center");
        this.progBar = this.placeProgressBar();
        this.rowHead = new TableRowHeader(this.jtab){

            public int rowNumber(int irow) {
                return (int)TableViewerWindow.this.viewModel.getBaseRow(irow) + 1;
            }
        };
        this.scrollpane.setRowHeaderView((Component)this.rowHead);
        this.viewModel.addTableModelListener(this);
        this.columnModel.addColumnModelListener(this);
        this.includeAct = new ViewerAction("Subset From Selected Rows", ResourceIcon.INCLUDE_ROWS, "Define a new row subset containing all selected rows");
        this.excludeAct = new ViewerAction("Subset From Unselected Rows", ResourceIcon.EXCLUDE_ROWS, "Define a new row subset containing all visible unselected rows");
        final ListSelectionModel selectionModel = this.jtab.getSelectionModel();
        ListSelectionListener selList = new ListSelectionListener(){
            long lastActive = -1L;

            public void valueChanged(ListSelectionEvent evt) {
                boolean hasSelection = !selectionModel.isSelectionEmpty();
                TableViewerWindow.this.includeAct.setEnabled(hasSelection);
                TableViewerWindow.this.excludeAct.setEnabled(hasSelection);
                if (hasSelection && !evt.getValueIsAdjusting()) {
                    long active;
                    int first = selectionModel.getMinSelectionIndex();
                    if (selectionModel.getMaxSelectionIndex() == first && (active = TableViewerWindow.this.viewModel.getBaseRow(first)) != this.lastActive) {
                        this.lastActive = active;
                        if (!TableViewerWindow.this.selfHighlighting) {
                            TableViewerWindow.this.selfHighlighting = true;
                            tcModel.highlightRow(active);
                            TableViewerWindow.this.selfHighlighting = false;
                        }
                    }
                }
            }
        };
        selectionModel.addListSelectionListener(selList);
        selList.valueChanged(null);
        MouseAdapter mousey = new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                this.maybeShowPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                this.maybeShowPopup(evt);
            }

            private void maybeShowPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    JPopupMenu popper;
                    int jcol = TableViewerWindow.this.jtab.columnAtPoint(evt.getPoint());
                    if (evt.getComponent() == TableViewerWindow.this.rowHead) {
                        jcol = -1;
                    }
                    if (jcol >= -1 && (popper = TableViewerWindow.this.columnPopup(jcol)) != null) {
                        popper.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            }
        };
        this.jtab.addMouseListener(mousey);
        this.jtab.getTableHeader().addMouseListener(mousey);
        this.rowHead.addMouseListener((MouseListener)mousey);
        this.scrollpane.getViewport().setViewPosition(new Point(0, 0));
        StarJTable.configureColumnWidths((JTable)this.jtab, (int)MAX_COLUMN_WIDTH, (int)MAX_SAMPLE_ROWS);
        this.getToolBar().add(this.includeAct);
        this.getToolBar().add(this.excludeAct);
        this.getToolBar().addSeparator();
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        subsetMenu.add(this.includeAct);
        subsetMenu.add(this.excludeAct);
        AbstractAction applysubsetAct = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                int index = evt.getID();
                tcModel.applySubset((RowSubset)TableViewerWindow.this.subsets.get(index));
            }
        };
        JMenu applysubsetMenu = this.subsets.makeJMenu("Apply Subset", applysubsetAct);
        subsetMenu.add(applysubsetMenu);
        this.getJMenuBar().add(subsetMenu);
        this.addHelp("TableViewerWindow");
        this.pack();
        this.setVisible(true);
    }

    public void highlightRow(long lrow) {
        if (this.selfHighlighting) {
            return;
        }
        this.selfHighlighting = true;
        this.jtab.clearSelection();
        if (this.viewModel.getSubset().isIncluded(lrow)) {
            int viewRow = this.viewModel.getViewRow(lrow);
            if (!$assertionsDisabled && viewRow < 0) {
                throw new AssertionError();
            }
            this.jtab.addRowSelectionInterval(viewRow, viewRow);
            this.scrollToRow(viewRow);
        }
        this.selfHighlighting = false;
    }

    private JPopupMenu columnPopup(final int jcol) {
        JPopupMenu popper = new JPopupMenu();
        final StarTableColumn tcol = (StarTableColumn)this.columnModel.getColumn(jcol);
        ColumnInfo colInfo = tcol.getColumnInfo();
        String colName = colInfo.getName();
        final TableViewerWindow parent = this;
        BasicAction replacecolAct = new BasicAction("Replace Column", ResourceIcon.MODIFY, "Replace " + colName + " with new synthetic column"){

            public void actionPerformed(ActionEvent evt) {
                SyntheticColumnQueryWindow.replaceColumnDialog(TableViewerWindow.this.tcModel, tcol, parent);
            }
        };
        replacecolAct.setEnabled(TopcatUtils.canJel());
        popper.add(replacecolAct);
        BasicAction addcolAct = new BasicAction("New Synthetic Column", ResourceIcon.ADD, "Add new synthetic column after " + colName){

            public void actionPerformed(ActionEvent evt) {
                new SyntheticColumnQueryWindow(TableViewerWindow.this.tcModel, jcol + 1, parent);
            }
        };
        addcolAct.setEnabled(TopcatUtils.canJel());
        popper.add(addcolAct);
        if (jcol >= 0 && (class$java$lang$Comparable == null ? (class$java$lang$Comparable = TableViewerWindow.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(colInfo.getContentClass())) {
            popper.add(this.tcModel.getSortAction(new SortOrder((TableColumn)tcol), true));
            popper.add(this.tcModel.getSortAction(new SortOrder((TableColumn)tcol), false));
        }
        if (jcol >= 0) {
            BasicAction hidecolAct = new BasicAction("Hide Column", ResourceIcon.HIDE, "Hide column " + colName + " from view"){

                public void actionPerformed(ActionEvent evt) {
                    TableViewerWindow.this.columnModel.removeColumn((TableColumn)tcol);
                }
            };
            popper.add(hidecolAct);
        }
        if (colInfo.getContentClass() == (class$java$lang$String == null ? (class$java$lang$String = TableViewerWindow.class$("java.lang.String")) : class$java$lang$String)) {
            BasicAction searchAct = new BasicAction("Search Column", ResourceIcon.SEARCH, "Search for regular expression in cell"){

                public void actionPerformed(ActionEvent evt) {
                    TableViewerWindow.this.findRegex(tcol, jcol);
                }
            };
            popper.add(searchAct);
        }
        return popper;
    }

    private BitSet getSelectedRowFlags() {
        int nrow = (int)this.dataModel.getRowCount();
        BitSet bits = new BitSet(nrow);
        int[] selected = this.jtab.getSelectedRows();
        int nsel = selected.length;
        int[] rowMap = this.viewModel.getRowMap();
        if (rowMap == null) {
            int i = 0;
            while (i < nsel) {
                bits.set(selected[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < nsel) {
                bits.set(rowMap[selected[i]]);
                ++i;
            }
        }
        return bits;
    }

    private BitSet getUnselectedRowFlags() {
        int nrow = (int)this.dataModel.getRowCount();
        BitSet bits = new BitSet(nrow);
        int nactive = this.jtab.getRowCount();
        ListSelectionModel selModel = this.jtab.getSelectionModel();
        int[] rowMap = this.viewModel.getRowMap();
        if (rowMap == null) {
            int i = 0;
            while (i < nactive) {
                if (!selModel.isSelectedIndex(i)) {
                    bits.set(i);
                }
                ++i;
            }
        } else {
            if (!$assertionsDisabled && rowMap.length != nactive) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < nactive) {
                if (!selModel.isSelectedIndex(i)) {
                    bits.set(rowMap[i]);
                }
                ++i;
            }
        }
        return bits;
    }

    private void findRegex(StarTableColumn tcol, int jcol) {
        Object[] msg = new Object[]{"Enter a regular expression (e.g. \".*XYZ.*\")", "to select rows whose " + tcol.getColumnInfo().getName() + " value match it"};
        String regex = JOptionPane.showInputDialog(this, msg, "Search Column", 3);
        ListSelectionModel selModel = this.jtab.getSelectionModel();
        if (regex != null && regex.trim().length() > 0) {
            Pattern pat = Pattern.compile(regex);
            int nfound = 0;
            int first = -1;
            int nrow = this.viewModel.getRowCount();
            int irow = 0;
            while (irow < nrow) {
                Object cell = this.viewModel.getValueAt(irow, jcol);
                if (cell instanceof String && pat.matcher((String)cell).matches()) {
                    if (nfound == 0) {
                        first = irow;
                        selModel.clearSelection();
                    }
                    selModel.addSelectionInterval(irow, irow);
                    ++nfound;
                }
                ++irow;
            }
            if (nfound == 1) {
                this.tcModel.highlightRow(this.viewModel.getBaseRow(first));
            } else if (nfound > 1) {
                this.scrollToRow(first);
            }
        }
    }

    private void scrollToRow(int viewRow) {
        Rectangle viewRect = this.jtab.getCellRect(viewRow, 0, false);
        int yMid = viewRect.y + viewRect.height / 2;
        JScrollBar yBar = this.scrollpane.getVerticalScrollBar();
        yBar.setValue(yMid - yBar.getVisibleAmount() / 2);
    }

    public void tableChanged(TableModelEvent evt) {
        if (evt.getSource() == this.viewModel) {
            // empty if block
        }
    }

    public void columnAdded(TableColumnModelEvent evt) {
        if (evt.getSource() == this.columnModel) {
            StarJTable.configureColumnWidth((JTable)this.jtab, (int)MAX_COLUMN_WIDTH, (int)MAX_SAMPLE_ROWS, (int)evt.getToIndex());
        }
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        if (evt.getSource() == this.columnModel) {
            // empty if block
        }
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnMoved(TableColumnModelEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$TableViewerWindow == null ? (class$uk$ac$starlink$topcat$TableViewerWindow = TableViewerWindow.class$("uk.ac.starlink.topcat.TableViewerWindow")) : class$uk$ac$starlink$topcat$TableViewerWindow).desiredAssertionStatus();
        MAX_COLUMN_WIDTH = 300;
        MAX_SAMPLE_ROWS = 800;
    }

    private class ViewerAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        public ViewerAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == TableViewerWindow.this.includeAct || this == TableViewerWindow.this.excludeAct) {
                boolean exclude = this == TableViewerWindow.this.excludeAct;
                String name = TableViewerWindow.this.tcModel.enquireSubsetName(this.getEventWindow(evt));
                if (name != null) {
                    BitSet bits = exclude ? TableViewerWindow.this.getUnselectedRowFlags() : TableViewerWindow.this.getSelectedRowFlags();
                    BitsRowSubset rset = new BitsRowSubset(name, bits);
                    TableViewerWindow.this.tcModel.addSubset(rset);
                    TableViewerWindow.this.tcModel.applySubset(rset);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$TableViewerWindow == null ? (class$uk$ac$starlink$topcat$TableViewerWindow = TableViewerWindow.class$("uk.ac.starlink.topcat.TableViewerWindow")) : class$uk$ac$starlink$topcat$TableViewerWindow).desiredAssertionStatus();
        }
    }
}

