/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import uk.ac.starlink.topcat.ControlWindow;

public class TablesListComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ListDataListener {
    private final ListModel tablesList = ControlWindow.getInstance().getTablesListModel();
    private Object selected;

    public TablesListComboBoxModel() {
        this.tablesList.addListDataListener(this);
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public void setSelectedItem(Object item) {
        this.selected = item;
    }

    public int getSize() {
        return this.tablesList.getSize();
    }

    public Object getElementAt(int index) {
        return this.tablesList.getElementAt(index);
    }

    public void contentsChanged(ListDataEvent evt) {
        this.checkConsistent();
        this.fireContentsChanged(this, evt.getIndex0(), evt.getIndex1());
    }

    public void intervalAdded(ListDataEvent evt) {
        this.checkConsistent();
        this.fireIntervalAdded(this, evt.getIndex0(), evt.getIndex1());
    }

    public void intervalRemoved(ListDataEvent evt) {
        this.checkConsistent();
        this.fireIntervalRemoved(this, evt.getIndex0(), evt.getIndex1());
    }

    private void checkConsistent() {
        Object selected = this.getSelectedItem();
        if (selected != null) {
            int n = this.tablesList.getSize();
            boolean in = false;
            int i = 0;
            while (i < n) {
                in = in || selected.equals(this.tablesList.getElementAt(i));
                ++i;
            }
            if (!in) {
                this.setSelectedItem(null);
            }
        }
    }
}

