/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.ColumnList;

public class TopcatUtils {
    private static Boolean canSog_;
    private static Boolean canSplat_;
    private static Boolean canExec_;
    private static Boolean canJel_;
    private static Logger logger_;
    public static String DEMO_LOCATION;
    public static String DEMO_TABLE;
    public static String DEMO_NODES;
    public static final ValueInfo COLID_INFO;
    public static final ValueInfo BASE_DESCRIPTION_INFO;
    public static final ValueInfo EXPR_INFO;
    public static final ValueInfo ACTIVATORS_INFO;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$TopcatUtils;

    public static String getBaseDescription(ColumnInfo info) {
        DescribedValue descValue = info.getAuxDatum(BASE_DESCRIPTION_INFO);
        if (descValue == null) {
            return info.getDescription();
        }
        Object desc = descValue.getValue();
        return desc instanceof String ? (String)desc : info.getDescription();
    }

    public static void setBaseDescription(ColumnInfo info, String desc) {
        DescribedValue descValue = info.getAuxDatum(BASE_DESCRIPTION_INFO);
        if (descValue == null) {
            info.setDescription(desc);
        } else {
            descValue.setValue((Object)desc);
            String descrip = desc;
            String expr = TopcatUtils.getExpression(info);
            if (expr != null && expr.trim().length() > 0) {
                String string = descrip + " (" + expr + ")";
            }
        }
    }

    public static String getExpression(ColumnInfo info) {
        DescribedValue exprValue = info.getAuxDatum(EXPR_INFO);
        if (exprValue == null) {
            return null;
        }
        Object expr = exprValue.getValue();
        return expr == null ? null : expr.toString();
    }

    public static String getBaseName(String origName, String baseSuffix) {
        return TopcatUtils.suffixPattern(baseSuffix).matcher(origName).replaceFirst("");
    }

    public static String getDistinctName(ColumnList colList, String origName, String baseSuffix) {
        Pattern suffixPattern = TopcatUtils.suffixPattern(baseSuffix);
        String baseName = TopcatUtils.getBaseName(origName, baseSuffix);
        int baseLeng = baseName.length();
        int ncol = colList.size();
        int nextFreeIndex = 0;
        boolean unique = true;
        int ic = 0;
        while (ic < ncol) {
            String colName = ((StarTableColumn)colList.getColumn(ic)).getColumnInfo().getName();
            if (colName.startsWith(baseName)) {
                Matcher matcher;
                if (colName.equals(baseName)) {
                    unique = false;
                }
                if ((matcher = suffixPattern.matcher(colName.substring(baseLeng))).matches()) {
                    int isuf;
                    unique = false;
                    String suffIndex = matcher.group(1);
                    int n = isuf = suffIndex == null || suffIndex.length() == 0 ? 0 : Integer.parseInt(suffIndex);
                    if (isuf >= nextFreeIndex) {
                        nextFreeIndex = isuf + 1;
                    }
                }
            }
            ++ic;
        }
        if (unique) {
            return origName;
        }
        String newName = baseName + baseSuffix;
        if (nextFreeIndex > 0) {
            newName = newName + nextFreeIndex;
        }
        return newName;
    }

    private static Pattern suffixPattern(String baseSuffix) {
        return Pattern.compile("\\Q" + baseSuffix + "\\E" + "([0-9]*)$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSog() {
        if (canSog_ == null) {
            Class clazz = class$uk$ac$starlink$topcat$TopcatUtils == null ? (class$uk$ac$starlink$topcat$TopcatUtils = TopcatUtils.class$("uk.ac.starlink.topcat.TopcatUtils")) : class$uk$ac$starlink$topcat$TopcatUtils;
            synchronized (clazz) {
                try {
                    Class.forName("uk.ac.starlink.sog.SOG");
                    Class.forName("javax.media.jai.util.CaselessStringKey");
                    canSog_ = Boolean.TRUE;
                }
                catch (Throwable th) {
                    logger_.warning("No SoG: " + th);
                    canSog_ = Boolean.FALSE;
                }
            }
        }
        return canSog_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSplat() {
        if (canSplat_ == null) {
            Class clazz = class$uk$ac$starlink$topcat$TopcatUtils == null ? (class$uk$ac$starlink$topcat$TopcatUtils = TopcatUtils.class$("uk.ac.starlink.topcat.TopcatUtils")) : class$uk$ac$starlink$topcat$TopcatUtils;
            synchronized (clazz) {
                try {
                    Class.forName("uk.ac.starlink.splat.data.SpecData");
                    canSplat_ = AstPackage.isAvailable() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable th) {
                    logger_.warning("No SPLAT: " + th);
                    canSplat_ = Boolean.FALSE;
                }
            }
        }
        return canSplat_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canExec() {
        if (canExec_ == null) {
            Class clazz = class$uk$ac$starlink$topcat$TopcatUtils == null ? (class$uk$ac$starlink$topcat$TopcatUtils = TopcatUtils.class$("uk.ac.starlink.topcat.TopcatUtils")) : class$uk$ac$starlink$topcat$TopcatUtils;
            synchronized (clazz) {
                SecurityManager sman = System.getSecurityManager();
                if (sman != null) {
                    try {
                        sman.checkExec(null);
                    }
                    catch (SecurityException e) {
                        logger_.warning("Security manager forbids system execution");
                        canExec_ = Boolean.FALSE;
                    }
                }
                canExec_ = Boolean.TRUE;
            }
        }
        return canExec_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canJel() {
        if (canJel_ == null) {
            boolean can;
            Class clazz = class$uk$ac$starlink$topcat$TopcatUtils == null ? (class$uk$ac$starlink$topcat$TopcatUtils = TopcatUtils.class$("uk.ac.starlink.topcat.TopcatUtils")) : class$uk$ac$starlink$topcat$TopcatUtils;
            synchronized (clazz) {
                SecurityManager sman = System.getSecurityManager();
                if (sman != null) {
                    try {
                        sman.checkCreateClassLoader();
                        can = true;
                    }
                    catch (SecurityException e) {
                        logger_.warning("Security manager forbids JEL use");
                        can = false;
                    }
                } else {
                    can = true;
                }
            }
            canJel_ = can;
        }
        return canJel_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.topcat");
        DEMO_LOCATION = "uk/ac/starlink/topcat/demo";
        DEMO_TABLE = "6dfgs_mini.xml.bz2";
        DEMO_NODES = "demo_list";
        COLID_INFO = new DefaultValueInfo("$ID", class$java$lang$String == null ? (class$java$lang$String = TopcatUtils.class$("java.lang.String")) : class$java$lang$String, "Unique column ID");
        BASE_DESCRIPTION_INFO = new DefaultValueInfo("Base Description", class$java$lang$String == null ? (class$java$lang$String = TopcatUtils.class$("java.lang.String")) : class$java$lang$String, "Description omitting expression");
        EXPR_INFO = new DefaultValueInfo("Expression", class$java$lang$String == null ? (class$java$lang$String = TopcatUtils.class$("java.lang.String")) : class$java$lang$String, "Algebraic expression for column value");
        ACTIVATORS_INFO = new DefaultValueInfo("topcat-activation", class$java$lang$String == null ? (class$java$lang$String = TopcatUtils.class$("java.lang.String")) : class$java$lang$String, "Action which can be performed on row activation");
    }
}

