/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.io.IOException;
import javax.swing.table.AbstractTableModel;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.EditableColumn;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.RowSubset;

public class ViewerTableModel
extends AbstractTableModel {
    private PlasticStarTable startable;
    private RowSubset rset = RowSubset.ALL;
    private int[] order;
    private int[] rowMap;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ViewerTableModel;

    public ViewerTableModel(PlasticStarTable startable) {
        this.startable = startable;
        if (!startable.isRandom()) {
            throw new IllegalArgumentException("Table " + (Object)((Object)startable) + " does not have random access");
        }
        if (startable.getRowCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Table has too many rows (" + startable.getRowCount() + " > Integer.MAX_VALUE)");
        }
    }

    public void setOrder(int[] order) {
        if (order != null && (long)order.length != this.startable.getRowCount()) {
            throw new IllegalArgumentException("Wrong number of rows! (" + order.length + " != " + this.startable.getRowCount());
        }
        this.order = order;
        this.setRowMap(ViewerTableModel.getRowMap(order, this.rset, this.getTableRowCount()));
        this.fireTableDataChanged();
    }

    public void setSubset(RowSubset rset) {
        this.rowMap = ViewerTableModel.getRowMap(this.order, rset, this.getTableRowCount());
        this.rset = rset;
        this.fireTableDataChanged();
    }

    public RowSubset getSubset() {
        return this.rset;
    }

    public int[] getRowMap() {
        return this.rowMap;
    }

    public void setRowMap(int[] rowMap) {
        this.rowMap = rowMap;
        this.fireTableDataChanged();
    }

    private static int[] getRowMap(int[] order, RowSubset rset, int nrow) {
        int i;
        if (rset == RowSubset.ALL) {
            return order;
        }
        int[] rmap = new int[nrow];
        int j = 0;
        if (order != null) {
            i = 0;
            while (i < nrow) {
                int k = order[i];
                if (rset.isIncluded(k)) {
                    rmap[j++] = k;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < nrow) {
                if (rset.isIncluded(i)) {
                    rmap[j++] = i;
                }
                ++i;
            }
        }
        int[] rmap2 = new int[j];
        System.arraycopy(rmap, 0, rmap2, 0, j);
        return rmap2;
    }

    public int getColumnCount() {
        return this.startable.getColumnCount();
    }

    public int getRowCount() {
        return this.rowMap == null ? this.getTableRowCount() : this.rowMap.length;
    }

    public long getBaseRow(int irow) {
        return this.rowMap == null ? (long)irow : (long)this.rowMap[irow];
    }

    public int getViewRow(long lrow) {
        if (this.rowMap == null) {
            return (int)lrow;
        }
        int nr = this.rowMap.length;
        int irow = AbstractStarTable.checkedLongToInt((long)lrow);
        int i = 0;
        while (i < nr) {
            if (this.rowMap[i] == irow) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getValueAt(int irow, int icol) {
        try {
            return this.startable.getCell(this.getBaseRow(irow), icol);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isCellEditable(int irow, int icol) {
        return true;
    }

    public void setValueAt(Object val, int irow, int icol) {
        ColumnData coldat = this.startable.getColumnData(icol);
        if (!this.startable.getColumnData(icol).isWritable()) {
            ColumnData oldcol = this.startable.getColumnData(icol);
            EditableColumn newcol = new EditableColumn(oldcol);
            this.startable.setColumn(icol, (ColumnData)newcol);
        }
        if (!$assertionsDisabled && !this.startable.getColumnData(icol).isWritable()) {
            throw new AssertionError();
        }
        try {
            this.startable.getColumnData(icol).storeValue(this.getBaseRow(irow), val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fireTableRowsUpdated(irow, irow);
    }

    private int getTableRowCount() {
        return AbstractStarTable.checkedLongToInt((long)this.startable.getRowCount());
    }

    public StarTable getSnapshot() {
        return this.getRowPermutedView((StarTable)this.startable);
    }

    public StarTable getRowPermutedView(StarTable table) {
        if (this.rowMap == null) {
            return table;
        }
        int nrow = this.rowMap.length;
        long[] rowMapCopy = new long[nrow];
        int i = 0;
        while (i < nrow) {
            rowMapCopy[i] = this.rowMap[i];
            ++i;
        }
        return new RowPermutedStarTable(table, rowMapCopy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$ViewerTableModel == null ? (class$uk$ac$starlink$topcat$ViewerTableModel = ViewerTableModel.class$("uk.ac.starlink.topcat.ViewerTableModel")) : class$uk$ac$starlink$topcat$ViewerTableModel).desiredAssertionStatus();
    }
}

