/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.doc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class MemberDoclet {
    private final RootDoc root_;
    private final Set packages_ = new HashSet();
    private static final Pattern P_PATTERN = Pattern.compile("\\s*(</*[Pp]>)?\\s*(<[Pp]>)\\s*");
    private static final Map TYPE_NAMES = new HashMap();
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    protected abstract void startClass(ClassDoc var1) throws IOException;

    protected abstract void endClass() throws IOException;

    protected abstract void startMember(MemberDoc var1, String var2, String var3) throws IOException;

    protected abstract void endMember() throws IOException;

    protected abstract void outItem(String var1, String var2) throws IOException;

    protected abstract void outParameters(Parameter[] var1, String[] var2) throws IOException;

    protected abstract void outExamples(String[] var1) throws IOException;

    protected abstract void outDescription(String var1) throws IOException;

    protected MemberDoclet(RootDoc root) {
        this.root_ = root;
    }

    protected boolean process() throws IOException {
        ClassDoc[] classes = this.root_.classes();
        int i = 0;
        while (i < classes.length) {
            ClassDoc clazz = classes[i];
            if (clazz.isPublic()) {
                this.processClass(clazz);
                if (!this.packages_.contains(clazz)) {
                    this.processPackage(clazz.containingPackage());
                }
            }
            ++i;
        }
        return true;
    }

    protected void processPackage(PackageDoc pack) throws IOException {
    }

    protected void processClass(ClassDoc clazz) throws IOException {
        this.startClass(clazz);
        FieldDoc[] fields = clazz.fields();
        int i = 0;
        while (i < fields.length) {
            FieldDoc field = fields[i];
            if (field.isPublic() && field.isStatic() && field.isFinal()) {
                this.processField(field);
            }
            ++i;
        }
        MethodDoc[] methods = clazz.methods();
        int i2 = 0;
        while (i2 < methods.length) {
            MethodDoc method = methods[i2];
            if (method.isPublic() && method.isStatic()) {
                this.processMethod(method);
            }
            ++i2;
        }
        this.endClass();
    }

    private void processField(FieldDoc field) throws IOException {
        ClassDoc clazz = field.containingClass();
        this.startMember((MemberDoc)field, "Constant", field.name());
        this.outDescription(field.commentText());
        this.outItem("Type", MemberDoclet.typeString(field.type()));
        Object value = field.constantValue();
        if (value != null) {
            this.outItem("Value", value.toString());
        }
        this.endMember();
    }

    private void processMethod(MethodDoc method) throws IOException {
        ClassDoc clazz = method.containingClass();
        Parameter[] params = method.parameters();
        StringBuffer paramList = new StringBuffer("( ");
        int i = 0;
        while (i < params.length) {
            String pname = params[i].name();
            if (i > 0) {
                paramList.append(", ");
            }
            paramList.append(pname);
            ++i;
        }
        paramList.append(" )");
        ParamTag[] ptags = method.paramTags();
        String[] comments = new String[params.length];
        int i2 = 0;
        while (i2 < params.length) {
            String pname = params[i2].name();
            int j = 0;
            while (j < ptags.length) {
                if (pname.equals(ptags[j].parameterName())) {
                    if (comments[i2] == null) {
                        comments[i2] = ptags[j].parameterComment();
                    } else {
                        MemberDoclet.warning(clazz + "." + method + ": " + "multiple tags for parameter " + pname);
                    }
                }
                ++j;
            }
            if (comments[i2] == null) {
                MemberDoclet.warning(clazz + "." + method + ": " + "no tag for parameter " + pname);
            }
            ++i2;
        }
        String retdesc = null;
        boolean isVoid = "void".equals(method.returnType().qualifiedTypeName());
        Tag[] retags = method.tags("return");
        if (!isVoid) {
            if (retags.length != 1) {
                MemberDoclet.warning(clazz + "." + method + ": " + retags.length + " @return tags");
            } else {
                retdesc = retags[0].text();
            }
        }
        Tag[] extags = method.tags("example");
        String[] examples = new String[extags.length];
        int i3 = 0;
        while (i3 < extags.length) {
            examples[i3] = extags[i3].text();
            ++i3;
        }
        Type rtype = method.returnType();
        this.startMember((MemberDoc)method, "Function", method.name() + paramList);
        this.outDescription(method.commentText());
        this.outParameters(params, comments);
        if (!isVoid) {
            if (retdesc != null) {
                this.outItem("Return Value (" + MemberDoclet.typeString(rtype) + ")", retdesc);
            } else {
                this.outItem("Return Type", MemberDoclet.typeString(rtype));
            }
        }
        if (examples.length > 0) {
            this.outExamples(examples);
        }
        this.outItem("Signature", "<tt>" + rtype.toString() + " " + method.name() + method.signature() + "</tt>");
        this.endMember();
    }

    public static String typeString(Type type) {
        String pre = type.dimension().replaceAll("\\[\\]", "array of ");
        String fqname = type.qualifiedTypeName();
        if (TYPE_NAMES.containsKey(fqname)) {
            return pre + (String)TYPE_NAMES.get(fqname);
        }
        return pre + type.typeName();
    }

    public static String pWrap(String text) {
        String[] params = P_PATTERN.split(text);
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            sbuf.append("<p>" + params[i] + "</p>\n");
            ++i;
        }
        return sbuf.toString();
    }

    public static void warning(String msg) {
        System.err.println(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TYPE_NAMES.put(Byte.TYPE.getName(), "byte");
        TYPE_NAMES.put(Short.TYPE.getName(), "short integer");
        TYPE_NAMES.put(Integer.TYPE.getName(), "integer");
        TYPE_NAMES.put(Long.TYPE.getName(), "long integer");
        TYPE_NAMES.put(Float.TYPE.getName(), "floating point");
        TYPE_NAMES.put(Double.TYPE.getName(), "floating point");
        TYPE_NAMES.put((class$java$lang$Byte == null ? (class$java$lang$Byte = MemberDoclet.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), "byte");
        TYPE_NAMES.put((class$java$lang$Short == null ? (class$java$lang$Short = MemberDoclet.class$("java.lang.Short")) : class$java$lang$Short).getName(), "short integer");
        TYPE_NAMES.put((class$java$lang$Integer == null ? (class$java$lang$Integer = MemberDoclet.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), "integer");
        TYPE_NAMES.put((class$java$lang$Long == null ? (class$java$lang$Long = MemberDoclet.class$("java.lang.Long")) : class$java$lang$Long).getName(), "long integer");
        TYPE_NAMES.put((class$java$lang$Float == null ? (class$java$lang$Float = MemberDoclet.class$("java.lang.Float")) : class$java$lang$Float).getName(), "floating point");
        TYPE_NAMES.put((class$java$lang$Double == null ? (class$java$lang$Double = MemberDoclet.class$("java.lang.Double")) : class$java$lang$Double).getName(), "floating point");
        TYPE_NAMES.put((class$java$lang$String == null ? (class$java$lang$String = MemberDoclet.class$("java.lang.String")) : class$java$lang$String).getName(), "String");
    }
}

