/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.doc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.topcat.doc.MemberDoclet;

public class XmlDoclet
extends MemberDoclet {
    private final BufferedWriter out_;
    private boolean discardOutput_;
    private Class[] classes_;

    public static boolean start(RootDoc root) throws IOException {
        return new XmlDoclet(root).process();
    }

    public static int optionLength(String option) {
        if (option.equals("-o")) {
            return 2;
        }
        if (option.equals("-gen")) {
            return 1;
        }
        if (option.equals("-act")) {
            return 1;
        }
        return 0;
    }

    private XmlDoclet(RootDoc root) throws IOException {
        super(root);
        String[][] options = root.options();
        String outloc = null;
        int i = 0;
        while (i < options.length) {
            String opt = options[i][0];
            if (opt.equals("-o")) {
                outloc = options[i][1];
            } else if (opt.equals("-gen")) {
                this.classes_ = TopcatJELUtils.getStaticClasses().toArray(new Class[0]);
            } else if (opt.equals("-act")) {
                this.classes_ = TopcatJELUtils.getActivationStaticClasses().toArray(new Class[0]);
            }
            ++i;
        }
        PrintStream ostrm = outloc == null || outloc.equals("-") ? System.out : new FileOutputStream(outloc);
        this.out_ = new BufferedWriter(new OutputStreamWriter(ostrm));
    }

    protected boolean process() throws IOException {
        this.out("<dl>");
        boolean ret = super.process();
        this.out("</dl>");
        this.out_.flush();
        return ret;
    }

    protected void startClass(ClassDoc clazz) throws IOException {
        this.discardOutput_ = !this.useClass(clazz);
        this.out("<dt>" + clazz.name() + "</dt>");
        this.out("<dd>");
        String comment = clazz.commentText();
        if (comment != null) {
            this.out(XmlDoclet.doctorText(comment));
        }
        this.out("<p><dl>");
    }

    protected void endClass() throws IOException {
        this.out("</dl></p>");
        this.out("</dd>");
        this.discardOutput_ = false;
    }

    protected void startMember(MemberDoc mem, String memType, String memName) throws IOException {
        this.out("<dt>" + memName + "</dt>");
        String comment = mem.commentText();
        if (comment != null) {
            this.out("<dd>" + XmlDoclet.doctorText(comment) + "</dd>");
        }
    }

    protected void endMember() {
    }

    protected void outDescription(String descrip) throws IOException {
    }

    protected void outItem(String name, String val) {
    }

    protected void outParameters(Parameter[] param, String[] comments) {
    }

    protected void outExamples(String[] examples) {
    }

    private boolean useClass(ClassDoc classDoc) {
        if (this.classes_ == null) {
            return true;
        }
        String cname = classDoc.qualifiedName();
        int i = 0;
        while (i < this.classes_.length) {
            if (this.classes_[i].getName().equals(cname)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void out(String[] lines) throws IOException {
        int i = 0;
        while (i < lines.length) {
            this.out(lines[i]);
            ++i;
        }
    }

    private void out(String line) throws IOException {
        if (!this.discardOutput_) {
            this.out_.write(line);
            this.out_.write(10);
        }
    }

    private static String doctorText(String text) {
        text = text.replaceAll("<a href=", "<webref url=").replaceAll("</a>", "</webref>");
        return MemberDoclet.pWrap(text);
    }
}

