/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.topcat.func.Image;
import uk.ac.starlink.topcat.func.TopcatCgiQuery;
import uk.ac.starlink.ttools.func.Coords;
import uk.ac.starlink.util.FileDataSource;

public class TwoMass {
    public static final Logger logger = Logger.getLogger("uk.ac.starlink.topcat.func");
    public static final String TWOMASS_BASE_URL = "http://irsa.ipac.caltech.edu/cgi-bin/Oasis/2MASSImg/nph-2massimg";

    public static String image2Mass(final String label, double ra, double dec, int npix, char band) {
        final TopcatCgiQuery query = (TopcatCgiQuery)new TopcatCgiQuery(TWOMASS_BASE_URL).addArgument("objstr", Coords.radiansToHms((double)ra, (int)5).trim() + " " + Coords.radiansToDms((double)dec, (int)4).trim()).addArgument("size", (long)npix).addArgument("band", String.valueOf(Character.toLowerCase(band)));
        new Thread(){

            public void run() {
                block3: {
                    try {
                        File file = query.executeAsLocalFile(".fits.gz");
                        FileDataSource datsrc = new FileDataSource(file);
                        if (FitsConstants.isMagic((byte[])datsrc.getIntro())) {
                            SwingUtilities.invokeLater(new Runnable(this, file){
                                private final /* synthetic */ File val$file;
                                private final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = this$0;
                                    this.val$file = val$file;
                                }

                                public void run() {
                                    Image.displayImage(1.access$000(this.this$0), this.val$file.toString());
                                }
                            });
                            break block3;
                        }
                        logger.warning("Non-FITS return from 2MASS cutout server");
                    }
                    catch (IOException e) {
                        logger.warning(e.toString());
                    }
                }
            }

            static /* synthetic */ String access$000(1 x0) {
                return x0.label;
            }
        }.start();
        return query.toString();
    }
}

