/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import uk.ac.starlink.topcat.func.Image;
import uk.ac.starlink.topcat.func.Spectrum;

public class TwoQZ {
    public static final String TWOQZ_SPEC_BASE = "http://www.2dfquasar.org/fits/";
    public static final String TWOQZ_SPEC_TAIL = ".fits.gz";
    public static final String TWOQZ_FITS_IMAGE_BASE = "http://www.2dfquasar.org/postfits/";
    public static final String TWOQZ_FITS_IMAGE_TAIL = ".fits.gz";
    public static final String TWOQZ_JPEG_IMAGE_BASE = "http://www.2dfquasar.org/postjpg/";
    public static final String TWOQZ_JPEG_IMAGE_TAIL = ".jpg";

    private TwoQZ() {
    }

    public static String spectra2QZ(String name, int nobs) {
        String[] locs = new String[nobs];
        String base = TWOQZ_SPEC_BASE + TwoQZ.getSubdir(name);
        int i = 0;
        while (i < nobs) {
            locs[i] = base + name + (char)(97 + i) + ".fits.gz";
            ++i;
        }
        return Spectrum.displaySpectra("2QZ", locs);
    }

    public static String image2QZ(String name) {
        String loc = TWOQZ_FITS_IMAGE_BASE + TwoQZ.getSubdir(name) + name + ".fits.gz";
        return Image.displayImage("2QZ", loc);
    }

    public static String jpeg2QZ(String name) {
        String loc = TWOQZ_JPEG_IMAGE_BASE + TwoQZ.getSubdir(name) + name + TWOQZ_JPEG_IMAGE_TAIL;
        return Image.displayImage("2QZ", loc);
    }

    public static String get2qzSubdir(String name) {
        return TwoQZ.getSubdir(name);
    }

    private static String getSubdir(String name) {
        int rah = Integer.parseInt(name.substring(1, 3));
        int rah1 = rah + 1;
        return "ra" + TwoQZ.format2(rah) + '_' + TwoQZ.format2(rah1) + '/';
    }

    private static String format2(int num) {
        String out = Integer.toString(num);
        return out.length() == 2 ? out : "0" + out.charAt(0);
    }
}

