/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.join.MatchOption;
import uk.ac.starlink.topcat.join.MatchSpec;
import uk.ac.starlink.topcat.join.OutputRequirements;
import uk.ac.starlink.topcat.join.TupleSelector;

public class InterMatchSpec
extends MatchSpec {
    private final int nTable;
    private final MatchEngine engine;
    private final TupleSelector[] tupleSelectors;
    private final OutputRequirements[] outReqs;
    private StarTable result;
    private int matchCount;
    private RowSubset[] matchSubsets;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$join$InterMatchSpec;
    static /* synthetic */ Class class$java$lang$String;

    public InterMatchSpec(MatchEngine engine, int nTable) {
        this.nTable = nTable;
        this.engine = engine;
        Box main = Box.createVerticalBox();
        this.add(main);
        this.tupleSelectors = new TupleSelector[nTable];
        int i = 0;
        while (i < nTable) {
            TupleSelector selector = new TupleSelector(engine);
            selector.setBorder(AuxWindow.makeTitledBorder("Table " + (i + 1)));
            this.tupleSelectors[i] = selector;
            main.add(selector);
            ++i;
        }
        this.outReqs = new OutputRequirements[nTable];
        int i2 = 0;
        while (i2 < nTable) {
            this.outReqs[i2] = new OutputRequirements();
            ++i2;
        }
        Box rowBox = Box.createVerticalBox();
        int i3 = 0;
        while (i3 < nTable) {
            Box line = Box.createHorizontalBox();
            line.add(new JLabel("Table " + (i3 + 1) + ": "));
            line.add(this.outReqs[i3].getRowLine());
            rowBox.add(line);
            ++i3;
        }
        rowBox.setBorder(AuxWindow.makeTitledBorder("Output Rows"));
        main.add(rowBox);
    }

    public void checkArguments() {
        int i = 0;
        while (i < this.nTable) {
            TupleSelector ts = this.tupleSelectors[i];
            try {
                StarTable st = ts.getEffectiveTable();
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + " for table " + (i + 1));
            }
            ++i;
        }
    }

    public void calculate(ProgressIndicator indicator) throws IOException, InterruptedException {
        ArrayList matches;
        Map matchScores;
        this.matchSubsets = null;
        this.result = null;
        TopcatModel[] tcModels = new TopcatModel[this.nTable];
        StarTable[] tables = new StarTable[this.nTable];
        StarTable[] bases = new StarTable[this.nTable];
        int i = 0;
        while (i < this.nTable) {
            tcModels[i] = this.tupleSelectors[i].getTable();
            tables[i] = this.tupleSelectors[i].getEffectiveTable();
            bases[i] = tcModels[i].getApparentStarTable();
            ++i;
        }
        boolean[] useAlls = this.getUseAlls();
        RowMatcher matcher = new RowMatcher(this.engine, tables);
        matcher.setIndicator(indicator);
        if (this.nTable == 2) {
            matchScores = matcher.findPairMatches(!useAlls[0], !useAlls[1]);
            matches = new ArrayList(matchScores.keySet());
            Collections.sort(matches);
        } else {
            matches = matcher.findGroupMatches(useAlls);
            matchScores = null;
        }
        int nrow = matches.size();
        this.result = MatchStarTables.makeJoinTable((StarTable[])bases, (Collection)matches, (Map)matchScores, (JoinStarTable.FixAction[])this.getDefaultFixActions(this.nTable));
        InterMatchSpec.addMatchMetadata(this.result, this.getDescription(), this.engine, tables);
        BitSet[] bitsets = new BitSet[this.nTable];
        int i2 = 0;
        while (i2 < this.nTable) {
            bitsets[i2] = new BitSet();
            ++i2;
        }
        this.matchCount = 0;
        int irow = 0;
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int i3 = 0;
            while (i3 < nref) {
                int iTable = link.getRef(i3).getTableIndex();
                bitsets[iTable].set(irow);
                ++i3;
            }
            if (nref > 1) {
                ++this.matchCount;
            }
            ++irow;
        }
        if (!$assertionsDisabled && irow != nrow) {
            throw new AssertionError();
        }
        ArrayList<BitsRowSubset> subsetList = new ArrayList<BitsRowSubset>();
        int i4 = 0;
        while (i4 < this.nTable) {
            BitSet bset = bitsets[i4];
            int ntrue = bset.cardinality();
            if (ntrue > 0 && ntrue < nrow) {
                BitsRowSubset rset = new BitsRowSubset("match" + tcModels[i4].getID(), bitsets[i4]);
                subsetList.add(rset);
            }
            ++i4;
        }
        this.matchSubsets = subsetList.toArray(new RowSubset[0]);
    }

    public void matchSuccess(Component parent) {
        int msgType;
        String title;
        String[] msg;
        if (this.result.getRowCount() == 0L || this.matchCount == 0) {
            msg = "Matched table contains no rows";
            title = "Match Failed";
            msgType = 0;
        } else {
            StringBuffer sbuf = new StringBuffer("match");
            int i = 0;
            while (i < this.nTable) {
                sbuf.append(i == 0 ? (char)'(' : ',');
                sbuf.append(this.tupleSelectors[i].getTable().getID());
                ++i;
            }
            sbuf.append(')');
            TopcatModel tcModel = ControlWindow.getInstance().addTable(this.result, sbuf.toString(), true);
            int i2 = 0;
            while (i2 < this.matchSubsets.length) {
                tcModel.addSubset(this.matchSubsets[i2]);
                ++i2;
            }
            msg = new String[]{this.matchCount + (this.nTable == 2 ? " pairs" : " match groups") + " found", "New table created by match: " + tcModel};
            title = "Match Successful";
            msgType = 1;
        }
        JOptionPane.showMessageDialog(parent, msg, title, msgType);
    }

    public String getDescription() {
        return this.toString();
    }

    private boolean[] getUseAlls() {
        boolean[] ua = new boolean[this.nTable];
        int i = 0;
        while (i < this.nTable) {
            ua[i] = this.outReqs[i].getRowOption() == MatchOption.ANY;
            ++i;
        }
        return ua;
    }

    private static void addMatchMetadata(StarTable table, String matchType, MatchEngine engine, StarTable[] effTables) {
        List params = table.getParameters();
        params.add(new DescribedValue(MatchSpec.MATCHTYPE_INFO, (Object)matchType));
        params.add(new DescribedValue(MatchSpec.ENGINE_INFO, (Object)engine.toString()));
        DescribedValue[] matchParams = engine.getMatchParameters();
        int i = 0;
        while (i < matchParams.length) {
            params.add(matchParams[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < effTables.length) {
            URL url;
            String id = null;
            if (id == null && (url = table.getURL()) != null) {
                id = url.toString();
            }
            if (id == null) {
                id = table.getName();
            }
            if (id == null) {
                id = "(virtual)";
            }
            DefaultValueInfo idInfo = new DefaultValueInfo("Matched table " + i2, class$java$lang$String == null ? InterMatchSpec.class$("java.lang.String") : class$java$lang$String, "Table on which the match was done");
            params.add(new DescribedValue((ValueInfo)idInfo, (Object)id));
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$join$InterMatchSpec == null ? (class$uk$ac$starlink$topcat$join$InterMatchSpec = InterMatchSpec.class$("uk.ac.starlink.topcat.join.InterMatchSpec")) : class$uk$ac$starlink$topcat$join$InterMatchSpec).desiredAssertionStatus();
    }
}

