/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.topcat.ColumnSelector;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.TablesListComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;

public class TupleSelector
extends JPanel {
    private final MatchEngine engine;
    private final ColumnSelector[] colSelectors;
    private final ValueInfo[] infos;
    private final int nCols;
    private TopcatModel tcModel;

    public TupleSelector(MatchEngine engine) {
        this.engine = engine;
        this.infos = engine.getTupleInfos();
        this.nCols = this.infos.length;
        Box main = Box.createVerticalBox();
        this.add(main);
        final JComboBox tableSelector = new JComboBox(new TablesListComboBoxModel());
        tableSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TupleSelector.this.setTable((TopcatModel)tableSelector.getSelectedItem());
            }
        });
        Box line = Box.createHorizontalBox();
        JLabel label = new JLabel("Table: ");
        label.setToolTipText("Table to perform the matching on");
        line.add(label);
        line.add(tableSelector);
        main.add(line);
        this.colSelectors = new ColumnSelector[this.nCols];
        int i = 0;
        while (i < this.nCols) {
            this.colSelectors[i] = new ColumnSelector(this.infos[i]);
            main.add(this.colSelectors[i]);
            ++i;
        }
        main.add(Box.createVerticalGlue());
    }

    public StarTable getEffectiveTable() {
        if (this.tcModel == null) {
            throw new IllegalStateException("No table selected");
        }
        PlasticStarTable baseTable = this.tcModel.getDataModel();
        ColumnStarTable effTable = new ColumnStarTable((StarTable)baseTable, (StarTable)baseTable){
            private final /* synthetic */ StarTable val$baseTable;
            {
                this.val$baseTable = val$baseTable;
                super(x0);
            }

            public long getRowCount() {
                return this.val$baseTable.getRowCount();
            }
        };
        int j = 0;
        while (j < this.nCols) {
            ColumnData cdata = this.colSelectors[j].getColumnData();
            if (cdata == null) {
                throw new IllegalStateException("No " + this.infos[j].getName() + " column selected");
            }
            effTable.addColumn(cdata);
            ++j;
        }
        return this.tcModel.getViewModel().getRowPermutedView((StarTable)effTable);
    }

    public TopcatModel getTable() {
        return this.tcModel;
    }

    private void setTable(TopcatModel tcModel) {
        this.tcModel = tcModel;
        int i = 0;
        while (i < this.nCols) {
            this.colSelectors[i].setTable(tcModel);
            ++i;
        }
    }
}

