/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class BlobPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    private List blobs_;
    private GeneralPath dragPath_;
    private Color fillColor_ = new Color(0, 0, 0, 64);
    private Color pathColor_ = new Color(0, 0, 0, 128);

    public BlobPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                BlobPanel.this.clear();
            }
        });
        this.setOpaque(false);
        this.clear();
    }

    public Shape getBlob() {
        Area area = new Area();
        Iterator it = this.blobs_.iterator();
        while (it.hasNext()) {
            area.add(new Area((Shape)it.next()));
        }
        return BlobPanel.simplify(area);
    }

    public void setBlob(Shape blob) {
        this.blobs_ = new ArrayList();
        this.blobs_.add(blob);
        this.repaint();
    }

    public void clear() {
        this.blobs_ = new ArrayList();
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Area area = new Area();
        Iterator it = this.blobs_.iterator();
        while (it.hasNext()) {
            area.add(new Area((Shape)it.next()));
        }
        if (this.dragPath_ != null) {
            area.add(new Area(this.dragPath_));
            g2.setColor(this.pathColor_);
            g2.draw(this.dragPath_);
        }
        g2.setColor(this.fillColor_);
        g2.fill(area);
        g.setColor(oldColor);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
        if (this.dragPath_ != null) {
            this.dragPath_ = null;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            int nblob = this.blobs_.size();
            if (nblob > 0) {
                this.blobs_.remove(nblob - 1);
            }
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() == 1) {
            Point p = evt.getPoint();
            this.dragPath_ = new GeneralPath();
            this.dragPath_.moveTo(p.x, p.y);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.getButton() == 1 && this.dragPath_ != null) {
            this.blobs_.add(BlobPanel.simplify(this.dragPath_));
            this.dragPath_ = null;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.dragPath_ != null) {
            Point p = evt.getPoint();
            this.dragPath_.lineTo(p.x, p.y);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    private static Shape simplify(Shape shape) {
        return shape;
    }
}

