/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import uk.ac.starlink.topcat.plot.MarkStyle;

public abstract class MarkStyleProfile {
    private String name_;
    private static final Color[] COLORS = new Color[]{Color.red, Color.blue.brighter(), Color.green.darker(), Color.gray, Color.magenta, Color.cyan.darker(), Color.orange, Color.blue.darker(), Color.pink, Color.yellow, Color.black};

    protected MarkStyleProfile(String name) {
        this.name_ = name;
    }

    public abstract MarkStyle getStyle(int var1);

    public String getName() {
        return this.name_ == null ? super.toString() : this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public Icon getIcon() {
        return new MarkStyleProfileIcon();
    }

    private static Color getColor(int index) {
        return COLORS[Math.abs(index) % COLORS.length];
    }

    public static MarkStyleProfile points(String name) {
        return new MarkStyleProfile(name){

            public MarkStyle getStyle(int index) {
                return MarkStyle.pointStyle(MarkStyleProfile.getColor(index));
            }
        };
    }

    public static MarkStyleProfile spots(String name, final int size) {
        return new MarkStyleProfile(name){

            public MarkStyle getStyle(int index) {
                return MarkStyle.filledCircleStyle(MarkStyleProfile.getColor(index), size);
            }
        };
    }

    public static MarkStyleProfile ghosts(String name, final int size, float alpha) {
        final int iAlpha = (int)((double)alpha * 255.99);
        final int lAlpha = Math.max(iAlpha, 96);
        final int lsize = Math.max(size, 1);
        return new MarkStyleProfile(name){

            public MarkStyle getStyle(int index) {
                Color baseColor = MarkStyleProfile.getColor(index);
                Color color = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), iAlpha);
                Color lcolor = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), lAlpha);
                return MarkStyle.compositeMarkStyle(MarkStyle.filledSquareStyle(color, size), MarkStyle.filledSquareStyle(lcolor, lsize));
            }
        };
    }

    public static MarkStyleProfile openShapes(String name, final int size, final Color color) {
        return new MarkStyleProfile(name){

            public MarkStyle getStyle(int index) {
                Color col = color == null ? MarkStyleProfile.getColor(index) : color;
                switch (Math.abs(index) % 7) {
                    case 0: {
                        return MarkStyle.crossStyle(col, size);
                    }
                    case 1: {
                        return MarkStyle.xStyle(col, size);
                    }
                    case 2: {
                        return MarkStyle.openCircleStyle(col, size);
                    }
                    case 3: {
                        return MarkStyle.openSquareStyle(col, size);
                    }
                    case 4: {
                        return MarkStyle.openDiamondStyle(col, size);
                    }
                    case 5: {
                        return MarkStyle.openTriangleStyle(col, size, true);
                    }
                    case 6: {
                        return MarkStyle.openTriangleStyle(col, size, false);
                    }
                }
                throw new AssertionError();
            }
        };
    }

    public static MarkStyleProfile filledShapes(String name, final int size, final Color color) {
        return new MarkStyleProfile(name){

            public MarkStyle getStyle(int index) {
                Color col = color == null ? MarkStyleProfile.getColor(index) : color;
                switch (Math.abs(index) % 5) {
                    case 0: {
                        return MarkStyle.filledCircleStyle(col, size);
                    }
                    case 1: {
                        return MarkStyle.filledSquareStyle(col, size);
                    }
                    case 2: {
                        return MarkStyle.filledDiamondStyle(col, size);
                    }
                    case 3: {
                        return MarkStyle.filledTriangleStyle(col, size, true);
                    }
                    case 4: {
                        return MarkStyle.filledTriangleStyle(col, size, false);
                    }
                }
                throw new AssertionError();
            }
        };
    }

    private class MarkStyleProfileIcon
    implements Icon {
        int NMARK = 5;
        int SEPARATION;
        int HEIGHT = this.SEPARATION = 16;

        private MarkStyleProfileIcon() {
        }

        public int getIconHeight() {
            return this.HEIGHT;
        }

        public int getIconWidth() {
            return (this.NMARK + 1) * this.SEPARATION;
        }

        public void paintIcon(Component c, Graphics g, int xoff, int yoff) {
            int y = yoff + this.HEIGHT / 2;
            int x = xoff + this.SEPARATION / 2;
            int i = 0;
            while (i < this.NMARK) {
                MarkStyleProfile.this.getStyle(i).drawMarker(g, x += this.SEPARATION, y);
                ++i;
            }
        }
    }
}

