/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class PlotBox
extends JPanel
implements Printable {
    public static final String PTPLOT_RELEASE = "5.2";
    protected transient double _yMax = 0.0;
    protected transient double _yMin = 0.0;
    protected transient double _xMax = 0.0;
    protected transient double _xMin = 0.0;
    protected double _padding = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected transient boolean _rangesGivenByZooming = false;
    protected double _xlowgiven;
    protected double _xhighgiven;
    protected double _ylowgiven;
    protected double _yhighgiven;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected boolean _xflip = false;
    protected boolean _yflip = false;
    protected static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    protected boolean _grid = true;
    protected boolean _wrap = false;
    protected double _wrapHigh;
    protected double _wrapLow;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    protected static Color[] _colors = new Color[]{new Color(0xFF0000), new Color(255), new Color(43690), new Color(0), new Color(16753920), new Color(5473931), new Color(16744272), new Color(4565791), new Color(9454125), new Color(0xA0A0A0), new Color(0x14FF14)};
    protected int _width = 500;
    protected int _height = 300;
    protected int _preferredWidth = 500;
    protected int _preferredHeight = 300;
    protected boolean _sizeHasBeenSet = false;
    public URL _documentBase = null;
    private boolean _actionsDeferred = false;
    private List _deferredActions;
    private String _filespec = null;
    private static final Color _boxColor = Color.orange;
    private double _ytickMax = 0.0;
    private double _ytickMin = 0.0;
    private double _xtickMax = 0.0;
    private double _xtickMin = 0.0;
    private int _yExp = 0;
    private int _xExp = 0;
    private double _ytickscale = 0.0;
    private double _xtickscale = 0.0;
    private Font _labelFont = null;
    private Font _superscriptFont = null;
    private Font _titleFont = null;
    private FontMetrics _labelFontMetrics = null;
    private FontMetrics _superscriptFontMetrics = null;
    private FontMetrics _titleFontMetrics = null;
    private transient int _gridCurJuke = 0;
    private transient double _gridBase = 0.0;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _xticks = null;
    private Vector _xticklabels = null;
    private Vector _yticks = null;
    private Vector _yticklabels = null;
    private transient JButton _fillButton = null;
    private transient JButton _formatButton = null;
    boolean _originalXRangeGiven = false;
    boolean _originalYRangeGiven = false;
    double _originalXlow = 0.0;
    double _originalXhigh = 0.0;
    double _originalYlow = 0.0;
    double _originalYhigh = 0.0;
    private transient JButton _printButton = null;
    private transient JButton _resetButton = null;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    private transient boolean _zooming = false;

    public PlotBox() {
        this.setOpaque(true);
        this.setLayout(new FlowLayout(2, 2, 2));
        this.addMouseListener(new ZoomListener());
        this.addMouseMotionListener(new DragListener());
        this._measureFonts();
    }

    public synchronized void addLegend(int dataset, String legend) {
        if (legend == null || legend.equals("")) {
            return;
        }
        this._legendStrings.addElement(legend);
        this._legendDatasets.addElement(new Integer(dataset));
    }

    public synchronized void addXTick(String label, double position) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(new Double(position));
        this._xticklabels.addElement(label);
    }

    public synchronized void addYTick(String label, double position) {
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(new Double(position));
        this._yticklabels.addElement(label);
    }

    public synchronized void clear(boolean axes) {
        this._xBottom = Double.MAX_VALUE;
        this._xTop = -1.7976931348623157E308;
        this._yBottom = Double.MAX_VALUE;
        this._yTop = -1.7976931348623157E308;
        if (axes) {
            this._yMax = 0.0;
            this._yMin = 0.0;
            this._xMax = 0.0;
            this._xMin = 0.0;
            this._xRangeGiven = false;
            this._yRangeGiven = false;
            this._originalXRangeGiven = false;
            this._originalYRangeGiven = false;
            this._rangesGivenByZooming = false;
            this._xlog = false;
            this._ylog = false;
            this._grid = true;
            this._wrap = false;
            this._usecolor = true;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            this._xticks = null;
            this._xticklabels = null;
            this._yticks = null;
            this._yticklabels = null;
        }
    }

    public synchronized void clearLegends() {
        this._legendStrings = new Vector();
        this._legendDatasets = new Vector();
    }

    public void deferIfNecessary(Runnable action) {
        if (EventQueue.isDispatchThread()) {
            action.run();
        } else {
            if (this._deferredActions == null) {
                this._deferredActions = new LinkedList();
            }
            this._deferredActions.add(action);
            if (!this._actionsDeferred) {
                Runnable doActions = new Runnable(){

                    public void run() {
                        PlotBox.this._executeDeferredActions();
                    }
                };
                try {
                    SwingUtilities.invokeLater(doActions);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this._actionsDeferred = true;
            }
        }
    }

    public synchronized void fillPlot() {
        this.setXRange(this._xBottom, this._xTop);
        this.setYRange(this._yBottom, this._yTop);
        this.repaint();
    }

    public boolean getColor() {
        return this._usecolor;
    }

    /*
     * Unable to fully structure code
     */
    public static Color getColorByName(String name) {
        try {
            if (name.startsWith("#")) {
                name = name.substring(1);
            }
            col = new Color(Integer.parseInt(name, 16));
            return col;
        }
        catch (NumberFormatException e) {
            names = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}};
            i = 0;
            ** while (i < names.length)
        }
lbl-1000:
        // 1 sources

        {
            if (name.equals(names[i][0])) {
                try {
                    col = new Color(Integer.parseInt(names[i][1], 16));
                    return col;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            ++i;
            continue;
        }
lbl18:
        // 1 sources

        return null;
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public synchronized String getLegend(int dataset) {
        int idx = this._legendDatasets.indexOf(new Integer(dataset), 0);
        if (idx != -1) {
            return (String)this._legendStrings.elementAt(idx);
        }
        return null;
    }

    public synchronized Dimension getMaximumSize() {
        if (this._sizeHasBeenSet) {
            return new Dimension(this._preferredWidth, this._preferredHeight);
        }
        return super.getMaximumSize();
    }

    public synchronized Dimension getMinimumSize() {
        if (this._sizeHasBeenSet) {
            return new Dimension(this._preferredWidth, this._preferredHeight);
        }
        return super.getMinimumSize();
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this._preferredWidth, this._preferredHeight);
    }

    public synchronized String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public synchronized String getXLabel() {
        return this._xlabel;
    }

    public boolean getXLog() {
        return this._xlog;
    }

    public synchronized double[] getXRange() {
        double[] result = new double[2];
        if (this._xRangeGiven) {
            result[0] = this._xlowgiven;
            result[1] = this._xhighgiven;
        } else {
            result[0] = this._xMin + (this._xMax - this._xMin) * this._padding;
            result[1] = this._xMax - (this._xMax - this._xMin) * this._padding;
        }
        return result;
    }

    public synchronized Vector[] getXTicks() {
        if (this._xticks == null) {
            return null;
        }
        Vector[] result = new Vector[]{this._xticks, this._xticklabels};
        return result;
    }

    public String getYLabel() {
        return this._ylabel;
    }

    public boolean getYLog() {
        return this._ylog;
    }

    public synchronized double[] getYRange() {
        double[] result = new double[2];
        if (this._yRangeGiven) {
            result[0] = this._ylowgiven;
            result[1] = this._yhighgiven;
        } else {
            result[0] = this._yMin + (this._yMax - this._yMin) * this._padding;
            result[1] = this._yMax - (this._yMax - this._yMin) * this._padding;
        }
        return result;
    }

    public synchronized Vector[] getYTicks() {
        if (this._yticks == null) {
            return null;
        }
        Vector[] result = new Vector[]{this._yticks, this._yticklabels};
        return result;
    }

    public void init() {
        this.setButtons(true);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this._drawPlot(graphics, true);
    }

    public synchronized int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        if (graphics == null) {
            return 1;
        }
        if (index >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double scalex = format.getImageableWidth() / (double)this.getWidth();
        double scaley = format.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(scalex, scaley);
        graphics2D.translate((int)format.getImageableX(), (int)format.getImageableY());
        graphics2D.scale(scale, scale);
        this._drawPlot(graphics, true);
        return 0;
    }

    public synchronized void removeLegend(int dataset) {
        int len = this._legendDatasets.size();
        int foundIndex = -1;
        boolean found = false;
        int i = 0;
        while (i < len && !found) {
            if ((Integer)this._legendDatasets.get(i) == dataset) {
                foundIndex = i;
                found = true;
            }
            ++i;
        }
        if (found) {
            this._legendDatasets.remove(foundIndex);
            this._legendStrings.remove(foundIndex);
        }
    }

    public synchronized void resetAxes() {
        this.setXRange(this._originalXlow, this._originalXhigh);
        this.setYRange(this._originalYlow, this._originalYhigh);
        this.repaint();
    }

    public void samplePlot() {
    }

    public void setBackground(Color background) {
        this._background = background;
        super.setBackground(this._background);
    }

    public synchronized void setBounds(int x, int y, int width, int height) {
        this._width = width;
        this._height = height;
        super.setBounds(x, y, this._width, this._height);
    }

    public synchronized void setButtons(boolean visible) {
        URL img;
        if (this._printButton == null) {
            img = this.getClass().getResource("/ptolemy/plot/img/print.gif");
            if (img != null) {
                ImageIcon printIcon = new ImageIcon(img);
                this._printButton = new JButton(printIcon);
                this._printButton.setBorderPainted(false);
            } else {
                this._printButton = new JButton("P");
            }
            this._printButton.setPreferredSize(new Dimension(20, 20));
            this._printButton.setToolTipText("Print the plot.");
            this._printButton.addActionListener(new ButtonListener());
            this.add(this._printButton);
        }
        this._printButton.setVisible(visible);
        if (this._resetButton == null) {
            img = this.getClass().getResource("/ptolemy/plot/img/reset.gif");
            if (img != null) {
                ImageIcon resetIcon = new ImageIcon(img);
                this._resetButton = new JButton(resetIcon);
                this._resetButton.setBorderPainted(false);
            } else {
                this._resetButton = new JButton("R");
            }
            this._resetButton.setPreferredSize(new Dimension(20, 20));
            this._resetButton.setToolTipText("Reset X and Y ranges to their original values");
            this._resetButton.addActionListener(new ButtonListener());
            this.add(this._resetButton);
        }
        this._resetButton.setVisible(visible);
        if (this._formatButton == null) {
            img = this.getClass().getResource("/ptolemy/plot/img/format.gif");
            if (img != null) {
                ImageIcon formatIcon = new ImageIcon(img);
                this._formatButton = new JButton(formatIcon);
                this._formatButton.setBorderPainted(false);
            } else {
                this._formatButton = new JButton("S");
            }
            this._formatButton.setPreferredSize(new Dimension(20, 20));
            this._formatButton.setToolTipText("Set the plot format");
            this._formatButton.addActionListener(new ButtonListener());
            this.add(this._formatButton);
        }
        this._formatButton.setVisible(visible);
        if (this._fillButton == null) {
            img = this.getClass().getResource("/ptolemy/plot/img/fill.gif");
            if (img != null) {
                ImageIcon fillIcon = new ImageIcon(img);
                this._fillButton = new JButton(fillIcon);
                this._fillButton.setBorderPainted(false);
            } else {
                this._fillButton = new JButton("F");
            }
            this._fillButton.setPreferredSize(new Dimension(20, 20));
            this._fillButton.setToolTipText("Rescale the plot to fit the data");
            this._fillButton.addActionListener(new ButtonListener());
            this.add(this._fillButton);
        }
        this._fillButton.setVisible(visible);
    }

    public void setColor(boolean useColor) {
        this._usecolor = useColor;
    }

    public void setDataurl(String filespec) {
        this._filespec = filespec;
    }

    public void setDocumentBase(URL documentBase) {
        this._documentBase = documentBase;
    }

    public void setForeground(Color foreground) {
        this._foreground = foreground;
        super.setForeground(this._foreground);
    }

    public void setGrid(boolean grid) {
        this._grid = grid;
    }

    public void setLabelFont(String name) {
        this._labelFont = Font.decode(name);
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
        this._preferredWidth = width;
        this._preferredHeight = height;
        this._sizeHasBeenSet = true;
        super.setSize(width, height);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setTitleFont(String name) {
        this._titleFont = Font.decode(name);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    public void setWrap(boolean wrap) {
        this._wrap = wrap;
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this.setXRange(0.0, 0.0);
            } else {
                this.setXRange(this._xBottom, this._xTop);
            }
        }
        this._wrapLow = this._xlowgiven;
        this._wrapHigh = this._xhighgiven;
    }

    public void setXLabel(String label) {
        this._xlabel = label;
    }

    public void setXLog(boolean xlog) {
        this._xlog = xlog;
    }

    public void setXFlip(boolean xflip) {
        this._xflip = xflip;
    }

    public synchronized void setXRange(double min, double max) {
        this._xRangeGiven = true;
        this._xlowgiven = min;
        this._xhighgiven = max;
        if (!this._originalXRangeGiven) {
            this._originalXlow = min;
            this._originalXhigh = max;
            this._originalXRangeGiven = true;
        }
        this._setXRange(min, max);
    }

    public void setYLabel(String label) {
        this._ylabel = label;
    }

    public void setYLog(boolean ylog) {
        this._ylog = ylog;
    }

    public void setYFlip(boolean yflip) {
        this._yflip = yflip;
    }

    public synchronized void setYRange(double min, double max) {
        this._yRangeGiven = true;
        this._ylowgiven = min;
        this._yhighgiven = max;
        if (!this._originalYRangeGiven) {
            this._originalYlow = min;
            this._originalYhigh = max;
            this._originalYRangeGiven = true;
        }
        this._setYRange(min, max);
    }

    public synchronized void zoom(double lowx, double lowy, double highx, double highy) {
        this._setXRange(lowx, highx);
        this._setYRange(lowy, highy);
        this.repaint();
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst) {
        Rectangle bounds = this.getBounds();
        this._drawPlot(graphics, clearfirst, bounds);
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst, Rectangle drawRect) {
        Font previousFont;
        if (drawRect.height == 0) {
            return;
        }
        if (graphics != null) {
            graphics.setPaintMode();
        }
        if (graphics != null && this._errorMsg != null) {
            int fheight;
            int msgy = fheight = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            int i = 0;
            while (i < this._errorMsg.length) {
                graphics.drawString(this._errorMsg[i], 10, msgy);
                msgy += fheight;
                System.err.println(this._errorMsg[i]);
                ++i;
            }
            return;
        }
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 0.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 0.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        int titley = 0;
        int titlefontheight = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            titley = titlefontheight + this._topPadding;
        }
        Font font = previousFont = graphics != null ? graphics.getFont() : null;
        if (graphics != null) {
            graphics.setFont(this._labelFont);
            graphics.setColor(this._foreground);
        }
        int labelheight = this._labelFontMetrics.getHeight();
        int halflabelheight = labelheight / 2;
        int ySPos = drawRect.height - 5;
        int xSPos = drawRect.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String superscript = Integer.toString(this._xExp);
            xSPos -= this._superscriptFontMetrics.stringWidth(superscript);
            if (graphics != null) {
                graphics.setFont(this._superscriptFont);
            }
            if (!this._xlog) {
                if (graphics != null) {
                    graphics.drawString(superscript, xSPos, ySPos - halflabelheight);
                }
                xSPos -= this._labelFontMetrics.stringWidth("x10");
                if (graphics != null) {
                    graphics.setFont(this._labelFont);
                    graphics.drawString("x10", xSPos, ySPos);
                }
            }
            this._bottomPadding = 3 * labelheight / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < labelheight + 5) {
            this._bottomPadding = labelheight + 5;
        }
        this._uly = titley + 5;
        this._lry = drawRect.height - labelheight - this._bottomPadding - 3;
        int height = this._lry - this._uly;
        this._yscale = (double)height / (this._yMax - this._yMin);
        this._ytickscale = (double)height / (this._ytickMax - this._ytickMin);
        int ny = 2 + height / (labelheight + 10);
        double yStep = this._roundUp((this._ytickMax - this._ytickMin) / (double)ny);
        double yStart = yStep * Math.ceil(this._ytickMin / yStep);
        int widesty = 0;
        String[] ylabels = new String[ny];
        int[] ylabwidth = new int[ny];
        int ind = 0;
        if (this._yticks == null) {
            Vector ygrid = null;
            if (this._ylog) {
                ygrid = this._gridInit(yStart, yStep, true, null);
            }
            int numfracdigits = this._numFracDigits(yStep);
            double yTmpStart = yStart;
            if (this._ylog) {
                yTmpStart = this._gridStep(ygrid, yStart, yStep, this._ylog);
            }
            double yFlipSgn = this._yflip ? -1.0 : 1.0;
            double ypos = yTmpStart;
            while (ypos <= this._ytickMax) {
                if (ind < ny) {
                    String yticklabel = this._ylog ? this._formatLogNum(yFlipSgn * ypos, numfracdigits) : this._formatNum(yFlipSgn * ypos, numfracdigits);
                    ylabels[ind] = yticklabel;
                    int lw = this._labelFontMetrics.stringWidth(yticklabel);
                    ylabwidth[ind++] = lw;
                    if (lw > widesty) {
                        widesty = lw;
                    }
                    ypos = this._gridStep(ygrid, ypos, yStep, this._ylog);
                    continue;
                }
                break;
            }
        } else {
            Enumeration nl = this._yticklabels.elements();
            while (nl.hasMoreElements()) {
                String label = (String)nl.nextElement();
                int lw = this._labelFontMetrics.stringWidth(label);
                if (lw <= widesty) continue;
                widesty = lw;
            }
        }
        this._ulx = this._ylabel != null ? widesty + this._labelFontMetrics.stringWidth("W") + this._leftPadding : widesty + this._leftPadding;
        int legendwidth = this._drawLegend(graphics, drawRect.width - this._rightPadding, this._uly);
        this._lrx = drawRect.width - legendwidth - this._rightPadding;
        int width = this._lrx - this._ulx;
        this._xscale = (double)width / (this._xMax - this._xMin);
        this._xtickscale = (double)width / (this._xtickMax - this._xtickMin);
        if (graphics != null) {
            graphics.setColor(Color.white);
            graphics.fillRect(this._ulx, this._uly, width, height);
            graphics.setColor(this._foreground);
            graphics.drawRect(this._ulx, this._uly, width, height);
        }
        int tickLength = 5;
        int xCoord1 = this._ulx + tickLength;
        int xCoord2 = this._lrx - tickLength;
        if (this._yticks == null) {
            Vector ygrid = null;
            double yTmpStart = yStart;
            if (this._ylog) {
                ygrid = this._gridInit(yStart, yStep, true, null);
                yTmpStart = this._gridStep(ygrid, yStart, yStep, this._ylog);
                ny = ind;
            }
            ind = 0;
            boolean needExponent = this._ylog;
            double ypos = yTmpStart;
            while (ypos <= this._ytickMax) {
                if (ind >= ny) break;
                int yCoord1 = this._lry - (int)((ypos - this._ytickMin) * this._ytickscale);
                int offset = 0;
                if (ind > 0 && !this._ylog) {
                    offset = halflabelheight;
                }
                if (graphics != null) {
                    graphics.drawLine(this._ulx, yCoord1, xCoord1, yCoord1);
                    graphics.drawLine(this._lrx, yCoord1, xCoord2, yCoord1);
                    if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                        graphics.setColor(Color.lightGray);
                        graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                        graphics.setColor(this._foreground);
                    }
                }
                if (this._ylog && ylabels[ind].indexOf(101) != -1) {
                    needExponent = false;
                }
                if (graphics != null) {
                    graphics.drawString(ylabels[ind], this._ulx - ylabwidth[ind] - 4, yCoord1 + offset);
                }
                ++ind;
                ypos = this._gridStep(ygrid, ypos, yStep, this._ylog);
            }
            if (this._ylog) {
                Vector unlabeledgrid = this._gridInit(yStart, yStep, false, ygrid);
                if (unlabeledgrid.size() > 0) {
                    double tmpStep = yStep > 1.0 ? 1.0 : yStep;
                    double ypos2 = this._gridStep(unlabeledgrid, yStart, tmpStep, this._ylog);
                    while (ypos2 <= this._ytickMax) {
                        int yCoord1 = this._lry - (int)((ypos2 - this._ytickMin) * this._ytickscale);
                        if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry && graphics != null) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(this._ulx + 1, yCoord1, this._lrx - 1, yCoord1);
                            graphics.setColor(this._foreground);
                        }
                        ypos2 = this._gridStep(unlabeledgrid, ypos2, tmpStep, this._ylog);
                    }
                }
                this._yExp = needExponent ? (int)Math.floor(yTmpStart) : 0;
            }
            if (graphics != null && this._yExp != 0) {
                graphics.drawString("x10", 2, titley);
                graphics.setFont(this._superscriptFont);
                graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 2, titley - halflabelheight);
                graphics.setFont(this._labelFont);
            }
        } else {
            Enumeration nt = this._yticks.elements();
            Enumeration nl = this._yticklabels.elements();
            while (nl.hasMoreElements()) {
                String label = (String)nl.nextElement();
                double ypos = (Double)nt.nextElement();
                if (ypos > this._yMax || ypos < this._yMin) continue;
                int yCoord1 = this._lry - (int)((ypos - this._yMin) * this._yscale);
                int offset = 0;
                if (ypos < (double)(this._lry - labelheight)) {
                    offset = halflabelheight;
                }
                if (graphics == null) continue;
                graphics.drawLine(this._ulx, yCoord1, xCoord1, yCoord1);
                graphics.drawLine(this._lrx, yCoord1, xCoord2, yCoord1);
                if (this._grid && yCoord1 != this._uly && yCoord1 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(xCoord1, yCoord1, xCoord2, yCoord1);
                    graphics.setColor(this._foreground);
                }
                graphics.drawString(label, this._ulx - this._labelFontMetrics.stringWidth(label) - 3, yCoord1 + offset);
            }
        }
        int yCoord1 = this._uly + tickLength;
        int yCoord2 = this._lry - tickLength;
        int charwidth = this._labelFontMetrics.stringWidth("8");
        if (this._xticks == null) {
            int nx = 10;
            double xStep = 0.0;
            int numfracdigits = 0;
            if (this._xlog) {
                nx = 2 + width / (charwidth * 6 + 10);
            } else {
                int count = 0;
                while (count++ <= 10) {
                    int savenx;
                    int maxlabelwidth;
                    int inttemp;
                    xStep = this._roundUp((this._xtickMax - this._xtickMin) / (double)nx);
                    numfracdigits = this._numFracDigits(xStep);
                    int intdigits = this._numIntDigits(this._xtickMax);
                    if (intdigits < (inttemp = this._numIntDigits(this._xtickMin))) {
                        intdigits = inttemp;
                    }
                    if ((nx = 2 + width / ((maxlabelwidth = charwidth * (numfracdigits + 2 + intdigits)) + 10)) - (savenx = nx) <= 1 || savenx - nx <= 1) break;
                }
            }
            xStep = this._roundUp((this._xtickMax - this._xtickMin) / (double)nx);
            numfracdigits = this._numFracDigits(xStep);
            double xStart = xStep * Math.ceil(this._xtickMin / xStep);
            Vector xgrid = null;
            double xTmpStart = xStart;
            if (this._xlog) {
                xgrid = this._gridInit(xStart, xStep, true, null);
                xTmpStart = this._gridRoundUp(xgrid, xStart);
            }
            boolean needExponent = this._xlog;
            double xFlipSgn = this._xflip ? -1.0 : 1.0;
            double xpos = xTmpStart;
            while (xpos <= this._xtickMax) {
                String xticklabel;
                if (this._xlog) {
                    xticklabel = this._formatLogNum(xFlipSgn * xpos, numfracdigits);
                    if (xticklabel.indexOf(101) != -1) {
                        needExponent = false;
                    }
                } else {
                    xticklabel = this._formatNum(xFlipSgn * xpos, numfracdigits);
                }
                xCoord1 = this._ulx + (int)((xpos - this._xtickMin) * this._xtickscale);
                if (graphics != null) {
                    graphics.drawLine(xCoord1, this._uly, xCoord1, yCoord1);
                    graphics.drawLine(xCoord1, this._lry, xCoord1, yCoord2);
                    if (this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                        graphics.setColor(Color.lightGray);
                        graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                        graphics.setColor(this._foreground);
                    }
                    int labxpos = xCoord1 - this._labelFontMetrics.stringWidth(xticklabel) / 2;
                    graphics.drawString(xticklabel, labxpos, this._lry + 3 + labelheight);
                }
                xpos = this._gridStep(xgrid, xpos, xStep, this._xlog);
            }
            if (this._xlog) {
                double tmpStep = xStep > 1.0 ? 1.0 : xStep;
                xTmpStart = tmpStep * Math.ceil(this._xtickMin / tmpStep);
                Vector unlabeledgrid = this._gridInit(xTmpStart, tmpStep, false, xgrid);
                if (unlabeledgrid.size() > 0) {
                    double xpos2 = this._gridStep(unlabeledgrid, xTmpStart, tmpStep, this._xlog);
                    while (xpos2 <= this._xtickMax) {
                        xCoord1 = this._ulx + (int)((xpos2 - this._xtickMin) * this._xtickscale);
                        if (graphics != null && this._grid && xCoord1 != this._ulx && xCoord1 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(xCoord1, this._uly + 1, xCoord1, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        xpos2 = this._gridStep(unlabeledgrid, xpos2, tmpStep, this._xlog);
                    }
                }
                if (needExponent) {
                    this._xExp = (int)Math.floor(xTmpStart);
                    if (graphics != null) {
                        graphics.setFont(this._superscriptFont);
                        graphics.drawString(Integer.toString(this._xExp), xSPos, ySPos - halflabelheight);
                    }
                    xSPos -= this._labelFontMetrics.stringWidth("x10");
                    if (graphics != null) {
                        graphics.setFont(this._labelFont);
                        graphics.drawString("x10", xSPos, ySPos);
                    }
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration nt = this._xticks.elements();
            Enumeration nl = this._xticklabels.elements();
            double preLength = 0.0;
            while (nl.hasMoreElements()) {
                int labxpos;
                String label = (String)nl.nextElement();
                double xpos = (Double)nt.nextElement();
                if (xpos > this._xMax || xpos < this._xMin || !((double)(labxpos = (xCoord1 = this._ulx + (int)((xpos - this._xMin) * this._xscale)) - this._labelFontMetrics.stringWidth(label) / 2) > preLength)) continue;
                preLength = xCoord1 + this._labelFontMetrics.stringWidth(label) / 2 + 10;
                if (graphics == null) continue;
                graphics.drawString(label, labxpos, this._lry + 3 + labelheight);
                graphics.drawLine(xCoord1, this._uly, xCoord1, yCoord1);
                graphics.drawLine(xCoord1, this._lry, xCoord1, yCoord2);
                if (!this._grid || xCoord1 == this._ulx || xCoord1 == this._lrx) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(xCoord1, yCoord1, xCoord1, yCoord2);
                graphics.setColor(this._foreground);
            }
        }
        if (graphics != null) {
            graphics.setColor(this._foreground);
            if (this._title != null) {
                graphics.setFont(this._titleFont);
                int titlex = this._ulx + (width - this._titleFontMetrics.stringWidth(this._title)) / 2;
                graphics.drawString(this._title, titlex, titley);
            }
            graphics.setFont(this._labelFont);
            if (this._xlabel != null) {
                int labelx = this._ulx + (width - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
                graphics.drawString(this._xlabel, labelx, ySPos);
            }
        }
        if (graphics != null) {
            int charcenter = 2 + this._labelFontMetrics.stringWidth("W") / 2;
            if (this._ylabel != null) {
                int starty;
                int yl = this._ylabel.length();
                if (graphics instanceof Graphics2D) {
                    starty = this._uly + (this._lry - this._uly) / 2 + this._labelFontMetrics.stringWidth(this._ylabel) / 2 - charwidth;
                    Graphics2D g2d = (Graphics2D)graphics;
                    int startx = charcenter + halflabelheight - 2;
                    g2d.rotate(Math.toRadians(-90.0), startx, starty);
                    g2d.drawString(this._ylabel, startx, starty);
                    g2d.rotate(Math.toRadians(90.0), startx, starty);
                } else {
                    starty = this._uly + (this._lry - this._uly) / 2 - yl * halflabelheight + labelheight;
                    int i = 0;
                    while (i < yl) {
                        String nchar = this._ylabel.substring(i, i + 1);
                        int cwidth = this._labelFontMetrics.stringWidth(nchar);
                        graphics.drawString(nchar, charcenter - cwidth / 2, starty);
                        starty += labelheight;
                        ++i;
                    }
                }
            }
            graphics.setFont(previousFont);
        }
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        boolean pointinside;
        if (graphics == null) {
            return;
        }
        boolean bl = pointinside = ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx;
        if (!pointinside && clip) {
            return;
        }
        graphics.fillRect((int)xpos - 6, (int)ypos - 6, 6, 6);
    }

    protected void _help() {
        String message = "Ptolemy plot package\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.2, Build: $Id: PlotBox.java,v 1.4 2004/10/14 16:21:15 mbt Exp $\n\nKey bindings:\n   Cntrl-c:  copy plot to clipboard (EPS format), if permitted\n   D: dump plot data to standard out\n   E: export plot to standard out (EPS format)\n   F: fill plot\n   H or ?: print help message (this message)\n   Cntrl-D or Q: quit\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n";
        JOptionPane.showMessageDialog(this, message, "Ptolemy Plot Help Window", 1);
    }

    protected void _setButtonsVisibility(boolean vis) {
        this._printButton.setVisible(vis);
        this._fillButton.setVisible(vis);
        this._formatButton.setVisible(vis);
        this._resetButton.setVisible(vis);
    }

    protected void _setPadding(double padding) {
        this._padding = padding;
    }

    private int _drawLegend(Graphics graphics, int urx, int ury) {
        Font previousFont;
        Font font = previousFont = graphics == null ? null : graphics.getFont();
        if (graphics != null) {
            graphics.setFont(this._labelFont);
        }
        int spacing = this._labelFontMetrics.getHeight();
        Enumeration v = this._legendStrings.elements();
        Enumeration i = this._legendDatasets.elements();
        int ypos = ury + spacing;
        int maxwidth = 0;
        while (v.hasMoreElements()) {
            int width;
            String legend = (String)v.nextElement();
            int dataset = (Integer)i.nextElement();
            if (dataset < 0) continue;
            if (this._usecolor) {
                int color = dataset % _colors.length;
                if (graphics != null) {
                    graphics.setColor(_colors[color]);
                }
            }
            if (graphics != null) {
                this._drawPoint(graphics, dataset, urx - 3, ypos - 3, false);
            }
            if (graphics != null) {
                graphics.setColor(this._foreground);
            }
            if ((width = this._labelFontMetrics.stringWidth(legend)) > maxwidth) {
                maxwidth = width;
            }
            if (graphics != null) {
                graphics.drawString(legend, urx - 15 - width, ypos);
            }
            ypos += spacing;
        }
        if (graphics != null) {
            graphics.setFont(previousFont);
        }
        return Math.max(64, 22 + maxwidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _executeDeferredActions() {
        try {
            Iterator actions = this._deferredActions.iterator();
            while (actions.hasNext()) {
                Runnable action = (Runnable)actions.next();
                action.run();
            }
            Object var4_3 = null;
            this._actionsDeferred = false;
            this._deferredActions.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._actionsDeferred = false;
            this._deferredActions.clear();
            throw throwable;
        }
    }

    private String _formatLogNum(double num, int numfracdigits) {
        int exponent = (int)num;
        String results = exponent >= 0 && exponent < 10 ? "0" + exponent : (exponent < 0 && exponent > -10 ? "-0" + -exponent : Integer.toString(exponent));
        results = num >= 0.0 ? (num - (double)((int)num) < 0.001 ? "1e" + results : this._formatNum(Math.pow(10.0, num - (double)((int)num)), numfracdigits)) : (-num - (double)((int)(-num)) < 0.001 ? "1e" + results : this._formatNum(Math.pow(10.0, num - (double)((int)num)) * 10.0, numfracdigits));
        return results;
    }

    private String _formatNum(double num, int numfracdigits) {
        double fudge = 0.5;
        if (num < 0.0) {
            fudge = -0.5;
        }
        String numString = Double.toString(num + fudge * Math.pow(10.0, -numfracdigits));
        int dpt = numString.lastIndexOf(".");
        StringBuffer result = new StringBuffer();
        if (dpt < 0) {
            if (numfracdigits <= 0) {
                result.append(numString);
                return result.toString();
            }
            result.append(".");
            int i = 0;
            while (i < numfracdigits) {
                result.append("0");
                ++i;
            }
            return result.toString();
        }
        int shortby = numfracdigits - (numString.length() - dpt - 1);
        if (shortby <= 0) {
            int numtocopy = dpt + numfracdigits + 1;
            if (numfracdigits == 0) {
                --numtocopy;
            }
            result.append(numString.substring(0, numtocopy));
            return result.toString();
        }
        result.append(numString);
        int i = 0;
        while (i < shortby) {
            result.append("0");
            ++i;
        }
        return result.toString();
    }

    private Vector _gridInit(double low, double step, boolean labeled, Vector oldgrid) {
        Vector<Double> grid = new Vector<Double>(10);
        double ratio = Math.pow(10.0, step);
        int ngrid = 1;
        if (labeled) {
            if (ratio <= 3.5) {
                ngrid = ratio > 2.0 ? 2 : (ratio > 1.26 ? 5 : (ratio > 1.125 ? 10 : (int)Math.rint(1.0 / step)));
            }
        } else {
            ngrid = ratio > 10.0 ? 1 : (ratio > 3.0 ? 2 : (ratio > 2.0 ? 5 : (ratio > 1.125 ? 10 : 100)));
        }
        int oldgridi = 0;
        int i = 0;
        while (i < ngrid) {
            double gridval = (double)i * 1.0 / (double)ngrid * 10.0;
            double logval = _LOG10SCALE * Math.log(gridval);
            if (logval == Double.NEGATIVE_INFINITY) {
                logval = 0.0;
            }
            if (oldgrid != null && oldgridi < oldgrid.size()) {
                while (oldgridi < oldgrid.size() && (Double)oldgrid.elementAt(oldgridi) < logval) {
                    ++oldgridi;
                }
                if (oldgridi < oldgrid.size()) {
                    if (Math.abs((Double)oldgrid.elementAt(oldgridi) - logval) > 1.0E-5) {
                        grid.addElement(new Double(logval));
                    }
                } else {
                    grid.addElement(new Double(logval));
                }
            } else {
                grid.addElement(new Double(logval));
            }
            ++i;
        }
        this._gridCurJuke = 0;
        if (low == -0.0) {
            low = 0.0;
        }
        this._gridBase = Math.floor(low);
        double x = low - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < grid.size() && x >= (Double)grid.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return grid;
    }

    private double _gridRoundUp(Vector grid, double pos) {
        double x = pos - Math.floor(pos);
        int i = 0;
        while (i < grid.size() && x >= (Double)grid.elementAt(i)) {
            ++i;
        }
        if (i >= grid.size()) {
            return pos;
        }
        return Math.floor(pos) + (Double)grid.elementAt(i);
    }

    private double _gridStep(Vector grid, double pos, double step, boolean logflag) {
        if (logflag) {
            if (++this._gridCurJuke >= grid.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(step);
            }
            if (this._gridCurJuke >= grid.size()) {
                return pos + step;
            }
            return this._gridBase + (Double)grid.elementAt(this._gridCurJuke);
        }
        return pos + step;
    }

    private void _measureFonts() {
        if (this._labelFont == null) {
            this._labelFont = new Font("Helvetica", 0, 12);
        }
        if (this._superscriptFont == null) {
            this._superscriptFont = new Font("Helvetica", 0, 9);
        }
        if (this._titleFont == null) {
            this._titleFont = new Font("Helvetica", 1, 14);
        }
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
        this._superscriptFontMetrics = this.getFontMetrics(this._superscriptFont);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    private int _numFracDigits(double num) {
        int numdigits = 0;
        while (numdigits <= 15 && num != Math.floor(num)) {
            num *= 10.0;
            ++numdigits;
        }
        return numdigits;
    }

    private int _numIntDigits(double num) {
        int numdigits = 0;
        while (numdigits <= 15 && (double)((int)num) != 0.0) {
            num /= 10.0;
            ++numdigits;
        }
        return numdigits;
    }

    private double _roundUp(double val) {
        int exponent;
        if ((val *= Math.pow(10.0, -(exponent = (int)Math.floor(Math.log(val) * _LOG10SCALE)))) > 5.0) {
            val = 10.0;
        } else if (val > 2.0) {
            val = 5.0;
        } else if (val > 1.0) {
            val = 2.0;
        }
        return val *= Math.pow(10.0, exponent);
    }

    private void _setXRange(double min, double max) {
        if (min > max) {
            min = -1.0;
            max = 1.0;
        } else if (min == max) {
            min -= 1.0;
            max += 1.0;
        }
        this._xMin = min - (max - min) * this._padding;
        this._xMax = max + (max - min) * this._padding;
        double largest = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(largest) * _LOG10SCALE);
        if (this._xExp > 1 || this._xExp < -1) {
            double xs = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * xs;
            this._xtickMax = this._xMax * xs;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    private void _setYRange(double min, double max) {
        if (min > max) {
            min = -1.0;
            max = 1.0;
        } else if (min == max) {
            min -= 0.1;
            max += 0.1;
        }
        this._yMin = min - (max - min) * this._padding;
        this._yMax = max + (max - min) * this._padding;
        double largest = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(largest) * _LOG10SCALE);
        if (this._yExp > 1 || this._yExp < -1) {
            double ys = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * ys;
            this._ytickMax = this._yMax * ys;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    protected void _zoom(int x, int y) {
        this._zooming = false;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        boolean handled = false;
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int minx = Math.min(this._zoomx, this._zoomxn);
                int maxx = Math.max(this._zoomx, this._zoomxn);
                int miny = Math.min(this._zoomy, this._zoomyn);
                int maxy = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(_boxColor);
                graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                graphics.setPaintMode();
                if (y > this._lry) {
                    y = this._lry;
                }
                if (y < this._uly) {
                    y = this._uly;
                }
                if (x > this._lrx) {
                    x = this._lrx;
                }
                if (x < this._ulx) {
                    x = this._ulx;
                }
                if (Math.abs(this._zoomx - x) > 5 && Math.abs(this._zoomy - y) > 5) {
                    double a = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double b = this._xMin + (double)(x - this._ulx) / this._xscale;
                    if (a < b) {
                        this.setXRange(a, b);
                    } else {
                        this.setXRange(b, a);
                    }
                    a = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                    b = this._yMax - (double)(y - this._uly) / this._yscale;
                    if (a < b) {
                        this.setYRange(a, b);
                    } else {
                        this.setYRange(b, a);
                    }
                }
                this.repaint();
                handled = true;
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(_boxColor);
            int x_diff = Math.abs(this._zoomx - this._zoomxn);
            int y_diff = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
            graphics.setPaintMode();
            double a = (double)Math.abs(this._zoomx - x) / 30.0;
            double b = (double)Math.abs(this._zoomy - y) / 30.0;
            double newx1 = this._xMax + (this._xMax - this._xMin) * a;
            double newx2 = this._xMin - (this._xMax - this._xMin) * a;
            double newy1 = this._yMax + (this._yMax - this._yMin) * b;
            double newy2 = this._yMin - (this._yMax - this._yMin) * b;
            this.zoom(newx2, newy2, newx1, newy1);
            handled = true;
        } else if (!this._drawn) {
            this.repaint();
            handled = true;
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    void _zoomBox(int x, int y) {
        if (!this._zooming) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (y < this._zoomy) {
                    this._zoomout = true;
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (y > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int maxy;
                int miny;
                int maxx;
                int minx;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    minx = Math.min(this._zoomx, this._zoomxn);
                    maxx = Math.max(this._zoomx, this._zoomxn);
                    miny = Math.min(this._zoomy, this._zoomyn);
                    maxy = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                }
                if (y > this._zoomy) {
                    this._zoomxn = x;
                    this._zoomyn = y;
                    minx = Math.min(this._zoomx, this._zoomxn);
                    maxx = Math.max(this._zoomx, this._zoomxn);
                    miny = Math.min(this._zoomy, this._zoomyn);
                    maxy = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(minx, miny, maxx - minx, maxy - miny);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int y_diff;
                int x_diff;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    x_diff = Math.abs(this._zoomx - this._zoomxn);
                    y_diff = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
                }
                if (y < this._zoomy) {
                    this._zoomxn = x;
                    this._zoomyn = y;
                    x_diff = Math.abs(this._zoomx - this._zoomxn);
                    y_diff = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - x_diff, this._zoomy - 15 - y_diff, 30 + x_diff * 2, 30 + y_diff * 2);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    void _zoomStart(int x, int y) {
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        this._zoomx = x;
        this._zoomy = y;
        this._zooming = true;
    }

    public class DragListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent event) {
            PlotBox.this._zoomBox(event.getX(), event.getY());
        }

        public void mouseMoved(MouseEvent event) {
        }
    }

    public class ZoomListener
    implements MouseListener {
        public void mouseClicked(MouseEvent event) {
            PlotBox.this.requestFocus();
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            if ((event.getModifiers() & 0x10) != 0 || event.getModifiers() == 0) {
                PlotBox.this._zoomStart(event.getX(), event.getY());
            }
        }

        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 0x10) != 0 || event.getModifiers() == 0) {
                PlotBox.this._zoom(event.getX(), event.getY());
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == PlotBox.this._fillButton) {
                PlotBox.this.fillPlot();
            } else if (event.getSource() == PlotBox.this._printButton) {
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat format = job.pageDialog(job.defaultPage());
                job.setPrintable(PlotBox.this, format);
                if (job.printDialog()) {
                    try {
                        job.print();
                    }
                    catch (Exception ex) {
                        Container ancestor = PlotBox.this.getTopLevelAncestor();
                        JOptionPane.showMessageDialog(ancestor, "Printing failed:\n" + ex.toString(), "Print Error", 2);
                    }
                }
            } else if (event.getSource() == PlotBox.this._resetButton) {
                PlotBox.this.resetAxes();
            }
        }
    }
}

