/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.util.Arrays;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.plot.MarkStyle;

public class PlotState {
    private StarTableColumn xCol_;
    private StarTableColumn yCol_;
    private boolean xLog_;
    private boolean yLog_;
    private boolean xFlip_;
    private boolean yFlip_;
    private boolean grid_;
    private RowSubset[] usedSubsets_;
    private MarkStyle[] styles_;
    private boolean[] regressions_;

    public PlotState(StarTableColumn xcol, StarTableColumn ycol) {
        this.xCol_ = xcol;
        this.yCol_ = ycol;
    }

    public StarTableColumn getXColumn() {
        return this.xCol_;
    }

    public StarTableColumn getYColumn() {
        return this.yCol_;
    }

    public void setXLog(boolean xlog) {
        this.xLog_ = xlog;
    }

    public boolean isXLog() {
        return this.xLog_;
    }

    public void setYLog(boolean ylog) {
        this.yLog_ = ylog;
    }

    public boolean isYLog() {
        return this.yLog_;
    }

    public void setXFlip(boolean xflip) {
        this.xFlip_ = xflip;
    }

    public boolean isXFlip() {
        return this.xFlip_;
    }

    public void setYFlip(boolean yflip) {
        this.yFlip_ = yflip;
    }

    public boolean isYFlip() {
        return this.yFlip_;
    }

    public void setGrid(boolean grid) {
        this.grid_ = grid;
    }

    public boolean hasGrid() {
        return this.grid_;
    }

    public void setSubsets(RowSubset[] subsets, MarkStyle[] styles, boolean[] regressions) {
        int nset = subsets.length;
        if (styles.length != nset || regressions.length != nset) {
            throw new IllegalArgumentException("Unequal arrays lengths");
        }
        this.usedSubsets_ = subsets;
        this.styles_ = styles;
        this.regressions_ = regressions;
    }

    public RowSubset[] getSubsets() {
        return this.usedSubsets_;
    }

    public MarkStyle[] getStyles() {
        return this.styles_;
    }

    public boolean[] getRegressions() {
        return this.regressions_;
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof PlotState) {
            PlotState other = (PlotState)otherObject;
            return other instanceof PlotState && this.xCol_.equals(other.xCol_) && this.yCol_.equals(other.yCol_) && this.xLog_ == other.xLog_ && this.yLog_ == other.yLog_ && this.xFlip_ == other.xFlip_ && this.yFlip_ == other.yFlip_ && this.grid_ == other.grid_ && Arrays.equals(this.usedSubsets_, other.usedSubsets_) && Arrays.equals(this.styles_, other.styles_) && Arrays.equals(this.regressions_, other.regressions_);
        }
        return false;
    }

    public int hashCode() {
        int code = 5;
        code = 23 * code + (this.xCol_ == null ? 99 : this.xCol_.hashCode());
        code = 23 * code + (this.yCol_ == null ? 99 : this.yCol_.hashCode());
        code = 23 * code + (this.xLog_ ? 0 : 1);
        code = 23 * code + (this.yLog_ ? 0 : 1);
        code = 23 * code + (this.xFlip_ ? 0 : 1);
        code = 23 * code + (this.yFlip_ ? 0 : 1);
        code = 23 * code + (this.grid_ ? 0 : 1);
        int i = 0;
        while (i < this.usedSubsets_.length) {
            code = 23 * code + this.usedSubsets_[i].hashCode();
            code = 23 * code + this.styles_[i].hashCode();
            code = 23 * code + (this.regressions_[i] ? 0 : 1);
            ++i;
        }
        return code;
    }

    public boolean sameAxes(PlotState other) {
        return this.sameData(other) && this.xLog_ == other.xLog_ && this.yLog_ == other.yLog_ && this.xFlip_ == other.xFlip_ && this.yFlip_ == other.yFlip_;
    }

    public boolean sameData(PlotState other) {
        return other != null && this.xCol_ == other.xCol_ && this.yCol_ == other.yCol_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer().append("xCol=").append(this.xCol_).append(",").append("yCol=").append(this.yCol_).append(",").append("xLog=").append(this.xLog_).append(",").append("yLog=").append(this.yLog_).append(",").append("xFlip=").append(this.xFlip_).append(",").append("yFlip=").append(this.yFlip_).append(",").append("grid=").append(this.grid_).append("(");
        int i = 0;
        while (i < this.usedSubsets_.length) {
            sbuf.append(this.usedSubsets_[i].getName());
            if (i > 0) {
                sbuf.append(",");
            }
            ++i;
        }
        sbuf.append(")");
        return sbuf.toString();
    }
}

