/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.OverlayLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import org.jibble.epsgraphics.EpsGraphics2D;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.CheckBoxMenu;
import uk.ac.starlink.topcat.CheckBoxStack;
import uk.ac.starlink.topcat.ColumnCellRenderer;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatViewWindow;
import uk.ac.starlink.topcat.plot.BlobPanel;
import uk.ac.starlink.topcat.plot.MarkStyle;
import uk.ac.starlink.topcat.plot.MarkStyleProfile;
import uk.ac.starlink.topcat.plot.OrderedSelectionRecorder;
import uk.ac.starlink.topcat.plot.PlotState;
import uk.ac.starlink.topcat.plot.PlotSurface;
import uk.ac.starlink.topcat.plot.PointRegistry;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.PtPlotSurface;
import uk.ac.starlink.topcat.plot.ScatterPlot;
import uk.ac.starlink.topcat.plot.SurfaceListener;
import uk.ac.starlink.util.gui.ErrorDialog;

public class PlotWindow
extends TopcatViewWindow
implements ActionListener,
ListSelectionListener,
ItemListener,
SurfaceListener {
    private final TopcatModel tcModel_;
    private final OptionsListModel subsets_;
    private final ScatterPlot plot_;
    private final BlobPanel blobPanel_;
    private final JComboBox xColBox_;
    private final JComboBox yColBox_;
    private final JCheckBox xLogBox_;
    private final JCheckBox yLogBox_;
    private final JCheckBox xFlipBox_;
    private final JCheckBox yFlipBox_;
    private final ListSelectionModel subSelModel_;
    private final ListSelectionModel regressionSelModel_;
    private final ButtonModel gridModel_;
    private final OrderedSelectionRecorder subSelRecorder_;
    private final Action fromvisibleAction_;
    private final Action blobAction_;
    private final Action regressdataAction_;
    private JFileChooser exportSaver_;
    private FileFilter psFilter_;
    private FileFilter gifFilter_;
    private BitSet visibleRows_;
    private PointRegistry visiblePoints_;
    private MarkStyleProfile markers_;
    private boolean activeBlob_;
    private boolean replotted_;
    private static final Object EPS;
    private static final Object GIF;
    private static final double MILLISECONDS_PER_YEAR = 3.15576E10;
    private static Logger logger;
    private static final MarkStyleProfile MARKERS1;
    private static final MarkStyleProfile MARKERS2;
    private static final MarkStyleProfile MARKERS3;
    private static final MarkStyleProfile MARKERS4;
    private static final MarkStyleProfile MARKERS5;
    static final MarkStyleProfile[] MARKER_PROFILES;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$PlotWindow;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;

    public PlotWindow(TopcatModel tcModel, Component parent) {
        super(tcModel, "Table Plotter", parent);
        this.tcModel_ = tcModel;
        this.subsets_ = this.tcModel_.getSubsets();
        JPanel xConfig = new JPanel();
        JPanel yConfig = new JPanel();
        xConfig.setBorder(AuxWindow.makeTitledBorder("X axis"));
        yConfig.setBorder(AuxWindow.makeTitledBorder("Y axis"));
        Box axisBox = new Box(1);
        axisBox.add(xConfig);
        axisBox.add(Box.createGlue());
        axisBox.add(yConfig);
        this.getControlPanel().add(axisBox);
        this.xColBox_ = this.makePlottableColumnComboBox();
        this.yColBox_ = this.makePlottableColumnComboBox();
        int numCols = this.xColBox_.getItemCount();
        if (!$assertionsDisabled && numCols != this.yColBox_.getItemCount()) {
            throw new AssertionError();
        }
        if (numCols < 2) {
            JOptionPane.showMessageDialog(null, "Too few numeric columns in table", "Plot error", 0);
            this.dispose();
        }
        xConfig.add(this.xColBox_);
        yConfig.add(this.yColBox_);
        this.xColBox_.setSelectedIndex(0);
        this.yColBox_.setSelectedIndex(1);
        this.xColBox_.addActionListener(this);
        this.yColBox_.addActionListener(this);
        this.xLogBox_ = new JCheckBox("Log plot");
        this.yLogBox_ = new JCheckBox("Log plot");
        xConfig.add(this.xLogBox_);
        yConfig.add(this.yLogBox_);
        this.xLogBox_.addActionListener(this);
        this.yLogBox_.addActionListener(this);
        this.xFlipBox_ = new JCheckBox("Flip");
        this.yFlipBox_ = new JCheckBox("Flip");
        xConfig.add(this.xFlipBox_);
        yConfig.add(this.yFlipBox_);
        this.xFlipBox_.addActionListener(this);
        this.yFlipBox_.addActionListener(this);
        AxisListener axisListener = new AxisListener();
        this.xColBox_.addItemListener(axisListener);
        this.yColBox_.addItemListener(axisListener);
        CheckBoxMenu subMenu = this.subsets_.makeCheckBoxMenu("Points");
        subMenu.setMnemonic(79);
        this.subSelModel_ = subMenu.getSelectionModel();
        CheckBoxStack stack = new CheckBoxStack(this.subsets_);
        JScrollPane stackPanel = new JScrollPane(stack);
        stackPanel.setBorder(AuxWindow.makeTitledBorder("Row subsets"));
        this.getControlPanel().add(stackPanel);
        stack.setSelectionModel(this.subSelModel_);
        this.subSelModel_.addSelectionInterval(0, 0);
        int nrsets = this.subsets_.size();
        RowSubset currentSet = this.tcModel_.getSelectedSubset();
        if (currentSet != RowSubset.ALL) {
            int i = 1;
            while (i < nrsets) {
                if (this.subsets_.get(i) == currentSet) {
                    this.subSelModel_.addSelectionInterval(i, i);
                }
                ++i;
            }
        }
        this.subSelRecorder_ = new OrderedSelectionRecorder(this.subSelModel_);
        this.subSelModel_.addListSelectionListener(this);
        this.subSelModel_.addListSelectionListener(this.subSelRecorder_);
        CheckBoxMenu regressSelMenu = this.subsets_.makeCheckBoxMenu("Plot Regression For Subsets ...");
        regressSelMenu.setIcon(ResourceIcon.PLOT_LINES);
        this.regressionSelModel_ = regressSelMenu.getSelectionModel();
        this.regressionSelModel_.addListSelectionListener(this);
        this.regressdataAction_ = new AbstractAction("Display Regression Coefficients", ResourceIcon.EQUATION){

            public void actionPerformed(ActionEvent evt) {
                PlotWindow.this.plot_.displayRegressionCoefficients();
            }
        };
        this.regressdataAction_.setEnabled(false);
        this.plot_ = new ScatterPlot(new PtPlotSurface(this)){
            int lastHeight_;
            int lastWidth_;

            public void paint(Graphics g) {
                super.paint(g);
                int height = this.getHeight();
                int width = this.getWidth();
                if (PlotWindow.this.replotted_ || height != this.lastHeight_ || width != this.lastWidth_) {
                    PlotWindow.this.recordVisiblePoints(this.getState(), this.getPoints(), this.getSurface());
                    this.lastHeight_ = height;
                    this.lastWidth_ = width;
                    PlotWindow.this.replotted_ = false;
                }
            }
        };
        JPanel plotPanel = new JPanel();
        this.blobPanel_ = new BlobPanel();
        this.blobPanel_.setVisible(false);
        plotPanel.setLayout(new OverlayLayout(plotPanel));
        plotPanel.add(this.blobPanel_);
        plotPanel.add(this.plot_);
        plotPanel.setPreferredSize(new Dimension(500, 300));
        this.plot_.getSurface().getComponent().addMouseListener(new PointClickListener());
        JPanel mainArea = this.getMainArea();
        mainArea.add((Component)plotPanel, "Center");
        long nRows = this.tcModel_.getDataModel().getRowCount();
        this.markers_ = nRows > 20000L ? MARKERS1 : (nRows > 2000L ? MARKERS2 : (nRows > 200L ? MARKERS3 : (nRows > 20L ? MARKERS4 : MARKERS5)));
        if (!$assertionsDisabled && this.markers_ == null) {
            throw new AssertionError();
        }
        String gridName = "Show Grid";
        ImageIcon gridIcon = ResourceIcon.GRID_ON;
        String gridTip = "Select whether grid lines are displayed";
        JToggleButton gridButton = new JToggleButton(gridIcon);
        gridButton.setToolTipText(gridTip);
        this.gridModel_ = gridButton.getModel();
        this.gridModel_.setSelected(true);
        this.gridModel_.addActionListener(this);
        JCheckBoxMenuItem gridMenuItem = new JCheckBoxMenuItem(gridName, gridIcon);
        gridMenuItem.setModel(this.gridModel_);
        BasicAction resizeAction = new BasicAction("Rescale", ResourceIcon.RESIZE, "Rescale the plot to show all points"){

            public void actionPerformed(ActionEvent evt) {
                PlotWindow.this.plot_.rescale();
                PlotWindow.this.forceReplot();
            }
        };
        BasicAction replotAction = new BasicAction("Replot", ResourceIcon.REDO, "Redraw the plot"){

            public void actionPerformed(ActionEvent evt) {
                PlotWindow.this.doReplot(true, true);
            }
        };
        ExportAction gifAction = new ExportAction(GIF, "Export as GIF", ResourceIcon.IMAGE, "Save plot as a GIF file");
        ExportAction epsAction = new ExportAction(EPS, "Export as EPS", ResourceIcon.PRINT, "Export to Encapsulated Postscript file");
        int fileMenuPos = 0;
        this.getFileMenu().insert(epsAction, fileMenuPos++);
        this.getFileMenu().insert(gifAction, fileMenuPos++);
        this.getFileMenu().insertSeparator(fileMenuPos++);
        JMenu plotMenu = new JMenu("Plot");
        plotMenu.setMnemonic(80);
        plotMenu.add(resizeAction);
        plotMenu.add(gridMenuItem);
        plotMenu.add(replotAction);
        this.getJMenuBar().add(plotMenu);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        this.blobAction_ = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if (PlotWindow.this.activeBlob_) {
                    PlotWindow.this.useBlob();
                    PlotWindow.this.setActiveBlob(false);
                } else {
                    PlotWindow.this.setActiveBlob(true);
                }
            }
        };
        this.setActiveBlob(false);
        this.blobAction_.setEnabled(false);
        this.fromvisibleAction_ = new BasicAction("New subset from visible", ResourceIcon.VISIBLE_SUBSET, "Define a new row subset containing only currently visible points"){

            public void actionPerformed(ActionEvent evt) {
                String name = PlotWindow.this.tcModel_.enquireSubsetName(PlotWindow.this);
                if (name != null) {
                    int inew = PlotWindow.this.subsets_.size();
                    BitsRowSubset visibleSet = new BitsRowSubset(name, PlotWindow.this.visibleRows_);
                    PlotWindow.this.subsets_.add(visibleSet);
                    PlotWindow.this.subSelModel_.addSelectionInterval(inew, inew);
                }
            }
        };
        this.fromvisibleAction_.setEnabled(false);
        subsetMenu.add(this.blobAction_);
        subsetMenu.add(this.fromvisibleAction_);
        this.getJMenuBar().add(subsetMenu);
        JMenu markerMenu = new JMenu("Marker Types");
        markerMenu.setMnemonic(77);
        MarkStyleProfile[] profiles = MARKER_PROFILES;
        int i = 0;
        while (i < profiles.length) {
            final MarkStyleProfile profile = profiles[i];
            String name = profile.getName();
            Icon icon = profile.getIcon();
            BasicAction profileAct = new BasicAction(name, icon, "Set default marker types to " + name){

                public void actionPerformed(ActionEvent evt) {
                    PlotWindow.this.markers_ = profile;
                    PlotWindow.this.replot();
                }
            };
            markerMenu.add(profileAct);
            ++i;
        }
        this.getJMenuBar().add(markerMenu);
        this.getJMenuBar().add(subMenu);
        JMenu regressionMenu = new JMenu("Regression");
        regressionMenu.setMnemonic(82);
        regressionMenu.add(regressSelMenu);
        regressionMenu.add(this.regressdataAction_);
        this.getJMenuBar().add(regressionMenu);
        this.getToolBar().add(epsAction);
        this.getToolBar().add(gifAction);
        this.getToolBar().addSeparator();
        this.getToolBar().add(resizeAction);
        this.getToolBar().add(gridButton);
        this.getToolBar().add(replotAction);
        this.getToolBar().add(this.blobAction_);
        this.getToolBar().add(this.fromvisibleAction_);
        this.getToolBar().addSeparator();
        this.addHelp("PlotWindow");
        this.replot();
        this.pack();
        this.setVisible(true);
    }

    public void replot() {
        this.doReplot(false, false);
    }

    public void forceReplot() {
        this.doReplot(true, false);
    }

    private void doReplot(boolean forcePlot, boolean forceData) {
        PlotState state = this.getPlotState();
        PlotState lastState = this.plot_.getState();
        if (forcePlot || !state.equals(lastState)) {
            this.setActiveBlob(false);
            this.plot_.setState(state);
            if (forceData || !state.sameData(lastState)) {
                Points points;
                try {
                    points = this.readPoints(state);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Error reading table data", e);
                    return;
                }
                this.plot_.setPoints(points);
            }
            if (!state.sameAxes(lastState)) {
                this.plot_.rescale();
            }
            this.replotted_ = true;
            this.plot_.repaint();
        }
    }

    private void recordVisiblePoints(PlotState state, Points points, PlotSurface surface) {
        double[] xv = points.getXVector();
        double[] yv = points.getYVector();
        int np = points.getCount();
        RowSubset[] sets = state.getSubsets();
        int nset = sets.length;
        BitSet visible = new BitSet();
        PointRegistry plotted = new PointRegistry();
        int nVisible = 0;
        int ip = 0;
        while (ip < np) {
            Point point = surface.dataToGraphics(xv[ip], yv[ip], true);
            if (point != null) {
                int xp = point.x;
                int yp = point.y;
                long lp = ip;
                int is = 0;
                while (is < nset) {
                    if (sets[is].isIncluded(lp)) {
                        visible.set(ip);
                        plotted.addPoint(ip, point);
                        ++nVisible;
                        break;
                    }
                    ++is;
                }
            }
            ++ip;
        }
        plotted.ready();
        this.visiblePoints_ = plotted;
        this.visibleRows_ = visible;
        this.fromvisibleAction_.setEnabled(nVisible > 0);
        this.blobAction_.setEnabled(nVisible > 0);
    }

    public void highlightRow(long lrow) {
        this.plot_.setActivePoint(AbstractStarTable.checkedLongToInt((long)lrow));
    }

    private void setActiveBlob(boolean active) {
        this.activeBlob_ = active;
        this.blobPanel_.clear();
        this.blobPanel_.setVisible(active);
        this.blobAction_.putValue("Name", active ? "Finish Drawing Region" : "Draw Subset Region");
        this.blobAction_.putValue("SmallIcon", active ? ResourceIcon.BLOB_SUBSET_END : ResourceIcon.BLOB_SUBSET);
        this.blobAction_.putValue("ShortDescription", active ? "Define subset from currently-drawn region" : "Draw a region on the plot to define a new row subset");
    }

    private void useBlob() {
        Shape blob = this.blobPanel_.getBlob();
        String name = this.tcModel_.enquireSubsetName(this);
        if (name != null) {
            int inew = this.subsets_.size();
            BitsRowSubset blobSet = new BitsRowSubset(name, this.visiblePoints_.getContainedPoints(blob));
            this.subsets_.add(blobSet);
            this.subSelModel_.addSelectionInterval(inew, inew);
        }
    }

    private void exportEPS(OutputStream ostrm) throws IOException {
        Rectangle bounds = this.plot_.getBounds();
        EpsGraphics2D g2 = new EpsGraphics2D(this.tcModel_.getLabel(), ostrm, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
        this.plot_.print(g2);
        g2.close();
    }

    private void exportGif(OutputStream ostrm) throws IOException {
        ScatterPlot plot = this.plot_;
        int w = plot.getWidth();
        int h = plot.getHeight();
        BufferedImage image = new BufferedImage(w, h, 6);
        plot.paint(image.getGraphics());
        HashSet<Integer> colors = new HashSet<Integer>();
        int ix = 0;
        while (ix < w) {
            int iy = 0;
            while (iy < h) {
                colors.add(new Integer(image.getRGB(ix, iy)));
                ++iy;
            }
            ++ix;
        }
        if (colors.size() > 254) {
            image = new BufferedImage(w, h, 13);
            plot.paint(image.getGraphics());
        }
        new GifEncoder(image, ostrm).encode();
    }

    private JFileChooser getExportSaver() {
        if (this.exportSaver_ == null) {
            this.exportSaver_ = new JFileChooser(".");
            this.psFilter_ = new FileFilter(){

                public String getDescription() {
                    return ".ps, .eps";
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName();
                    int dotpos = name.indexOf(46);
                    if (dotpos > 0) {
                        String ext = name.substring(dotpos + 1).toLowerCase();
                        return ext.equals("ps") || ext.equals("eps");
                    }
                    return false;
                }
            };
            this.gifFilter_ = new FileFilter(){

                public String getDescription() {
                    return ".gif";
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName();
                    int dotpos = name.indexOf(46);
                    if (dotpos > 0) {
                        String ext = name.substring(dotpos + 1).toLowerCase();
                        return ext.equals("gif");
                    }
                    return false;
                }
            };
            this.exportSaver_.setAcceptAllFileFilterUsed(true);
            this.exportSaver_.addChoosableFileFilter(this.psFilter_);
            this.exportSaver_.addChoosableFileFilter(this.gifFilter_);
        }
        return this.exportSaver_;
    }

    public PlotState getPlotState() {
        PlotState state = new PlotState((StarTableColumn)this.xColBox_.getSelectedItem(), (StarTableColumn)this.yColBox_.getSelectedItem());
        state.setXLog(this.xLogBox_.isSelected());
        state.setYLog(this.yLogBox_.isSelected());
        state.setXFlip(this.xFlipBox_.isSelected());
        state.setYFlip(this.yFlipBox_.isSelected());
        state.setGrid(this.gridModel_.isSelected());
        int[] selection = this.subSelRecorder_.getOrderedSelection();
        int nrsets = selection.length;
        RowSubset[] usedSubsets = new RowSubset[nrsets];
        MarkStyle[] styles = new MarkStyle[nrsets];
        boolean[] regressions = new boolean[nrsets];
        int isel = 0;
        while (isel < nrsets) {
            int isub = selection[isel];
            usedSubsets[isel] = (RowSubset)this.subsets_.get(isub);
            styles[isel] = this.markers_.getStyle(isub);
            regressions[isel] = this.regressionSelModel_.isSelectedIndex(isub);
            ++isel;
        }
        state.setSubsets(usedSubsets, styles, regressions);
        return state;
    }

    public Points readPoints(PlotState state) throws IOException {
        int xcol = this.getColumnIndex((TableColumn)state.getXColumn());
        int ycol = this.getColumnIndex((TableColumn)state.getYColumn());
        PlasticStarTable dataModel = this.tcModel_.getDataModel();
        int nrow = AbstractStarTable.checkedLongToInt((long)dataModel.getRowCount());
        double[] x = new double[nrow];
        double[] y = new double[nrow];
        RowSequence rseq = dataModel.getRowSequence();
        int irow = 0;
        while (rseq.next()) {
            x[irow] = this.doubleValue(rseq.getCell(xcol));
            y[irow] = this.doubleValue(rseq.getCell(ycol));
            ++irow;
        }
        rseq.close();
        return new Points(x, y);
    }

    private JComboBox makePlottableColumnComboBox() {
        RestrictedColumnComboBoxModel boxModel = new RestrictedColumnComboBoxModel(this.tcModel_.getColumnModel(), false){

            public boolean acceptColumn(ColumnInfo cinfo) {
                Class clazz;
                return (class$java$lang$Number == null ? (class$java$lang$Number = PlotWindow.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz = cinfo.getContentClass()) || (class$java$util$Date == null ? (class$java$util$Date = PlotWindow.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(clazz);
            }
        };
        JComboBox box = new JComboBox(boxModel);
        box.setRenderer(new ColumnCellRenderer(box));
        return box;
    }

    public int getColumnIndex(TableColumn tcol) {
        return tcol.getModelIndex();
    }

    private double doubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Date) {
            long milliseconds = ((Date)value).getTime();
            return 1970.0 + (double)milliseconds / 3.15576E10;
        }
        return Double.NaN;
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.regressionSelModel_) {
            this.regressdataAction_.setEnabled(!this.regressionSelModel_.isSelectionEmpty());
        }
        this.replot();
    }

    public void actionPerformed(ActionEvent evt) {
        this.replot();
    }

    public void itemStateChanged(ItemEvent evt) {
        this.replot();
    }

    public void surfaceChanged() {
        this.forceReplot();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$PlotWindow == null ? (class$uk$ac$starlink$topcat$plot$PlotWindow = PlotWindow.class$("uk.ac.starlink.topcat.plot.PlotWindow")) : class$uk$ac$starlink$topcat$plot$PlotWindow).desiredAssertionStatus();
        EPS = "EPS";
        GIF = "GIF";
        logger = Logger.getLogger("uk.ac.starlink.topcat.plot");
        MARKERS1 = MarkStyleProfile.points("Pixels");
        MARKER_PROFILES = new MarkStyleProfile[]{MARKERS1, MARKERS2 = MarkStyleProfile.spots("Dots", 1), MARKERS3 = MarkStyleProfile.spots("Spots", 2), MARKERS4 = MarkStyleProfile.filledShapes("Small Coloured Shapes", 3, null), MARKERS5 = MarkStyleProfile.filledShapes("Medium Coloured Shapes", 4, null), MarkStyleProfile.filledShapes("Large Coloured Shapes", 5, null), MarkStyleProfile.filledShapes("Small Black Shapes", 3, Color.black), MarkStyleProfile.filledShapes("Medium Black Shapes", 4, Color.black), MarkStyleProfile.filledShapes("Large Black Shapes", 5, Color.black), MarkStyleProfile.openShapes("Small Coloured Outlines", 3, null), MarkStyleProfile.openShapes("Medium Coloured Outlines", 4, null), MarkStyleProfile.openShapes("Large Coloured Outlines", 5, null), MarkStyleProfile.openShapes("Small Black Outlines", 3, Color.black), MarkStyleProfile.openShapes("Medium Black Outlines", 4, Color.black), MarkStyleProfile.openShapes("Large Black Outlines", 5, Color.black), MarkStyleProfile.ghosts("Faint Transparent Pixels", 0, 0.1f), MarkStyleProfile.ghosts("Medium Transparent Pixels", 0, 0.4f), MarkStyleProfile.ghosts("Faint Transparent Dots", 1, 0.1f), MarkStyleProfile.ghosts("Medium Transparent Dots", 1, 0.4f)};
    }

    private class AxisListener
    implements ItemListener {
        private StarTableColumn lastXAxis_;
        private StarTableColumn lastYAxis_;

        private AxisListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                StarTableColumn xAxis = (StarTableColumn)PlotWindow.this.xColBox_.getSelectedItem();
                StarTableColumn yAxis = (StarTableColumn)PlotWindow.this.yColBox_.getSelectedItem();
                boolean xChanged = xAxis != this.lastXAxis_;
                boolean yChanged = yAxis != this.lastYAxis_;
                this.lastXAxis_ = xAxis;
                this.lastYAxis_ = yAxis;
                if (xChanged) {
                    PlotWindow.this.xLogBox_.setSelected(false);
                    PlotWindow.this.xFlipBox_.setSelected(false);
                }
                if (yChanged) {
                    PlotWindow.this.yLogBox_.setSelected(false);
                    PlotWindow.this.yFlipBox_.setSelected(false);
                }
                if (xChanged || yChanged) {
                    PlotWindow.this.regressionSelModel_.clearSelection();
                }
            }
        }
    }

    private class PointClickListener
    extends MouseAdapter {
        private PointClickListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            int butt = evt.getButton();
            if (butt == 1) {
                int ip = PlotWindow.this.visiblePoints_.getClosestPoint(evt.getPoint(), 4);
                if (ip >= 0) {
                    PlotWindow.this.tcModel_.highlightRow(ip);
                } else {
                    PlotWindow.this.plot_.setActivePoint(-1);
                }
            }
        }
    }

    private class ExportAction
    extends BasicAction {
        final Object format_;
        static final /* synthetic */ boolean $assertionsDisabled;

        ExportAction(Object format, String name, Icon icon, String desc) {
            super(name, icon, desc);
            this.format_ = format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent evt) {
            FileFilter filter;
            String title;
            String approve;
            JFileChooser chooser = PlotWindow.this.getExportSaver();
            if (this.format_ == EPS) {
                approve = "Write EPS";
                title = "Export plot as EPS";
                filter = PlotWindow.this.psFilter_;
            } else {
                if (this.format_ != GIF) throw new AssertionError();
                approve = "Write GIF";
                title = "Export plot as GIF";
                filter = PlotWindow.this.gifFilter_;
            }
            chooser.setDialogTitle(title);
            chooser.setFileFilter(filter);
            if (chooser.showDialog(PlotWindow.this, approve) != 0) return;
            OutputStream ostrm = null;
            File file = chooser.getSelectedFile();
            ostrm = new BufferedOutputStream(new FileOutputStream(file));
            if (this.format_ == GIF) {
                PlotWindow.this.exportGif(ostrm);
            } else if (this.format_ == EPS) {
                PlotWindow.this.exportEPS(ostrm);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            Object var9_9 = null;
            if (ostrm == null) return;
            try {
                ostrm.close();
                return;
            }
            catch (IOException e2) {}
            return;
            {
                catch (IOException e) {
                    ErrorDialog.showError((Component)PlotWindow.this, (String)"Write Error", (Throwable)e);
                    Object var9_10 = null;
                    if (ostrm == null) return;
                    try {
                        ostrm.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ostrm == null) throw throwable;
                try {
                    ostrm.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$PlotWindow == null ? (class$uk$ac$starlink$topcat$plot$PlotWindow = PlotWindow.class$("uk.ac.starlink.topcat.plot.PlotWindow")) : class$uk$ac$starlink$topcat$plot$PlotWindow).desiredAssertionStatus();
        }
    }
}

